/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.service.buffer;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.common.buffer.impl.BufferFrontedFileStoreCache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.services.BufferServiceImpl;

public class TestLocalBufferService {
    @Test
    public void testCheckMemPropertyGotSet() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(true);
        svc.start();
        Assert.assertTrue((String)"Not Directory", (boolean)svc.getBufferDirectory().isDirectory());
        Assert.assertTrue((String)"does not exist", (boolean)svc.getBufferDirectory().exists());
        Assert.assertTrue((String)"does not end with one", (boolean)svc.getBufferDirectory().getParent().endsWith("1"));
        Assert.assertTrue((boolean)svc.isUseDisk());
        BufferManagerImpl mgr = svc.getBufferManager();
        SplittableStorageManager ssm = (SplittableStorageManager)((BufferFrontedFileStoreCache)mgr.getCache()).getStorageManager();
        Assert.assertTrue((boolean)((FileStorageManager)ssm.getStorageManager()).getDirectory().endsWith(svc.getBufferDirectory().getName()));
    }

    @Test
    public void testCheckMemPropertyGotSet2() throws Exception {
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(false);
        svc.start();
        Assert.assertFalse((boolean)svc.isUseDisk());
    }

    @Test
    public void testSchemaSize() throws Exception {
        int i;
        ArrayList<Constant> schema = new ArrayList<Constant>();
        for (i = 0; i < 82; ++i) {
            schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.STRING));
        }
        for (i = 0; i < 11; ++i) {
            schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.DATE));
        }
        schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.LONG));
        schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.SHORT));
        for (i = 0; i < 20; ++i) {
            schema.add(new Constant(null, DataTypeManager.DefaultDataClasses.BIG_DECIMAL));
        }
        BufferServiceImpl svc = new BufferServiceImpl();
        svc.setDiskDirectory(UnitTestUtil.getTestScratchPath() + "/teiid/1");
        svc.setUseDisk(false);
        svc.start();
        BufferManagerImpl mgr = svc.getBufferManager();
        Assert.assertEquals((long)0x335500L, (long)mgr.getSchemaSize(schema));
        Assert.assertEquals((long)128L, (long)mgr.getProcessorBatchSize(schema));
    }
}

