/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.progress.VerificationMode;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.security.Credentials;
import org.teiid.security.SecurityHelper;
import org.teiid.services.SessionServiceImpl;
import org.teiid.services.TeiidLoginContext;

public class TestSessionServiceImpl {
    public void validateSession(boolean securityEnabled) throws Exception {
        final TeiidLoginContext impl = (TeiidLoginContext)Mockito.mock(TeiidLoginContext.class);
        Mockito.stub((Object)impl.getUserName()).toReturn((Object)"steve@somedomain");
        Mockito.stub((Object)impl.getLoginContext()).toReturn(Mockito.mock(LoginContext.class));
        ArrayList<String> domains = new ArrayList<String>();
        domains.add("somedomain");
        SessionServiceImpl ssi = new SessionServiceImpl(){

            protected TeiidLoginContext authenticate(String userName, Credentials credentials, String applicationName, List<String> domains, SecurityHelper helper, boolean passthough) throws LoginException {
                impl.authenticateUser(userName, credentials, applicationName, domains, passthough);
                return impl;
            }
        };
        ssi.setSecurityDomains("somedomain");
        try {
            ssi.validateSession(String.valueOf(1));
            Assert.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
        SessionMetadata info = ssi.createSession("steve", null, "foo", new Properties(), false, true);
        if (securityEnabled) {
            ((TeiidLoginContext)Mockito.verify((Object)impl)).authenticateUser("steve", null, "foo", domains, false);
        }
        String id1 = info.getSessionId();
        ssi.validateSession(id1);
        Assert.assertEquals((long)1L, (long)ssi.getActiveSessionsCount());
        Assert.assertEquals((long)0L, (long)ssi.getSessionsLoggedInToVDB("a", 1).size());
        ssi.closeSession(id1);
        try {
            ssi.validateSession(id1);
            Assert.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
        try {
            ssi.closeSession(id1);
            Assert.fail((String)"exception expected");
        }
        catch (InvalidSessionException e) {
            // empty catch block
        }
    }

    @Test
    public void testvalidateSession() throws Exception {
        this.validateSession(true);
    }

    @Test
    public void testvalidateSession2() throws Exception {
        this.validateSession(false);
    }

    @Test
    public void testActiveVDBWithNoVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name")).toReturn((Object)vdb);
        SessionServiceImpl ssi = new SessionServiceImpl();
        ssi.setVDBRepository(repo);
        ssi.getActiveVDB("name", null);
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getVDB("name");
    }

    @Test
    public void testActiveVDBWithVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name", 1)).toReturn((Object)vdb);
        SessionServiceImpl ssi = new SessionServiceImpl();
        ssi.setVDBRepository(repo);
        ssi.getActiveVDB("name", "1");
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getVDB("name", 1);
    }

    @Test
    public void testActiveVDBNameWithVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name", 1)).toReturn((Object)vdb);
        SessionServiceImpl ssi = new SessionServiceImpl();
        ssi.setVDBRepository(repo);
        ssi.getActiveVDB("name.1", null);
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getVDB("name", 1);
    }

    @Test
    public void testActiveVDBNameWithVersionNonInteger() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name", 1)).toReturn((Object)vdb);
        SessionServiceImpl ssi = new SessionServiceImpl();
        ssi.setVDBRepository(repo);
        try {
            ssi.getActiveVDB("name.x", null);
            Assert.fail((String)"must have failed with non integer version");
        }
        catch (SessionServiceException e) {
            // empty catch block
        }
    }

    @Test
    public void testActiveVDBNameWithVersionAndVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name", 1)).toReturn((Object)vdb);
        SessionServiceImpl ssi = new SessionServiceImpl();
        ssi.setVDBRepository(repo);
        try {
            ssi.getActiveVDB("name.1", "1");
            Assert.fail((String)"must have failed with ambigious version info");
        }
        catch (SessionServiceException e) {
            // empty catch block
        }
        try {
            ssi.getActiveVDB("name..1", null);
            Assert.fail((String)"must have failed with ambigious version info");
        }
        catch (SessionServiceException e) {
            // empty catch block
        }
    }
}

