/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashSet;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.deployers.ExtendedPropertyMetadata;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.translator.TranslatorProperty;

public class ManagedPropertyUtil {
    private static final String TEIID_PROPERTY = "teiid-property";

    public static ManagedProperty convert(Object instance, Method method, TranslatorProperty prop) {
        return (ManagedProperty)ManagedPropertyUtil.convert(instance, method, prop, false);
    }

    private static Object convert(Object instance, Method method, TranslatorProperty prop, boolean needDefaultValue) {
        Class<Object> type = method.getReturnType();
        String[] allowedValues = null;
        Method getter = null;
        boolean readOnly = false;
        if (type == Void.TYPE) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1) {
                throw new TeiidRuntimeException("TranslatorProperty annotation should be placed on valid getter or setter method, " + method + " is not valid.");
            }
            type = types[0];
            try {
                getter = instance.getClass().getMethod("get" + method.getName(), null);
            }
            catch (Exception e) {
                try {
                    getter = instance.getClass().getMethod("get" + method.getName().substring(3), null);
                }
                catch (Exception e1) {}
            }
        } else {
            if (method.getParameterTypes().length != 0) {
                throw new TeiidRuntimeException("TranslatorProperty annotation should be placed on valid getter or setter method, " + method + " is not valid.");
            }
            getter = method;
            try {
                TranslatorUtil.getSetter(instance.getClass(), method);
            }
            catch (Exception e) {
                readOnly = true;
            }
        }
        Object defaultValue = null;
        if (prop.required()) {
            if (prop.advanced()) {
                throw new TeiidRuntimeException("TranslatorProperty annotation should not both be advanced and required " + method);
            }
        } else if (getter != null) {
            try {
                defaultValue = getter.invoke(instance, (Object[])null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (type.isEnum()) {
            ?[] constants = type.getEnumConstants();
            allowedValues = new String[constants.length];
            for (int i = 0; i < constants.length; ++i) {
                allowedValues[i] = ((Enum)constants[i]).name();
            }
            type = String.class;
            if (defaultValue != null) {
                defaultValue = ((Enum)defaultValue).name();
            }
        }
        if (!(defaultValue instanceof Serializable)) {
            defaultValue = null;
        }
        if (needDefaultValue) {
            return defaultValue;
        }
        return ManagedPropertyUtil.createProperty(TranslatorUtil.getPropertyName(method), SimpleMetaType.resolve((String)type.getName()), prop.display(), prop.description(), prop.required(), readOnly, (Serializable)defaultValue, prop.advanced(), prop.masked(), allowedValues);
    }

    public static Object getDefaultValue(Object instance, Method method, TranslatorProperty prop) {
        return ManagedPropertyUtil.convert(instance, method, prop, true);
    }

    public static ManagedProperty convert(ExtendedPropertyMetadata prop) {
        return ManagedPropertyUtil.createProperty(prop.name(), SimpleMetaType.resolve((String)prop.type()), prop.display(), prop.description(), prop.required(), prop.readOnly(), (Serializable)((Object)prop.defaultValue()), prop.advanced(), prop.masked(), prop.allowed());
    }

    public static ManagedProperty createProperty(String name, MetaType type, String displayName, String description, boolean mandatory, boolean readOnly, Serializable defaultValue) {
        DefaultFieldsImpl fields = new DefaultFieldsImpl(name);
        fields.setDescription(description);
        fields.setField("mappedName", (Object)displayName);
        fields.setMetaType(type);
        fields.setField("mandatory", (Object)SimpleValueSupport.wrap((boolean)mandatory));
        fields.setField("readOnly", (Object)SimpleValueSupport.wrap((boolean)readOnly));
        fields.setField(TEIID_PROPERTY, (Object)SimpleValueSupport.wrap((boolean)true));
        if (defaultValue != null) {
            fields.setField("defaultValue", (Object)SimpleValueSupport.wrap((Serializable)defaultValue));
        }
        return new ManagedPropertyImpl((Fields)fields);
    }

    public static ManagedProperty createProperty(String name, SimpleMetaType type, String displayName, String description, boolean mandatory, boolean readOnly, Serializable defaultValue, boolean advanced, boolean masked, String[] allowed) {
        ManagedProperty mp = ManagedPropertyUtil.createProperty(name, (MetaType)type, displayName, description, mandatory, readOnly, defaultValue);
        mp.setField("advanced", (Serializable)SimpleValueSupport.wrap((boolean)advanced));
        mp.setField("masked", (Serializable)SimpleValueSupport.wrap((boolean)masked));
        if (allowed != null) {
            HashSet<SimpleValue> values = new HashSet<SimpleValue>();
            for (String value : allowed) {
                values.add(SimpleValueSupport.wrap((Serializable)((Object)value)));
            }
            mp.setField("legalValues", values);
        }
        return mp;
    }

    public static void markAsTeiidProperty(ManagedProperty mp) {
        mp.setField(TEIID_PROPERTY, (Serializable)SimpleValueSupport.wrap((boolean)true));
    }
}

