/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.TranslatorMetaData;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorProperty;

public class TestTranslatorUtil {
    @Test
    public void testBuildExecutionFactory() throws Exception {
        TranslatorMetaData tm = new TranslatorMetaData();
        tm.addProperty("MyProperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator.class);
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((org.teiid.adminapi.Translator)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
    }

    @Test
    public void testBuildExecutionFactoryCaseInsensitive() throws Exception {
        TranslatorMetaData tm = new TranslatorMetaData();
        tm.addProperty("myproperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator.class);
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((org.teiid.adminapi.Translator)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
    }

    @Translator(name="my-translator")
    public static class MyTranslator
    extends ExecutionFactory<Object, Object> {
        String mine;

        @TranslatorProperty(display="my-property")
        public String getMyProperty() {
            return this.mine;
        }

        public void setMyProperty(String value) {
            this.mine = value;
        }
    }
}

