/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetSocketAddress;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.service.SessionService;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.HostInfo;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerConnectionFactory;
import org.teiid.net.socket.UrlServerDiscovery;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketListener;
import org.teiid.transport.TestSocketRemoting;

public class TestFailover {
    SocketListener listener;
    SocketListener listener1;
    private SocketServerConnectionFactory sscf;
    private InetSocketAddress addr = new InetSocketAddress(0);
    private int logonAttempts;

    @After
    public void tearDown() {
        if (this.listener != null) {
            this.listener.stop();
        }
        if (this.listener1 != null) {
            this.listener1.stop();
        }
    }

    private SocketServerConnection helpEstablishConnection(boolean clientSecure, SSLConfiguration config, Properties socketConfig) throws CommunicationException, ConnectionException {
        this.listener = this.createListener(this.addr, config);
        this.listener1 = this.createListener(this.addr, config);
        this.listener1.stop();
        Properties p = new Properties();
        TeiidURL teiidUrl = new TeiidURL(this.addr.getHostName(), this.listener.getPort(), clientSecure);
        teiidUrl.getHostInfo().add(new HostInfo(this.addr.getHostName(), this.listener1.getPort()));
        String url = teiidUrl.getAppServerURL();
        p.setProperty("serverURL", url);
        p.setProperty("discoveryStategy", UrlServerDiscovery.class.getName());
        p.setProperty("autoFailover", Boolean.TRUE.toString());
        if (this.sscf == null) {
            this.sscf = new SocketServerConnectionFactory();
            this.sscf.initialize(socketConfig);
        }
        return this.sscf.getConnection(p);
    }

    private SocketListener createListener(InetSocketAddress address, SSLConfiguration config) {
        ClientServiceRegistryImpl server = new ClientServiceRegistryImpl();
        server.registerClientService(ILogon.class, (Object)new LogonImpl((SessionService)Mockito.mock(SessionService.class), "fakeCluster"){

            public LogonResult logon(Properties connProps) throws LogonException, ComponentNotFoundException {
                TestFailover.this.logonAttempts++;
                return new LogonResult(new SessionToken("dummy"), "x", 1, "z");
            }

            public ResultsFuture<?> ping() throws InvalidSessionException, TeiidComponentException {
                return ResultsFuture.NULL_FUTURE;
            }

            public void assertIdentity(SessionToken checkSession) throws InvalidSessionException, TeiidComponentException {
                throw new InvalidSessionException();
            }
        }, null);
        server.registerClientService(TestSocketRemoting.FakeService.class, (Object)new TestSocketRemoting.FakeServiceImpl(), null);
        return new SocketListener(address.getPort(), address.getAddress().getHostAddress(), 1024, 1024, 1, config, server, (StorageManager)BufferManagerFactory.getStandaloneBufferManager());
    }

    @Test
    public void testFailover() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        Properties p = new Properties();
        SocketServerConnection conn = this.helpEstablishConnection(false, config, p);
        Assert.assertTrue((boolean)conn.isOpen(1000L));
        this.listener1 = this.createListener(new InetSocketAddress(this.addr.getAddress(), this.listener1.getPort()), config);
        this.listener.stop();
        conn.isOpen(1000L);
        Assert.assertTrue((boolean)conn.isOpen(1000L));
        this.listener1.stop();
        Assert.assertFalse((boolean)conn.isOpen(1000L));
        this.listener = this.createListener(new InetSocketAddress(this.addr.getAddress(), this.listener.getPort()), config);
        Assert.assertTrue((boolean)conn.isOpen(1000L));
        Assert.assertEquals((long)3L, (long)this.logonAttempts);
        conn.close();
    }
}

