/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.teiid.core.util.FileUtils;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;

public class ObjectSerializer {
    private static final Logger log = Logger.getLogger(ObjectSerializer.class);
    private static final String ATTACHMENT_SUFFIX = ".ser";
    private String storagePath;

    public void setAttachmentStoreRoot(String path) {
        this.storagePath = path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T loadAttachment(File attachmentsStore, Class<T> expected) throws IOException, ClassNotFoundException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("loadAttachment, attachmentsStore=" + attachmentsStore));
        }
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new FileInputStream(attachmentsStore));
            T t = expected.cast(ois.readObject());
            return t;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveAttachment(File attachmentsStore, Object attachment) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("saveAttachment, attachmentsStore=" + attachmentsStore + ", attachment=" + attachment));
        }
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new FileOutputStream(attachmentsStore));
            oos.writeObject(attachment);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    public boolean isStale(File cacheFile, long timeAfter) {
        return cacheFile.exists() && timeAfter > cacheFile.lastModified();
    }

    public void removeAttachments(VFSDeploymentUnit vf) {
        String dirName = this.baseDirectory(vf);
        FileUtils.removeDirectoryAndChildren((File)new File(dirName));
    }

    public File getAttachmentPath(VFSDeploymentUnit vf, String baseName) {
        String vfsPath;
        String dirName = this.baseDirectory(vf);
        File f = new File(dirName, vfsPath = baseName + ATTACHMENT_SUFFIX);
        if (!f.getParentFile().exists()) {
            f.getParentFile().mkdirs();
        }
        return f;
    }

    private String baseDirectory(VFSDeploymentUnit vf) {
        String fileName = vf.getRoot().getName();
        String dirName = this.storagePath + File.separator + fileName + File.separator;
        return dirName;
    }

    public <T> T loadSafe(File cacheFile, Class<T> clazz) {
        try {
            if (cacheFile.exists()) {
                return clazz.cast(this.loadAttachment(cacheFile, clazz));
            }
            return null;
        }
        catch (Exception e) {
            LogManager.logWarning((String)"org.teiid.RUNTIME", (Throwable)e, (String)RuntimePlugin.Util.getString("invalid_metadata_file", new Object[]{cacheFile.getAbsolutePath()}));
            cacheFile.delete();
            return null;
        }
    }
}

