/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.templates;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.virtual.VFS;
import org.jboss.virtual.VirtualFile;
import org.teiid.adminapi.impl.TranslatorMetaData;
import org.teiid.deployers.TranslatorMetaDataGroup;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.templates.TranslatorMetadataICF;

public class TranslatorDeploymentTemplate
implements DeploymentTemplate {
    private DeploymentTemplateInfo info;
    private ManagedObjectFactory mof;

    public String getDeploymentName(String deploymentBaseName) {
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null base name.");
        }
        if (!deploymentBaseName.endsWith("-translator.xml")) {
            deploymentBaseName = deploymentBaseName + "-translator.xml";
        }
        return deploymentBaseName;
    }

    public VirtualFile applyTemplate(DeploymentTemplateInfo sourceInfo) throws Exception {
        File dsXml = File.createTempFile(this.getClass().getSimpleName(), "-translator.xml");
        this.writeTemplate(dsXml, sourceInfo);
        return VFS.getRoot((URI)dsXml.toURI());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplate(File dsXml, DeploymentTemplateInfo values) throws Exception {
        TranslatorMetaDataGroup group = new TranslatorMetaDataGroup();
        TranslatorMetaData translator = new TranslatorMetaData();
        this.mof.setInstanceClassFactory(TranslatorMetaData.class, (InstanceClassFactory)new TranslatorMetadataICF(this.mof));
        ManagedObject mo = this.mof.initManagedObject((Object)translator, "teiid", "translator");
        for (ManagedProperty mp : values.getProperties().values()) {
            ManagedProperty dsProp = mo.getProperty(mp.getName());
            if (dsProp == null) continue;
            if (mp.getValue() != null) {
                dsProp.setValue(mp.getValue());
            }
            if (!mp.isMandatory() || mp.getValue() != null || mp.getDefaultValue() != null) continue;
            throw new DeploymentException(RuntimePlugin.Util.getString("required_property_not_exists", new Object[]{mp.getName()}));
        }
        group.addTranslator(translator);
        Class[] classes = new Class[]{TranslatorMetaDataGroup.class};
        JAXBContext context = JAXBContext.newInstance((Class[])classes);
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)new Boolean(true));
        FileWriter fw = null;
        try {
            fw = new FileWriter(dsXml);
            marshaller.marshal((Object)group, (Writer)fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    public void setManagedObjectFactory(ManagedObjectFactory mof) {
        this.mof = mof;
    }
}

