/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.List;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.TeiidComponentException;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.events.EventDistributor;
import org.teiid.logging.LogManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.DdlPlan;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.runtime.RuntimePlugin;

public abstract class EventDistributorImpl
implements EventDistributor {
    public abstract VDBRepository getVdbRepository();

    public void updateMatViewRow(String vdbName, int vdbVersion, String schema, String viewName, List<?> tuple, boolean delete) {
        GlobalTableStore gts;
        VDBMetaData metadata = this.getVdbRepository().getVDB(vdbName, vdbVersion);
        if (metadata != null && (gts = (GlobalTableStore)metadata.getAttachment(GlobalTableStore.class)) != null) {
            try {
                gts.updateMatViewRow(("#MAT_" + schema + '.' + viewName).toUpperCase(), tuple, delete);
            }
            catch (TeiidComponentException e) {
                LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)e, (String)RuntimePlugin.Util.getString("replication_failed", new Object[]{"updateMatViewRow"}));
            }
        }
    }

    public void dataModification(String vdbName, int vdbVersion, String schema, String ... tableNames) {
        this.updateModified(true, vdbName, vdbVersion, schema, tableNames);
    }

    private void updateModified(boolean data, String vdbName, int vdbVersion, String schema, String ... objectNames) {
        Schema s = this.getSchema(vdbName, vdbVersion, schema);
        if (s == null) {
            return;
        }
        long ts = System.currentTimeMillis();
        for (String name : objectNames) {
            Table table = (Table)s.getTables().get(name.toUpperCase());
            if (table == null) continue;
            if (data) {
                table.setLastDataModification(ts);
                continue;
            }
            table.setLastModified(ts);
        }
    }

    public void setColumnStats(String vdbName, int vdbVersion, String schemaName, String tableName, String columnName, ColumnStats stats) {
        Table t = this.getTable(vdbName, vdbVersion, schemaName, tableName);
        if (t == null) {
            return;
        }
        for (Column c : t.getColumns()) {
            if (!c.getName().equalsIgnoreCase(columnName)) continue;
            c.setColumnStats(stats);
            t.setLastModified(System.currentTimeMillis());
            break;
        }
    }

    public void setTableStats(String vdbName, int vdbVersion, String schemaName, String tableName, TableStats stats) {
        Table t = this.getTable(vdbName, vdbVersion, schemaName, tableName);
        if (t == null) {
            return;
        }
        t.setTableStats(stats);
        t.setLastModified(System.currentTimeMillis());
    }

    private Table getTable(String vdbName, int vdbVersion, String schemaName, String tableName) {
        Schema s = this.getSchema(vdbName, vdbVersion, schemaName);
        if (s == null) {
            return null;
        }
        return (Table)s.getTables().get(tableName.toUpperCase());
    }

    private Schema getSchema(String vdbName, int vdbVersion, String schemaName) {
        VDBMetaData vdb = this.getVdbRepository().getVDB(vdbName, vdbVersion);
        if (vdb == null) {
            return null;
        }
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (tm == null) {
            return null;
        }
        return (Schema)tm.getMetadataStore().getSchemas().get(schemaName.toUpperCase());
    }

    public void setInsteadOfTriggerDefinition(String vdbName, int vdbVersion, String schema, String viewName, Table.TriggerEvent triggerEvent, String triggerDefinition, Boolean enabled) {
        Table t = this.getTable(vdbName, vdbVersion, schema, viewName);
        if (t == null) {
            return;
        }
        DdlPlan.alterInsteadOfTrigger((VDBMetaData)this.getVdbRepository().getVDB(vdbName, vdbVersion), (Table)t, (String)triggerDefinition, (Boolean)enabled, (Table.TriggerEvent)triggerEvent);
    }

    public void setProcedureDefinition(String vdbName, int vdbVersion, String schema, String procName, String definition) {
        Schema s = this.getSchema(vdbName, vdbVersion, schema);
        if (s == null) {
            return;
        }
        Procedure p = (Procedure)s.getProcedures().get(procName.toUpperCase());
        if (p == null) {
            return;
        }
        DdlPlan.alterProcedureDefinition((VDBMetaData)this.getVdbRepository().getVDB(vdbName, vdbVersion), (Procedure)p, (String)definition);
    }

    public void setViewDefinition(String vdbName, int vdbVersion, String schema, String viewName, String definition) {
        Table t = this.getTable(vdbName, vdbVersion, schema, viewName);
        if (t == null) {
            return;
        }
        DdlPlan.alterView((VDBMetaData)this.getVdbRepository().getVDB(vdbName, vdbVersion), (Table)t, (String)definition);
    }

    public void setProperty(String vdbName, int vdbVersion, String uuid, String name, String value) {
        VDBMetaData vdb = this.getVdbRepository().getVDB(vdbName, vdbVersion);
        if (vdb == null) {
            return;
        }
        TransformationMetadata tm = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
        if (tm == null) {
            return;
        }
        AbstractMetadataRecord record = DataTierManagerImpl.getByUuid((CompositeMetadataStore)tm.getMetadataStore(), (String)uuid);
        if (record != null) {
            record.setProperty(name, value);
        }
    }
}

