/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.deployers.VDBRepository;
import org.teiid.metadata.index.IndexMetadataFactory;
import org.teiid.metadata.index.RuntimeMetadataPlugin;
import org.teiid.runtime.RuntimePlugin;

public class SystemVDBDeployer {
    private VDBRepository vdbRepository;
    private Closeable file;
    private static final TempFileProvider PROVIDER;

    public void start() {
        try {
            VirtualFile mountPoint = VFS.getChild((String)"content/System.vdb");
            if (!mountPoint.exists()) {
                InputStream contents = Thread.currentThread().getContextClassLoader().getResourceAsStream("System.vdb");
                if (contents == null) {
                    throw new TeiidRuntimeException(RuntimeMetadataPlugin.Util.getString("system_vdb_not_found"));
                }
                this.file = VFS.mountZip((InputStream)contents, (String)"System.vdb", (VirtualFile)mountPoint, (TempFileProvider)PROVIDER);
            }
            this.vdbRepository.setSystemStore(new IndexMetadataFactory(mountPoint).getMetadataStore(null));
        }
        catch (URISyntaxException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("system_vdb_load_error"));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("system_vdb_load_error"));
        }
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void stop() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        try {
            PROVIDER = TempFileProvider.create((String)"teiid-deployment", (ScheduledExecutorService)Executors.newScheduledThreadPool(2));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create temp file provider");
        }
    }
}

