/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odbc;

import java.io.IOException;
import java.io.StringReader;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.client.RequestMessage;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.StringUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.odbc.PGUtil;
import org.teiid.odbc.ScriptReader;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgFrontendProtocol;

public class ODBCServerRemoteImpl
implements ODBCServerRemote {
    private static final String UNNAMED = "UNNAMED";
    private static Pattern setPattern = Pattern.compile("(SET|set)\\s+(\\w+)\\s+(TO|to)\\s+'(\\w+\\d*)'");
    private static Pattern pkPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = (E?(?:'[^']*')+) AND n.nspname = (E?(?:'[^']*')+).*", 34);
    private static Pattern pkKeyPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, NULL from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class ic, pg_catalog.pg_index i, pg_catalog.pg_namespace n where ic.relname = (E?(?:'[^']*')+) AND n.nspname = (E?(?:'[^']*')+) .*", 34);
    private Pattern fkPattern = Pattern.compile("select\\s+((?:'[^']*')+)::name as PKTABLE_CAT,\\s+n2.nspname as PKTABLE_SCHEM,\\s+c2.relname as PKTABLE_NAME,\\s+a2.attname as PKCOLUMN_NAME,\\s+((?:'[^']*')+)::name as FKTABLE_CAT,\\s+n1.nspname as FKTABLE_SCHEM,\\s+c1.relname as FKTABLE_NAME,\\s+a1.attname as FKCOLUMN_NAME,\\s+i::int2 as KEY_SEQ,\\s+case ref.confupdtype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as UPDATE_RULE,\\s+case ref.confdeltype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as DELETE_RULE,\\s+ref.conname as FK_NAME,\\s+cn.conname as PK_NAME,\\s+case\\s+when ref.condeferrable then\\s+case\\s+when ref.condeferred then (\\d)::int2\\s+else (\\d)::int2\\s+end\\s+else (\\d)::int2\\s+end as DEFERRABLITY\\s+from\\s+\\(\\(\\(\\(\\(\\(\\( \\(select cn.oid, conrelid, conkey, confrelid, confkey,\\s+generate_series\\(array_lower\\(conkey, 1\\), array_upper\\(conkey, 1\\)\\) as i,\\s+confupdtype, confdeltype, conname,\\s+condeferrable, condeferred\\s+from pg_catalog.pg_constraint cn,\\s+pg_catalog.pg_class c,\\s+pg_catalog.pg_namespace n\\s+where contype = 'f' \\s+and  conrelid = c.oid\\s+and  relname = (E?(?:'[^']*')+)\\s+and  n.oid = c.relnamespace\\s+and  n.nspname = (E?(?:'[^']*')+)\\s+\\) ref\\s+inner join pg_catalog.pg_class c1\\s+on c1.oid = ref.conrelid\\)\\s+inner join pg_catalog.pg_namespace n1\\s+on  n1.oid = c1.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a1\\s+on  a1.attrelid = c1.oid\\s+and  a1.attnum = conkey\\[i\\]\\)\\s+inner join pg_catalog.pg_class c2\\s+on  c2.oid = ref.confrelid\\)\\s+inner join pg_catalog.pg_namespace n2\\s+on  n2.oid = c2.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a2\\s+on  a2.attrelid = c2.oid\\s+and  a2.attnum = confkey\\[i\\]\\)\\s+left outer join pg_catalog.pg_constraint cn\\s+on cn.conrelid = ref.confrelid\\s+and cn.contype = 'p'\\)\\s+order by ref.oid, ref.i", 34);
    private static Pattern preparedAutoIncrement = Pattern.compile("select 1 \\s*from pg_catalog.pg_attrdef \\s*where adrelid = \\$1 AND adnum = \\$2 \\s*and pg_catalog.pg_get_expr\\(adbin, adrelid\\) \\s*like '%nextval\\(%'", 34);
    private static Pattern cursorSelectPattern = Pattern.compile("DECLARE \"(\\w+)\" CURSOR(\\s(WITH HOLD|SCROLL))? FOR (.*)", 34);
    private static Pattern fetchPattern = Pattern.compile("FETCH (\\d+) IN \"(\\w+)\".*", 34);
    private static Pattern movePattern = Pattern.compile("MOVE (\\d+) IN \"(\\w+)\".*", 34);
    private static Pattern closePattern = Pattern.compile("CLOSE \"(\\w+)\"", 34);
    private static Pattern deallocatePattern = Pattern.compile("DEALLOCATE(?:\\s+PREPARE)?\\s+(.*)", 34);
    private static Pattern releasePattern = Pattern.compile("RELEASE (\\w+\\d?_*)", 34);
    private static Pattern savepointPattern = Pattern.compile("SAVEPOINT (\\w+\\d?_*)", 34);
    private static Pattern rollbackPattern = Pattern.compile("ROLLBACK\\s*(to)*\\s*(\\w+\\d+_*)*", 34);
    private TeiidDriver driver;
    private ODBCClientRemote client;
    private Properties props;
    private AuthenticationType authType;
    private ConnectionImpl connection;
    private boolean executing;
    private boolean errorOccurred;
    private volatile ResultsFuture<Boolean> executionFuture;
    private Map<String, Prepared> preparedMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Portal> portalMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Cursor> cursorMap = Collections.synchronizedMap(new HashMap());
    private ILogon logon;

    public ODBCServerRemoteImpl(ODBCClientInstance client, AuthenticationType authType, TeiidDriver driver, ILogon logon) {
        this.driver = driver;
        this.client = client.getClient();
        this.authType = authType;
        this.logon = logon;
    }

    @Override
    public void initialize(Properties props) {
        this.props = props;
        this.client.initialized(this.props);
        if (this.authType.equals((Object)AuthenticationType.CLEARTEXT)) {
            this.client.useClearTextAuthentication();
        } else if (this.authType.equals((Object)AuthenticationType.GSS)) {
            this.client.useAuthenticationGSS();
        }
    }

    @Override
    public void logon(String databaseName, String user, PgFrontendProtocol.NullTerminatedStringDataInputStream data) {
        try {
            Properties info = new Properties();
            info.put("user", user);
            String password = null;
            if (this.authType.equals((Object)AuthenticationType.CLEARTEXT)) {
                password = data.readString();
            } else if (this.authType.equals((Object)AuthenticationType.GSS)) {
                byte[] serviceToken = data.readServiceToken();
                LogonResult result = this.logon.neogitiateGssLogin(this.props, serviceToken, false);
                serviceToken = (byte[])result.getProperty("KRB5TOKEN");
                if (Boolean.TRUE.equals(result.getProperty("KRB5_CONTEXT_ESTABLISHED"))) {
                    info.put("KRB5TOKEN", serviceToken);
                } else {
                    this.client.authenticationGSSContinue(serviceToken);
                    return;
                }
            }
            String url = "jdbc:teiid:" + databaseName + ";ApplicationName=ODBC";
            if (password != null) {
                info.put("password", password);
            }
            this.connection = (ConnectionImpl)this.driver.connect(url, info);
            int hash = this.connection.getConnectionId().hashCode();
            Enumeration<?> keys = this.props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                StatementImpl stmt = this.connection.createStatement();
                stmt.execute("SET " + key + " '" + this.props.getProperty(key) + "'");
                stmt.close();
            }
            this.client.authenticationSucess(hash, hash);
            this.ready();
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            this.terminate();
        }
        catch (LogonException e) {
            this.errorOccurred(e);
            this.terminate();
        }
        catch (IOException e) {
            this.errorOccurred(e);
            this.terminate();
        }
    }

    private void cursorExecute(final String cursorName, final String sql, final ResultsFuture<Integer> completion) {
        if (sql != null) {
            try {
                Prepared previous = this.preparedMap.remove(cursorName);
                if (previous != null) {
                    previous.stmt.close();
                }
                final PreparedStatementImpl stmt = this.connection.prepareStatement(sql);
                this.executionFuture = stmt.submitExecute(RequestMessage.ResultsMode.RESULTSET, null);
                this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                    public void onCompletion(ResultsFuture<Boolean> future) {
                        ODBCServerRemoteImpl.this.executionFuture = null;
                        try {
                            List cols = ODBCServerRemoteImpl.this.getPgColInfo(stmt.getResultSet().getMetaData());
                            ODBCServerRemoteImpl.this.cursorMap.put(cursorName, new Cursor(cursorName, sql, stmt, null, stmt.getResultSet(), cols));
                            ODBCServerRemoteImpl.this.client.sendCommandComplete("DECLARE CURSOR", null);
                            completion.getResultsReceiver().receiveResults((Object)0);
                        }
                        catch (Throwable e) {
                            completion.getResultsReceiver().exceptionOccurred(e);
                        }
                    }
                });
            }
            catch (SQLException e) {
                completion.getResultsReceiver().exceptionOccurred((Throwable)e);
            }
        }
    }

    private void cursorFetch(String cursorName, int rows, final ResultsFuture<Integer> completion) throws SQLException {
        Cursor cursor = this.cursorMap.get(cursorName);
        if (cursor == null) {
            throw new SQLException(RuntimePlugin.Util.getString("not_bound", new Object[]{cursorName}));
        }
        cursor.fetchSize = rows;
        ResultsFuture result = new ResultsFuture();
        this.client.sendCursorResults(cursor.rs, cursor.columnMetadata, (ResultsFuture<Integer>)result, rows);
        result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

            public void onCompletion(ResultsFuture<Integer> future) {
                try {
                    int rowsSent = (Integer)future.get();
                    ODBCServerRemoteImpl.this.client.sendCommandComplete("FETCH", rowsSent);
                    completion.getResultsReceiver().receiveResults((Object)rowsSent);
                }
                catch (Throwable e) {
                    completion.getResultsReceiver().exceptionOccurred(e);
                }
            }
        });
    }

    private void cursorMove(String prepareName, int rows, final ResultsFuture<Integer> completion) throws SQLException {
        if (rows == 0) {
            this.client.sendCommandComplete("MOVE", 0);
            completion.getResultsReceiver().receiveResults((Object)0);
            return;
        }
        Cursor cursor = this.cursorMap.get(prepareName);
        if (cursor == null) {
            throw new SQLException(RuntimePlugin.Util.getString("not_bound", new Object[]{prepareName}));
        }
        ResultsFuture result = new ResultsFuture();
        this.client.sendMoveCursor(cursor.rs, rows, (ResultsFuture<Integer>)result);
        result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

            public void onCompletion(ResultsFuture<Integer> future) {
                try {
                    int rowsMoved = (Integer)future.get();
                    ODBCServerRemoteImpl.this.client.sendCommandComplete("MOVE", rowsMoved);
                    completion.getResultsReceiver().receiveResults((Object)rowsMoved);
                }
                catch (Throwable e) {
                    completion.getResultsReceiver().exceptionOccurred(e);
                }
            }
        });
    }

    private void cursorClose(String prepareName) throws SQLException {
        Cursor cursor = this.cursorMap.remove(prepareName);
        if (cursor != null) {
            cursor.rs.close();
            cursor.stmt.close();
            this.client.sendCommandComplete("CLOSE CURSOR", null);
        }
    }

    private void sqlExecute(final String sql, final ResultsFuture<Integer> completion) throws SQLException {
        String modfiedSQL = this.fixSQL(sql);
        final StatementImpl stmt = this.connection.createStatement();
        this.executionFuture = stmt.submitExecute(modfiedSQL, null);
        this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

            public void onCompletion(ResultsFuture<Boolean> future) {
                ODBCServerRemoteImpl.this.executionFuture = null;
                try {
                    ResultsFuture result = new ResultsFuture();
                    if (((Boolean)future.get()).booleanValue()) {
                        List cols = ODBCServerRemoteImpl.this.getPgColInfo(stmt.getResultSet().getMetaData());
                        ODBCServerRemoteImpl.this.client.sendResults(sql, stmt.getResultSet(), cols, (ResultsFuture<Integer>)result, true);
                    } else {
                        ODBCServerRemoteImpl.this.client.sendUpdateCount(sql, stmt.getUpdateCount());
                        ODBCServerRemoteImpl.this.setEncoding();
                        result.getResultsReceiver().receiveResults((Object)1);
                    }
                    result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

                        public void onCompletion(ResultsFuture<Integer> future) {
                            try {
                                try {
                                    stmt.close();
                                }
                                catch (SQLException e) {
                                    LogManager.logDetail((String)"org.teiid.ODBC", (Throwable)e, (Object[])new Object[]{"Error closing statement"});
                                }
                                future.get();
                                completion.getResultsReceiver().receiveResults((Object)1);
                            }
                            catch (Throwable e) {
                                completion.getResultsReceiver().exceptionOccurred(e);
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    completion.getResultsReceiver().exceptionOccurred(e);
                }
            }
        });
    }

    @Override
    public void prepare(String prepareName, String sql, int[] paramType) {
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if (sql != null) {
            String modfiedSQL = this.fixSQL(sql);
            try {
                Prepared previous = this.preparedMap.remove(prepareName);
                if (previous != null) {
                    previous.stmt.close();
                }
                PreparedStatementImpl stmt = this.connection.prepareStatement(modfiedSQL);
                this.preparedMap.put(prepareName, new Prepared(prepareName, sql, stmt, paramType));
                this.client.prepareCompleted(prepareName);
            }
            catch (SQLException e) {
                this.errorOccurred(e);
            }
        }
    }

    @Override
    public void bindParameters(String bindName, String prepareName, int paramCount, Object[] params, int resultCodeCount, int[] resultColumnFormat) {
        Prepared previous;
        this.portalMap.remove(UNNAMED);
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((previous = this.preparedMap.get(prepareName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("bad_binding", new Object[]{prepareName}));
            return;
        }
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        try {
            for (int i = 0; i < paramCount; ++i) {
                previous.stmt.setObject(i + 1, params[i]);
            }
        }
        catch (SQLException e) {
            this.errorOccurred(e);
        }
        this.portalMap.put(bindName, new Portal(bindName, prepareName, previous.sql, previous.stmt, resultColumnFormat));
        this.client.bindComplete();
    }

    @Override
    public void unsupportedOperation(String msg) {
        this.errorOccurred(msg);
    }

    @Override
    public void execute(String bindName, int maxRows) {
        Cursor cursor;
        if (this.beginExecution()) {
            this.errorOccurred("Awaiting asynch result");
            return;
        }
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((cursor = this.cursorMap.get(bindName)) != null) {
            this.sendCursorResults(cursor);
            return;
        }
        Portal query = this.portalMap.get(bindName);
        if (query == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
            return;
        }
        if (query.sql.trim().isEmpty()) {
            this.client.emptyQueryReceived();
            return;
        }
        this.sendPortalResults(maxRows, query);
    }

    private void sendPortalResults(int maxRows, final Portal query) {
        final PreparedStatementImpl stmt = query.stmt;
        try {
            if (maxRows != 0) {
                stmt.setMaxRows(maxRows);
            }
            this.executionFuture = stmt.submitExecute(RequestMessage.ResultsMode.EITHER, null);
            this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                public void onCompletion(ResultsFuture<Boolean> future) {
                    ODBCServerRemoteImpl.this.executionFuture = null;
                    try {
                        ResultsFuture result = new ResultsFuture();
                        if (((Boolean)future.get()).booleanValue()) {
                            List cols = ODBCServerRemoteImpl.this.getPgColInfo(stmt.getResultSet().getMetaData());
                            ODBCServerRemoteImpl.this.client.sendResults(query.sql, stmt.getResultSet(), cols, (ResultsFuture<Integer>)result, true);
                        } else {
                            ODBCServerRemoteImpl.this.client.sendUpdateCount(query.sql, stmt.getUpdateCount());
                            ODBCServerRemoteImpl.this.setEncoding();
                            result.getResultsReceiver().receiveResults((Object)1);
                        }
                        result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

                            public void onCompletion(ResultsFuture<Integer> future) {
                                try {
                                    future.get();
                                    ODBCServerRemoteImpl.this.doneExecuting();
                                }
                                catch (InterruptedException e) {
                                    throw new AssertionError((Object)e);
                                }
                                catch (ExecutionException e) {
                                    ODBCServerRemoteImpl.this.errorOccurred(e.getCause());
                                }
                            }
                        });
                    }
                    catch (Throwable e) {
                        ODBCServerRemoteImpl.this.errorOccurred(e);
                    }
                }
            });
        }
        catch (SQLException e) {
            this.errorOccurred(e);
        }
    }

    private void sendCursorResults(final Cursor cursor) {
        ResultsFuture result = new ResultsFuture();
        this.client.sendPortalResults(cursor.sql, cursor.rs, cursor.columnMetadata, (ResultsFuture<Integer>)result, cursor.fetchSize, true);
        result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

            public void onCompletion(ResultsFuture<Integer> future) {
                try {
                    int rowsSent = (Integer)future.get();
                    if (rowsSent < cursor.fetchSize) {
                        ODBCServerRemoteImpl.this.client.sendCommandComplete(cursor.sql, 0);
                    } else {
                        ODBCServerRemoteImpl.this.client.sendPortalSuspended();
                    }
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                catch (ExecutionException e) {
                    ODBCServerRemoteImpl.this.errorOccurred(e.getCause());
                }
            }
        });
    }

    private String fixSQL(String sql) {
        String modified = this.modifySQL(sql);
        if (modified != null && !modified.equals(sql)) {
            LogManager.logDetail((String)"org.teiid.ODBC", (Object[])new Object[]{"Modified Query:", modified});
        }
        return modified;
    }

    private String modifySQL(String sql) {
        String modified = sql;
        if (sql == null) {
            return null;
        }
        Matcher m = null;
        if (StringUtil.startsWithIgnoreCase((String)sql, (String)"select")) {
            m = pkPattern.matcher(modified);
            if (m.matches()) {
                return new StringBuffer("SELECT k.Name AS attname, convert(Position, short) AS attnum, TableName AS relname, SchemaName AS nspname, TableName AS relname").append(" FROM SYS.KeyColumns k").append(" WHERE ").append(" UCASE(SchemaName)").append(" LIKE UCASE(").append(m.group(2)).append(")").append(" AND UCASE(TableName)").append(" LIKE UCASE(").append(m.group(1)).append(")").append(" AND KeyType LIKE 'Primary'").append(" ORDER BY attnum").toString();
            }
            m = pkKeyPattern.matcher(modified);
            if (m.matches()) {
                String tableName = m.group(1);
                if (tableName.endsWith("_pkey'")) {
                    tableName = tableName.substring(0, tableName.length() - 6) + '\'';
                    return "select ia.attname, ia.attnum, ic.relname, n.nspname, NULL from pg_catalog.pg_attribute ia, pg_catalog.pg_class ic, pg_catalog.pg_namespace n, Sys.KeyColumns kc where ic.relname = " + tableName + " AND n.nspname = " + m.group(2) + " AND " + "n.oid = ic.relnamespace AND ia.attrelid = ic.oid AND kc.SchemaName = n.nspname " + "AND kc.TableName = ic.relname AND kc.KeyType = 'Primary' AND kc.Name = ia.attname order by ia.attnum";
                }
                return "SELECT NULL, NULL, NULL, NULL, NULL FROM (SELECT 1) as X WHERE 0=1";
            }
            m = this.fkPattern.matcher(modified);
            if (m.matches()) {
                return "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns WHERE PKTABLE_NAME LIKE " + m.group(14) + " and PKTABLE_SCHEM LIKE " + m.group(15);
            }
            if (modified.equalsIgnoreCase("select version()")) {
                return "SELECT 'Teiid " + ApplicationInfo.getInstance().getReleaseNumber() + "'";
            }
            if (modified.startsWith("SELECT name FROM master..sysdatabases")) {
                return "SELECT 'Teiid'";
            }
            if (modified.equalsIgnoreCase("select db_name() dbname")) {
                return "SELECT current_database()";
            }
            if (preparedAutoIncrement.matcher(modified).matches()) {
                return "SELECT 1 from matpg_relatt where attrelid = ? and attnum = ? and autoinc = true";
            }
            if (sql.equalsIgnoreCase("select current_schema()")) {
                return "SELECT ''";
            }
        } else {
            if (sql.equalsIgnoreCase("show max_identifier_length")) {
                return "select 63";
            }
            m = setPattern.matcher(sql);
            if (m.matches()) {
                return "SET " + m.group(2) + " " + m.group(4);
            }
            if (modified.equalsIgnoreCase("BEGIN")) {
                return "START TRANSACTION";
            }
            m = rollbackPattern.matcher(modified);
            if (m.matches()) {
                return "ROLLBACK";
            }
            m = savepointPattern.matcher(sql);
            if (m.matches()) {
                return "SELECT 0";
            }
            m = releasePattern.matcher(sql);
            if (m.matches()) {
                return "SELECT 0";
            }
        }
        modified = modified.replaceAll("::[A-Za-z0-9]*", " ");
        modified = modified.replaceAll("'pg_toast'", "'SYS'");
        return modified;
    }

    @Override
    public void executeQuery(String query) {
        if (this.beginExecution()) {
            this.errorOccurred("Awaiting asynch result");
            this.ready();
            return;
        }
        this.portalMap.remove(UNNAMED);
        this.preparedMap.remove(UNNAMED);
        query = query.trim();
        if (query.length() == 0) {
            this.client.emptyQueryReceived();
            this.ready();
        }
        QueryWorkItem r = new QueryWorkItem(query);
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginExecution() {
        if (this.executionFuture != null) {
            return true;
        }
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.executing = true;
        }
        return false;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    @Override
    public void getParameterDescription(String prepareName) {
        Prepared query;
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((query = this.preparedMap.get(prepareName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("no_stmt_found", new Object[]{prepareName}));
        } else {
            try {
                this.client.sendParameterDescription((ParameterMetaData)query.stmt.getParameterMetaData(), query.paramType);
                List<PGUtil.PgColInfo> cols = this.getPgColInfo(query.stmt.getMetaData());
                this.client.sendResultSetDescription(cols);
            }
            catch (SQLException e) {
                this.errorOccurred(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorOccurred(String error) {
        this.client.errorOccurred(error);
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = true;
            this.doneExecuting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorOccurred(Throwable error) {
        this.client.errorOccurred(error);
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = true;
            this.doneExecuting();
        }
    }

    @Override
    public void getResultSetMetaDataDescription(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.get(bindName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
        } else {
            try {
                List<PGUtil.PgColInfo> cols = this.getPgColInfo(query.stmt.getMetaData());
                this.client.sendResultSetDescription(cols);
            }
            catch (SQLException e) {
                this.errorOccurred(e);
            }
        }
    }

    @Override
    public void sync() {
        this.ready();
    }

    protected synchronized void doneExecuting() {
        this.executing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ready() {
        boolean inTxn = false;
        boolean failedTxn = false;
        try {
            if (!this.connection.getAutoCommit()) {
                inTxn = true;
            }
        }
        catch (SQLException e) {
            failedTxn = true;
        }
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = false;
        }
        this.client.ready(inTxn, failedTxn);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void closeBoundStatement(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.remove(bindName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("not_bound", new Object[]{bindName}));
        } else {
            try {
                if (this.connection.getAutoCommit()) {
                    this.closePreparedStatement(bindName);
                }
            }
            catch (SQLException e) {
                this.closePreparedStatement(bindName);
            }
        }
    }

    @Override
    public void closePreparedStatement(String preparedName) {
        Prepared query;
        if (preparedName == null || preparedName.length() == 0) {
            preparedName = UNNAMED;
        }
        if ((query = this.preparedMap.remove(preparedName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.getString("no_stmt_found", new Object[]{preparedName}));
        } else {
            this.portalMap.remove(preparedName);
            try {
                query.stmt.close();
                this.client.statementClosed();
            }
            catch (SQLException e) {
                this.errorOccurred(RuntimePlugin.Util.getString("error_closing_stmt", new Object[]{preparedName}));
            }
        }
    }

    @Override
    public void terminate() {
        for (Portal portal : this.portalMap.values()) {
            try {
                portal.stmt.close();
            }
            catch (SQLException e) {}
        }
        for (Prepared prepared : this.preparedMap.values()) {
            try {
                prepared.stmt.close();
            }
            catch (SQLException sQLException) {}
        }
        try {
            if (this.connection != null) {
                if (!this.connection.getAutoCommit()) {
                    this.connection.rollback(false);
                }
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.client.terminated();
    }

    @Override
    public void flush() {
        this.client.flush();
    }

    @Override
    public void functionCall(int oid) {
        this.errorOccurred(RuntimePlugin.Util.getString("lo_not_supported"));
    }

    @Override
    public void sslRequest() {
        this.client.sendSslResponse();
    }

    private void setEncoding() {
        try {
            String encoding;
            StatementImpl t = this.connection.createStatement();
            ResultSet rs = t.executeQuery("show client_encoding");
            if (rs.next() && (encoding = rs.getString(1)) != null) {
                this.client.setEncoding(encoding);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<PGUtil.PgColInfo> getPgColInfo(ResultSetMetaData meta) throws SQLException {
        if (meta == null) {
            return null;
        }
        int columns = meta.getColumnCount();
        ArrayList<PGUtil.PgColInfo> result = new ArrayList<PGUtil.PgColInfo>(columns);
        for (int i = 1; i < columns + 1; ++i) {
            PGUtil.PgColInfo info = new PGUtil.PgColInfo();
            info.name = meta.getColumnLabel(i).toLowerCase();
            info.type = meta.getColumnType(i);
            info.type = PGUtil.convertType(info.type);
            info.precision = meta.getColumnDisplaySize(i);
            String name = meta.getColumnName(i);
            String table = meta.getTableName(i);
            String schema = meta.getSchemaName(i);
            if (schema != null) {
                PreparedStatementImpl ps = this.connection.prepareStatement("select attrelid, attnum, typoid from matpg_relatt where attname = ? and relname = ? and nspname = ?");
                ps.setString(1, name);
                ps.setString(2, table);
                ps.setString(3, schema);
                ResultSet rs = ps.executeQuery();
                if (rs.next()) {
                    info.reloid = rs.getInt(1);
                    info.attnum = rs.getShort(2);
                    int specificType = rs.getInt(3);
                    if (!rs.wasNull()) {
                        info.type = specificType;
                    }
                }
            }
            result.add(info);
        }
        return result;
    }

    static class Cursor
    extends Prepared {
        ResultSetImpl rs;
        int fetchSize = 1000;
        List<PGUtil.PgColInfo> columnMetadata;

        public Cursor(String name, String sql, PreparedStatementImpl stmt, int[] paramType, ResultSetImpl rs, List<PGUtil.PgColInfo> colMetadata) {
            super(name, sql, stmt, paramType);
            this.rs = rs;
            this.columnMetadata = colMetadata;
        }
    }

    static class Portal {
        String name;
        String preparedName;
        String sql;
        int[] resultColumnFormat;
        PreparedStatementImpl stmt;

        public Portal(String name, String preparedName, String sql, PreparedStatementImpl stmt, int[] resultColumnformat) {
            this.name = name;
            this.preparedName = preparedName;
            this.sql = sql;
            this.stmt = stmt;
            this.resultColumnFormat = resultColumnformat;
        }
    }

    static class Prepared {
        String name;
        String sql;
        PreparedStatementImpl stmt;
        int[] paramType;

        public Prepared(String name, String sql, PreparedStatementImpl stmt, int[] paramType) {
            this.name = name;
            this.sql = sql;
            this.stmt = stmt;
            this.paramType = paramType;
        }
    }

    private final class QueryWorkItem
    implements Runnable {
        private final ScriptReader reader;
        String sql;

        private QueryWorkItem(String query) {
            this.reader = new ScriptReader(new StringReader(query));
        }

        private void done(Throwable error) {
            if (error != null) {
                ODBCServerRemoteImpl.this.errorOccurred(error);
            } else {
                ODBCServerRemoteImpl.this.doneExecuting();
            }
            ODBCServerRemoteImpl.this.ready();
        }

        @Override
        public void run() {
            block17: {
                try {
                    if (this.sql == null) {
                        this.sql = this.reader.readStatement();
                    }
                    if (this.sql == null) break block17;
                    try {
                        ResultsFuture results = new ResultsFuture();
                        results.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

                            public void onCompletion(ResultsFuture<Integer> future) {
                                try {
                                    future.get();
                                    QueryWorkItem.this.sql = QueryWorkItem.this.reader.readStatement();
                                }
                                catch (InterruptedException e) {
                                    throw new AssertionError((Object)e);
                                }
                                catch (IOException e) {
                                    QueryWorkItem.this.done(e);
                                    return;
                                }
                                catch (ExecutionException e) {
                                    Throwable cause;
                                    for (cause = e; cause instanceof ExecutionException && cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                                    }
                                    QueryWorkItem.this.done(cause);
                                    return;
                                }
                                QueryWorkItem.this.run();
                            }
                        });
                        if (ODBCServerRemoteImpl.this.isErrorOccurred()) {
                            if (!ODBCServerRemoteImpl.this.connection.getAutoCommit()) {
                                ODBCServerRemoteImpl.this.connection.rollback(false);
                            }
                            break block17;
                        }
                        Matcher m = null;
                        m = cursorSelectPattern.matcher(this.sql);
                        if (m.matches()) {
                            ODBCServerRemoteImpl.this.cursorExecute(m.group(1), ODBCServerRemoteImpl.this.fixSQL(m.group(4)), (ResultsFuture<Integer>)results);
                        } else {
                            m = fetchPattern.matcher(this.sql);
                            if (m.matches()) {
                                ODBCServerRemoteImpl.this.cursorFetch(m.group(2), Integer.parseInt(m.group(1)), (ResultsFuture<Integer>)results);
                            } else {
                                m = movePattern.matcher(this.sql);
                                if (m.matches()) {
                                    ODBCServerRemoteImpl.this.cursorMove(m.group(2), Integer.parseInt(m.group(1)), (ResultsFuture<Integer>)results);
                                } else {
                                    m = closePattern.matcher(this.sql);
                                    if (m.matches()) {
                                        ODBCServerRemoteImpl.this.cursorClose(m.group(1));
                                        results.getResultsReceiver().receiveResults((Object)1);
                                    } else {
                                        m = deallocatePattern.matcher(this.sql);
                                        if (m.matches()) {
                                            String plan_name = m.group(1);
                                            plan_name = SQLParserUtil.normalizeId((String)plan_name);
                                            ODBCServerRemoteImpl.this.closePreparedStatement(plan_name);
                                            ODBCServerRemoteImpl.this.client.sendCommandComplete("DEALLOCATE", null);
                                            results.getResultsReceiver().receiveResults((Object)1);
                                        } else {
                                            ODBCServerRemoteImpl.this.sqlExecute(this.sql, (ResultsFuture<Integer>)results);
                                        }
                                    }
                                }
                            }
                        }
                        return;
                    }
                    catch (SQLException e) {
                        this.done(e);
                        return;
                    }
                }
                catch (IOException e) {
                    this.done(e);
                    return;
                }
            }
            this.done(null);
        }
    }
}

