/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.common.buffer.impl.BufferFrontedFileStoreCache;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.FileStorageManager;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.common.buffer.impl.SplittableStorageManager;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.FileUtils;
import org.teiid.dqp.service.BufferService;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;

public class BufferServiceImpl
implements BufferService,
Serializable {
    private static final long serialVersionUID = -6217808623863643531L;
    private static final long MB = 0x100000L;
    private BufferManagerImpl bufferMgr;
    private File bufferDir;
    private boolean useDisk = true;
    private int processorBatchSize = 256;
    private int connectorBatchSize = 512;
    private int maxOpenFiles = 64;
    private long maxFileSize = 2048L;
    private int maxProcessingKb = -1;
    private int maxReserveKb = -1;
    private long maxBufferSpace = 51200L;
    private boolean inlineLobs = true;
    private long memoryBufferSpace = -1L;
    private int maxStorageObjectSize = 0x800000;
    private boolean memoryBufferOffHeap;
    private FileStorageManager fsm;

    void cleanDirectory(File file) {
        FileUtils.removeChildrenRecursively((File)file);
    }

    public void start() {
        try {
            LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Starting BufferManager using", this.bufferDir});
            if (!this.bufferDir.exists()) {
                this.bufferDir.mkdirs();
            }
            this.bufferMgr = new BufferManagerImpl();
            this.bufferMgr.setConnectorBatchSize(Integer.valueOf(this.connectorBatchSize).intValue());
            this.bufferMgr.setProcessorBatchSize(Integer.valueOf(this.processorBatchSize).intValue());
            this.bufferMgr.setMaxReserveKB(this.maxReserveKb);
            this.bufferMgr.setMaxProcessingKB(this.maxProcessingKb);
            this.bufferMgr.initialize();
            if (this.useDisk) {
                this.cleanDirectory(this.bufferDir);
                this.fsm = new FileStorageManager();
                this.fsm.setStorageDirectory(this.bufferDir.getCanonicalPath());
                this.fsm.setMaxOpenFiles(this.maxOpenFiles);
                this.fsm.setMaxBufferSpace(this.maxBufferSpace * 0x100000L);
                SplittableStorageManager ssm = new SplittableStorageManager((StorageManager)this.fsm);
                ssm.setMaxFileSize(this.maxFileSize);
                BufferFrontedFileStoreCache fsc = new BufferFrontedFileStoreCache();
                fsc.setMaxStorageObjectSize(this.maxStorageObjectSize);
                fsc.setDirect(this.memoryBufferOffHeap);
                int batchOverheadKB = (int)(this.memoryBufferSpace < 0L ? (long)(this.bufferMgr.getMaxReserveKB() << 8) : this.memoryBufferSpace) >> 20;
                this.bufferMgr.setMaxReserveKB(Math.max(0, this.bufferMgr.getMaxReserveKB() - batchOverheadKB));
                if (this.memoryBufferSpace < 0L) {
                    fsc.setMemoryBufferSpace((long)this.bufferMgr.getMaxReserveKB() << 8);
                } else {
                    fsc.setMemoryBufferSpace(this.memoryBufferSpace << 20);
                }
                if (!this.memoryBufferOffHeap && this.maxReserveKb < 0) {
                    this.bufferMgr.setMaxReserveKB(this.bufferMgr.getMaxReserveKB() - (int)Math.min((long)this.bufferMgr.getMaxReserveKB(), fsc.getMemoryBufferSpace() >> 10));
                }
                fsc.setStorageManager((StorageManager)ssm);
                fsc.initialize();
                this.bufferMgr.setCache((Cache)fsc);
            } else {
                this.bufferMgr.setCache((Cache)new MemoryStorageManager());
            }
        }
        catch (TeiidComponentException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((Throwable)e, RuntimePlugin.Util.getString("LocalBufferService.Failed_initializing_buffer_manager._8"));
        }
    }

    public void stop() {
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{"Stopping BufferManager using", this.bufferDir});
        this.bufferMgr.shutdown();
        if (this.bufferDir != null) {
            this.cleanDirectory(this.bufferDir);
            this.bufferDir.delete();
        }
    }

    public BufferManagerImpl getBufferManager() {
        return this.bufferMgr;
    }

    public TupleBufferCache getTupleBufferCache() {
        return this.bufferMgr;
    }

    public void setUseDisk(boolean flag) {
        this.useDisk = flag;
    }

    public void setDiskDirectory(String dir) {
        this.bufferDir = new File(dir, "buffer");
    }

    public void setProcessorBatchSize(int size) {
        this.processorBatchSize = size;
    }

    public void setConnectorBatchSize(int size) {
        this.connectorBatchSize = size;
    }

    public void setInlineLobs(boolean inlineLobs) {
        this.inlineLobs = inlineLobs;
    }

    public File getBufferDirectory() {
        return this.bufferDir;
    }

    public boolean isUseDisk() {
        return this.useDisk;
    }

    public boolean isInlineLobs() {
        return this.inlineLobs;
    }

    public int getProcessorBatchSize() {
        return this.processorBatchSize;
    }

    public int getConnectorBatchSize() {
        return this.connectorBatchSize;
    }

    public void setMaxFileSize(long maxFileSize) {
        this.maxFileSize = maxFileSize;
    }

    public long getMaxFileSize() {
        return this.maxFileSize;
    }

    public void setMaxOpenFiles(int maxOpenFiles) {
        this.maxOpenFiles = maxOpenFiles;
    }

    public int getMaxProcessingKb() {
        return this.maxProcessingKb;
    }

    public int getMaxReservedKb() {
        return this.maxReserveKb;
    }

    public void setMaxProcessingKb(int maxProcessingKb) {
        this.maxProcessingKb = maxProcessingKb;
    }

    public void setMaxReserveKb(int maxReserveKb) {
        this.maxReserveKb = maxReserveKb;
    }

    public long getMaxBufferSpace() {
        return this.maxBufferSpace;
    }

    public void setMaxBufferSpace(long maxBufferSpace) {
        this.maxBufferSpace = maxBufferSpace;
    }

    public long getUserBufferSpace() {
        if (this.fsm != null) {
            return this.fsm.getUsedBufferSpace() / 0x100000L;
        }
        return 0L;
    }

    public long getBatchesAdded() {
        return this.bufferMgr.getBatchesAdded();
    }

    public long getReadCount() {
        return this.bufferMgr.getReadCount();
    }

    public long getWriteCount() {
        return this.bufferMgr.getWriteCount();
    }

    public long getReadAttempts() {
        return this.bufferMgr.getReadAttempts();
    }

    public int getMemoryBufferSpace() {
        return (int)this.memoryBufferSpace;
    }

    public int getMaxStorageObjectSize() {
        return this.maxStorageObjectSize;
    }

    public boolean isMemoryBufferOffHeap() {
        return this.memoryBufferOffHeap;
    }

    public void setMemoryBufferOffHeap(boolean memoryBufferOffHeap) {
        this.memoryBufferOffHeap = memoryBufferOffHeap;
    }

    public void setMemoryBufferSpace(int memoryBufferSpace) {
        this.memoryBufferSpace = memoryBufferSpace;
    }

    public void setMaxStorageObjectSize(int maxStorageObjectSize) {
        this.maxStorageObjectSize = maxStorageObjectSize;
    }
}

