/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.SessionToken;
import org.teiid.core.util.ArgCheck;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.Credentials;
import org.teiid.security.SecurityHelper;
import org.teiid.services.TeiidLoginContext;

public abstract class SessionServiceImpl
implements SessionService {
    public static final String AT = "@";
    private long sessionMaxLimit = 5000L;
    private long sessionExpirationTimeLimit = 0L;
    private AuthenticationType authenticationType = AuthenticationType.CLEARTEXT;
    private String gssSecurityDomain;
    private VDBRepository vdbRepository;
    protected SecurityHelper securityHelper;
    private DQPCore dqp;
    private Map<String, SessionMetadata> sessionCache = new ConcurrentHashMap<String, SessionMetadata>();
    private Timer sessionMonitor = new Timer("SessionMonitor", true);
    private List<String> securityDomainNames;

    public void setSecurityDomains(List<String> domainNames) {
        this.securityDomainNames = domainNames;
    }

    private void monitorSessions() {
        long currentTime = System.currentTimeMillis();
        for (SessionMetadata info : this.sessionCache.values()) {
            try {
                if (!info.isEmbedded() && currentTime - info.getLastPingTime() > 600000L) {
                    LogManager.logInfo((String)"org.teiid.SECURITY", (String)RuntimePlugin.Util.getString("SessionServiceImpl.keepaliveFailed", new Object[]{info.getSessionId()}));
                    this.closeSession(info.getSessionId());
                    continue;
                }
                if (this.sessionExpirationTimeLimit <= 0L || currentTime - info.getCreatedTime() <= this.sessionExpirationTimeLimit) continue;
                LogManager.logInfo((String)"org.teiid.SECURITY", (String)RuntimePlugin.Util.getString("SessionServiceImpl.expireSession", new Object[]{info.getSessionId()}));
                this.closeSession(info.getSessionId());
            }
            catch (Exception e) {
                LogManager.logDetail((String)"org.teiid.SECURITY", (Throwable)e, (Object[])new Object[]{"error running session monitor, unable to monitor:", info.getSessionId()});
            }
        }
    }

    public void closeSession(String sessionID) throws InvalidSessionException {
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"closeSession", sessionID});
        if (sessionID == null) {
            throw new InvalidSessionException(RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{sessionID}));
        }
        SessionMetadata info = this.sessionCache.remove(sessionID);
        if (info == null) {
            throw new InvalidSessionException(RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{sessionID}));
        }
        if (info.getVDBName() != null) {
            try {
                this.dqp.terminateSession(info.getSessionId());
            }
            catch (Exception e) {
                LogManager.logWarning((String)"org.teiid.SECURITY", (Throwable)e, (String)"Exception terminitating session");
            }
        }
    }

    public SessionMetadata createSession(String userName, Credentials credentials, String applicationName, Properties properties, boolean authenticate) throws LoginException, SessionServiceException {
        ArgCheck.isNotNull((Object)applicationName);
        ArgCheck.isNotNull((Object)properties);
        String securityDomain = "none";
        Object securityContext = null;
        Subject subject = null;
        List<String> domains = this.securityDomainNames;
        VDBMetaData vdb = null;
        String vdbName = properties.getProperty("VirtualDatabaseName");
        if (vdbName != null) {
            String vdbVersion = properties.getProperty("VirtualDatabaseVersion");
            vdb = this.getActiveVDB(vdbName, vdbVersion);
        }
        if (this.sessionMaxLimit > 0L && (long)this.getActiveSessionsCount() >= this.sessionMaxLimit) {
            throw new SessionServiceException(RuntimePlugin.Util.getString("SessionServiceImpl.reached_max_sessions", new Object[]{new Long(this.sessionMaxLimit)}));
        }
        if (domains != null && !domains.isEmpty() && authenticate) {
            boolean onlyAllowPassthrough = Boolean.valueOf(properties.getProperty("PassthroughAuthentication", "false"));
            TeiidLoginContext membership = this.authenticate(userName, credentials, applicationName, domains, onlyAllowPassthrough);
            userName = membership.getUserName();
            securityDomain = membership.getSecurityDomain();
            securityContext = membership.getSecurityContext();
            subject = membership.getSubject();
        } else {
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"No Security Domain configured for Teiid for authentication"});
        }
        long creationTime = System.currentTimeMillis();
        SessionMetadata newSession = new SessionMetadata();
        newSession.setSessionToken(new SessionToken(userName));
        newSession.setSessionId(newSession.getSessionToken().getSessionID());
        newSession.setUserName(userName);
        newSession.setCreatedTime(creationTime);
        newSession.setApplicationName(applicationName);
        newSession.setClientHostName(properties.getProperty("clientHostName"));
        newSession.setIPAddress(properties.getProperty("clientIpAddress"));
        newSession.setClientHardwareAddress(properties.getProperty("clientMAC"));
        newSession.setSecurityDomain(securityDomain);
        if (vdb != null) {
            newSession.setVDBName(vdb.getName());
            newSession.setVDBVersion(vdb.getVersion());
        }
        newSession.setSubject(subject);
        newSession.setSecurityContext(securityContext);
        newSession.setVdb(vdb);
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Logon successful, created", newSession});
        this.sessionCache.put(newSession.getSessionId(), newSession);
        return newSession;
    }

    protected abstract TeiidLoginContext authenticate(String var1, Credentials var2, String var3, List<String> var4, boolean var5) throws LoginException;

    VDBMetaData getActiveVDB(String vdbName, String vdbVersion) throws SessionServiceException {
        VDBMetaData vdb = null;
        int firstIndex = vdbName.indexOf(46);
        int lastIndex = vdbName.lastIndexOf(46);
        if (firstIndex != -1) {
            if (firstIndex != lastIndex || vdbVersion != null) {
                throw new SessionServiceException(RuntimePlugin.Util.getString("ambigious_name", new Object[]{vdbName, vdbVersion}));
            }
            vdbVersion = vdbName.substring(firstIndex + 1);
            vdbName = vdbName.substring(0, firstIndex);
        }
        try {
            if (vdbVersion == null) {
                vdbVersion = "latest";
                vdb = this.vdbRepository.getVDB(vdbName);
            } else {
                vdb = this.vdbRepository.getVDB(vdbName, Integer.parseInt(vdbVersion));
            }
        }
        catch (NumberFormatException e) {
            throw new SessionServiceException((Throwable)e, RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._3", new Object[]{vdbVersion}));
        }
        if (vdb == null) {
            throw new SessionServiceException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._1", new Object[]{vdbName, vdbVersion}));
        }
        if (vdb.getStatus() != VDB.Status.ACTIVE) {
            throw new SessionServiceException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._2", new Object[]{vdbName, vdbVersion}));
        }
        if (vdb.getConnectionType() == VDB.ConnectionType.NONE) {
            throw new SessionServiceException(RuntimePlugin.Util.getString("VDBService.VDB_does_not_exist._4", new Object[]{vdbName, vdbVersion}));
        }
        return vdb;
    }

    public LoginContext createLoginContext(String securityDomain, final String user, final String password) throws LoginException {
        CallbackHandler handler = new CallbackHandler(){

            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (int i = 0; i < callbacks.length; ++i) {
                    if (callbacks[i] instanceof NameCallback) {
                        NameCallback nc = (NameCallback)callbacks[i];
                        nc.setName(user);
                        continue;
                    }
                    if (callbacks[i] instanceof PasswordCallback) {
                        PasswordCallback pc = (PasswordCallback)callbacks[i];
                        if (password == null) continue;
                        pc.setPassword(password.toCharArray());
                        continue;
                    }
                    throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
                }
            }
        };
        return new LoginContext(securityDomain, handler);
    }

    public Collection<SessionMetadata> getActiveSessions() {
        return new ArrayList<SessionMetadata>(this.sessionCache.values());
    }

    public SessionMetadata getActiveSession(String sessionID) {
        return this.sessionCache.get(sessionID);
    }

    public int getActiveSessionsCount() throws SessionServiceException {
        return this.sessionCache.size();
    }

    public Collection<SessionMetadata> getSessionsLoggedInToVDB(String VDBName, int vdbVersion) throws SessionServiceException {
        if (VDBName == null || vdbVersion <= 0) {
            return Collections.emptyList();
        }
        ArrayList<SessionMetadata> results = new ArrayList<SessionMetadata>();
        for (SessionMetadata info : this.sessionCache.values()) {
            if (!VDBName.equalsIgnoreCase(info.getVDBName()) || vdbVersion != info.getVDBVersion()) continue;
            results.add(info);
        }
        return results;
    }

    public void pingServer(String sessionID) throws InvalidSessionException {
        SessionMetadata info = this.getSessionInfo(sessionID);
        info.setLastPingTime(System.currentTimeMillis());
        this.sessionCache.put(sessionID, info);
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Keep-alive ping received for session:", sessionID});
    }

    public boolean terminateSession(String terminatedSessionID, String adminSessionID) {
        Object[] params = new Object[]{adminSessionID, terminatedSessionID};
        LogManager.logInfo((String)"org.teiid.SECURITY", (String)RuntimePlugin.Util.getString("SessionServiceImpl.terminateSession", params));
        try {
            this.closeSession(terminatedSessionID);
            return true;
        }
        catch (InvalidSessionException e) {
            LogManager.logWarning((String)"org.teiid.SECURITY", (Throwable)e, (String)RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{e.getMessage()}));
            return false;
        }
    }

    public SessionMetadata validateSession(String sessionID) throws InvalidSessionException, SessionServiceException {
        SessionMetadata info = this.getSessionInfo(sessionID);
        return info;
    }

    private SessionMetadata getSessionInfo(String sessionID) throws InvalidSessionException {
        if (sessionID == null) {
            throw new InvalidSessionException(RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{sessionID}));
        }
        SessionMetadata info = this.sessionCache.get(sessionID);
        if (info == null) {
            throw new InvalidSessionException(RuntimePlugin.Util.getString("SessionServiceImpl.invalid_session", new Object[]{sessionID}));
        }
        return info;
    }

    public long getSessionMaxLimit() {
        return this.sessionMaxLimit;
    }

    public void setSessionMaxLimit(long limit) {
        this.sessionMaxLimit = limit;
    }

    public long getSessionExpirationTimeLimit() {
        return this.sessionExpirationTimeLimit;
    }

    public void setSessionExpirationTimeLimit(long limit) {
        this.sessionExpirationTimeLimit = limit;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public void setAuthenticationType(AuthenticationType flag) {
        this.authenticationType = flag;
    }

    public void start() {
        LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{RuntimePlugin.Util.getString("auth_type", new Object[]{this.authenticationType, this.securityDomainNames})});
        this.sessionMonitor.schedule(new TimerTask(){

            @Override
            public void run() {
                SessionServiceImpl.this.monitorSessions();
            }
        }, 0L, 600000L);
    }

    public void stop() {
        this.sessionMonitor.cancel();
        this.sessionCache.clear();
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public void setDqp(DQPCore dqp) {
        this.dqp = dqp;
    }

    public void associateSubjectInContext(String securityDomain, Subject subject) {
        Principal principal = null;
        Iterator<Principal> i$ = subject.getPrincipals().iterator();
        if (i$.hasNext()) {
            Principal p;
            principal = p = i$.next();
        }
        this.securityHelper.associateSecurityContext(securityDomain, this.securityHelper.createSecurityContext(securityDomain, principal, null, subject));
    }

    public Subject getSubjectInContext(String securityDomain) {
        return this.securityHelper.getSubjectInContext(securityDomain);
    }

    public void setGssSecurityDomain(String domain) {
        this.gssSecurityDomain = domain;
    }

    public String getGssSecurityDomain() {
        return this.gssSecurityDomain;
    }

    protected Collection<String> getDomainsForUser(List<String> domains, String username) {
        if (username == null) {
            return domains;
        }
        String domain = SessionServiceImpl.getDomainName(username);
        if (domain == null) {
            return domains;
        }
        String domainHolder = null;
        for (String d : domains) {
            if (!d.equalsIgnoreCase(domain)) continue;
            domainHolder = d;
            break;
        }
        if (domainHolder == null) {
            return Collections.emptyList();
        }
        LinkedList<String> result = new LinkedList<String>();
        result.add(domainHolder);
        return result;
    }

    protected static String getBaseUsername(String username) {
        if (username == null) {
            return username;
        }
        int index = SessionServiceImpl.getQualifierIndex(username);
        String result = username;
        if (index != -1) {
            result = username.substring(0, index);
        }
        return result.replaceAll("\\\\@", AT);
    }

    static String escapeName(String name) {
        if (name == null) {
            return name;
        }
        return name.replaceAll(AT, "\\\\@");
    }

    static String getDomainName(String username) {
        if (username == null) {
            return username;
        }
        int index = SessionServiceImpl.getQualifierIndex(username);
        if (index != -1) {
            return username.substring(index + 1);
        }
        return null;
    }

    static int getQualifierIndex(String username) {
        block1: {
            int index = username.length();
            do {
                --index;
                if ((index = username.lastIndexOf(AT, index)) == -1) break block1;
            } while (index <= 0 || username.charAt(index - 1) == '\\');
            return index;
        }
        return -1;
    }
}

