/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.MetadataStoreGroup;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.vdb.runtime.VDBKey;

public class TestCompositeVDB {
    public static TransformationMetadata createTransformationMetadata(MetadataStore metadataStore, String vdbName) throws Exception {
        CompositeVDB cvdb = TestCompositeVDB.createCompositeVDB(metadataStore, vdbName);
        VDBMetaData vdb = cvdb.getVDB();
        return (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
    }

    private static CompositeVDB createCompositeVDB(MetadataStore metadataStore, String vdbName) {
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName(vdbName);
        vdbMetaData.setVersion(1);
        for (Schema schema : metadataStore.getSchemas().values()) {
            vdbMetaData.addModel(RealMetadataFactory.createModel((String)schema.getName(), (boolean)schema.isPhysical()));
        }
        MetadataStoreGroup metaGroup = new MetadataStoreGroup();
        metaGroup.addStore(metadataStore);
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        cmr.addConnectorManager("source", TestCompositeVDB.getConnectorManager("FakeTranslator", "FakeConnection", TestCompositeVDB.getFuncsOne()));
        cmr.addConnectorManager("source2", TestCompositeVDB.getConnectorManager("FakeTranslator2", "FakeConnection2", TestCompositeVDB.getFuncsTwo()));
        CompositeVDB cvdb = new CompositeVDB(vdbMetaData, metaGroup, null, null, RealMetadataFactory.SFM.getSystemFunctions(), cmr, new MetadataStore[0]);
        return cvdb;
    }

    private static ConnectorManager getConnectorManager(String translatorName, String connectionName, List<FunctionMethod> funcs) {
        final ExecutionFactory ef = (ExecutionFactory)Mockito.mock(ExecutionFactory.class);
        Mockito.stub((Object)ef.getPushDownFunctions()).toReturn(funcs);
        ConnectorManager cm = new ConnectorManager(translatorName, connectionName){

            public ExecutionFactory getExecutionFactory() {
                return ef;
            }
        };
        cm.start();
        return cm;
    }

    private static List<FunctionMethod> getFuncsOne() {
        ArrayList<FunctionMethod> funcs = new ArrayList<FunctionMethod>();
        funcs.add(new FunctionMethod("echo", "echo", "misc", new FunctionParameter[]{new FunctionParameter("columnName", "string", "")}, new FunctionParameter("result", "string", "")));
        funcs.add(new FunctionMethod("duplicate_func", "duplicate", "misc", new FunctionParameter[]{new FunctionParameter("columnName", "string", "")}, new FunctionParameter("result", "string", "")));
        return funcs;
    }

    private static List<FunctionMethod> getFuncsTwo() {
        ArrayList<FunctionMethod> funcs = new ArrayList<FunctionMethod>();
        funcs.add(new FunctionMethod("duplicate_func", "duplicate", "misc", new FunctionParameter[]{new FunctionParameter("columnName", "string", "")}, new FunctionParameter("result", "string", "")));
        funcs.add(new FunctionMethod("duplicate_func", "duplicate", "misc", new FunctionParameter[]{new FunctionParameter("c1", "integer", ""), new FunctionParameter("c2", "string", "")}, new FunctionParameter("result", "string", "")));
        return funcs;
    }

    private void helpResolve(String sql) throws Exception {
        TransformationMetadata metadata = TestCompositeVDB.createTransformationMetadata((MetadataStore)RealMetadataFactory.exampleBQTCached().getMetadataStore(), "bqt");
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
    }

    @Test
    public void testSourceMetadataStoreFunction() throws Exception {
        this.helpResolve("SELECT bqt1.reverse(BQT1.SmallA.INTKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testTranslatorDefinedFunction() throws Exception {
        this.helpResolve("SELECT SYS.echo(BQT1.SmallA.INTKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testPartialUDFName() throws Exception {
        this.helpResolve("SELECT echo(BQT1.SmallA.STRINGKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testFullyQualifiedDuplicate() throws Exception {
        this.helpResolve("SELECT SYS.duplicate_func(BQT1.SmallA.STRINGKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testNonQualifiedDuplicateWithDifferentSignature() throws Exception {
        this.helpResolve("SELECT duplicate_func(BQT1.SmallA.INTKEY, BQT1.SmallA.STRINGKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testNonQualifiedDuplicate() throws Exception {
        this.helpResolve("SELECT duplicate_func(BQT1.SmallA.INTKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testRemoveChild() throws Exception {
        CompositeVDB vdb = TestCompositeVDB.createCompositeVDB(RealMetadataFactory.exampleBQTStore(), "bqt");
        VDBKey child = new VDBKey("foo", 1);
        vdb.removeChild(child);
        Assert.assertNotNull((Object)vdb.getVDB());
        Assert.assertFalse((boolean)vdb.hasChildVdb(child));
        vdb.addChild(TestCompositeVDB.createCompositeVDB(RealMetadataFactory.example1Store(), "foo"));
        Assert.assertTrue((boolean)vdb.hasChildVdb(child));
        Assert.assertNotNull((Object)vdb.getVDB());
    }
}

