/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.util.ExceptionUtil;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ClientServiceRegistry;

public class LocalServerConnection
implements ServerConnection {
    public static final String TEIID_RUNTIME_CONTEXT = "teiid/queryengine";
    private LogonResult result;
    private boolean shutdown;
    private ClientServiceRegistry csr;
    private DQPWorkContext workContext = new DQPWorkContext();
    private Properties connectionProperties;
    private boolean passthrough;

    public LocalServerConnection(Properties connectionProperties, boolean useCallingThread) throws CommunicationException, ConnectionException {
        this.connectionProperties = connectionProperties;
        this.csr = this.getClientServiceRegistry();
        this.workContext.setSecurityHelper(this.csr.getSecurityHelper());
        this.workContext.setUseCallingThread(useCallingThread);
        this.authenticate();
        this.passthrough = Boolean.valueOf(connectionProperties.getProperty("PassthroughAuthentication", "false"));
    }

    protected ClientServiceRegistry getClientServiceRegistry() {
        try {
            InitialContext ic = new InitialContext();
            return (ClientServiceRegistry)ic.lookup(TEIID_RUNTIME_CONTEXT);
        }
        catch (NamingException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40067, (Throwable)e);
        }
    }

    public synchronized void authenticate() throws ConnectionException, CommunicationException {
        try {
            this.result = this.getService(ILogon.class).logon(this.connectionProperties);
        }
        catch (LogonException e) {
            throw new ConnectionException((BundleUtil.Event)RuntimePlugin.Event.TEIID40068, (Throwable)e, e.getMessage());
        }
        catch (TeiidComponentException e) {
            if (e.getCause() instanceof CommunicationException) {
                throw (CommunicationException)e.getCause();
            }
            throw new CommunicationException((BundleUtil.Event)RuntimePlugin.Event.TEIID40069, (Throwable)e);
        }
    }

    public <T> T getService(final Class<T> iface) {
        return iface.cast(Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{iface}, new InvocationHandler(){

            @Override
            public Object invoke(Object arg0, final Method arg1, final Object[] arg2) throws Throwable {
                if (LocalServerConnection.this.shutdown) {
                    throw ExceptionUtil.convertException((Method)arg1, (Throwable)new TeiidComponentException(RuntimePlugin.Util.getString("LocalTransportHandler.Transport_shutdown")));
                }
                try {
                    if (LocalServerConnection.this.passthrough && !arg1.getDeclaringClass().equals(ILogon.class) && !LocalServerConnection.this.csr.getSecurityHelper().sameSubject(LocalServerConnection.this.workContext.getSession().getSecurityDomain(), LocalServerConnection.this.workContext.getSession().getSecurityContext(), LocalServerConnection.this.workContext.getSubject())) {
                        LocalServerConnection.this.authenticate();
                    }
                    final Object service = LocalServerConnection.this.csr.getClientService(iface);
                    return LocalServerConnection.this.workContext.runInContext((Callable)new Callable<Object>(){

                        @Override
                        public Object call() throws Exception {
                            return arg1.invoke(service, arg2);
                        }
                    });
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
                catch (Throwable e) {
                    throw ExceptionUtil.convertException((Method)arg1, (Throwable)e);
                }
            }
        }));
    }

    public boolean isOpen(long msToTest) {
        return !this.shutdown;
    }

    public void close() {
        this.shutdown(true);
    }

    private void shutdown(boolean logoff) {
        if (this.shutdown) {
            return;
        }
        if (logoff) {
            this.logoff();
        }
        this.shutdown = true;
    }

    private void logoff() {
        try {
            ResultsFuture writeFuture = this.getService(ILogon.class).logoff();
            if (writeFuture != null) {
                writeFuture.get(5000L, TimeUnit.MILLISECONDS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LogonResult getLogonResult() {
        return this.result;
    }

    public boolean isSameInstance(ServerConnection conn) throws CommunicationException {
        return conn instanceof LocalServerConnection;
    }

    public void cleanUp() {
    }
}

