/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.Properties;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.client.security.ILogon;
import org.teiid.client.security.InvalidSessionException;
import org.teiid.client.security.LogonException;
import org.teiid.client.security.LogonResult;
import org.teiid.client.security.SessionToken;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.logging.LogManager;
import org.teiid.net.CommunicationException;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.Credentials;

public class LogonImpl
implements ILogon {
    private SessionService service;
    private String clusterName;

    public LogonImpl(SessionService service, String clusterName) {
        this.service = service;
        this.clusterName = clusterName;
    }

    public LogonResult logon(Properties connProps) throws LogonException, TeiidComponentException, CommunicationException {
        if (this.service.getGssSecurityDomain() != null && connProps.get("KRB5TOKEN") != null) {
            Subject user = this.service.getSubjectInContext(this.service.getGssSecurityDomain());
            if (user == null) {
                throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40054, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40054, new Object[0]));
            }
            return this.logon(connProps, (byte[])connProps.get("KRB5TOKEN"));
        }
        if (!AuthenticationType.CLEARTEXT.equals((Object)this.service.getAuthenticationType())) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40055, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40055, new Object[0]));
        }
        return this.logon(connProps, null);
    }

    private LogonResult logon(Properties connProps, byte[] krb5ServiceTicket) throws LogonException {
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        String oldSessionId = workContext.getSessionId();
        String applicationName = connProps.getProperty("ApplicationName");
        String user = connProps.getProperty("user", "anonymous");
        String password = connProps.getProperty("password");
        Credentials credential = null;
        if (password != null) {
            credential = new Credentials(password.toCharArray());
        }
        try {
            SessionMetadata sessionInfo = this.service.createSession(user, credential, applicationName, connProps, true);
            this.updateDQPContext(sessionInfo);
            if (DQPWorkContext.getWorkContext().getClientAddress() == null) {
                sessionInfo.setEmbedded(true);
            }
            if (oldSessionId != null) {
                try {
                    this.service.closeSession(oldSessionId);
                }
                catch (InvalidSessionException e) {
                    // empty catch block
                }
            }
            LogonResult result = new LogonResult(sessionInfo.getSessionToken(), sessionInfo.getVDBName(), sessionInfo.getVDBVersion(), this.clusterName);
            if (krb5ServiceTicket != null) {
                result.addProperty("KRB5TOKEN", (Object)krb5ServiceTicket);
            }
            return result;
        }
        catch (LoginException e) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40056, e.getMessage());
        }
        catch (SessionServiceException e) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40057, (Throwable)e, e.getMessage());
        }
    }

    public LogonResult neogitiateGssLogin(Properties connProps, byte[] serviceTicket, boolean createSession) throws LogonException {
        if (!AuthenticationType.GSS.equals((Object)this.service.getAuthenticationType())) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40058, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40058, new Object[0]));
        }
        String user = connProps.getProperty("user");
        String password = connProps.getProperty("password");
        try {
            String securityDomain = this.service.getGssSecurityDomain();
            if (securityDomain == null) {
                throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40059, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40059, new Object[0]));
            }
            LoginContext ctx = this.service.createLoginContext(securityDomain, user, password);
            ctx.login();
            Subject subject = ctx.getSubject();
            GSSResult result = Subject.doAs(subject, new GssAction(serviceTicket));
            if (result == null) {
                throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40060, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40060, new Object[0]));
            }
            if (result.context.isEstablished()) {
                this.service.associateSubjectInContext(securityDomain, subject);
            }
            if (!result.context.isEstablished() || !createSession) {
                LogonResult logonResult = new LogonResult(new SessionToken(0L, "temp"), "internal", 0, "internal");
                logonResult.addProperty("KRB5TOKEN", (Object)result.serviceTicket);
                logonResult.addProperty("KRB5_CONTEXT_ESTABLISHED", (Object)new Boolean(result.context.isEstablished()));
                return logonResult;
            }
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object[])new Object[]{"Kerberos context established"});
            return this.logon(connProps, result.serviceTicket);
        }
        catch (LoginException e) {
            throw new LogonException((BundleUtil.Event)RuntimePlugin.Event.TEIID40061, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40061, new Object[0]));
        }
    }

    private String updateDQPContext(SessionMetadata s) {
        String sessionID = s.getSessionId();
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        workContext.setSession(s);
        return sessionID;
    }

    public ResultsFuture<?> logoff() throws InvalidSessionException {
        this.service.closeSession(DQPWorkContext.getWorkContext().getSessionId());
        DQPWorkContext.getWorkContext().getSession().setSessionId(null);
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> ping() throws InvalidSessionException, TeiidComponentException {
        String id = DQPWorkContext.getWorkContext().getSessionId();
        if (id != null) {
            this.service.pingServer(id);
        }
        LogManager.logTrace((String)"org.teiid.SECURITY", (Object[])new Object[]{"Ping", id});
        return ResultsFuture.NULL_FUTURE;
    }

    public ResultsFuture<?> ping(Collection<String> sessions) throws TeiidComponentException, CommunicationException {
        for (String string : sessions) {
            try {
                this.service.pingServer(string);
            }
            catch (InvalidSessionException e) {}
        }
        return ResultsFuture.NULL_FUTURE;
    }

    public void assertIdentity(SessionToken checkSession) throws InvalidSessionException, TeiidComponentException {
        SessionMetadata sessionInfo = null;
        try {
            sessionInfo = this.service.validateSession(checkSession.getSessionID());
        }
        catch (SessionServiceException e) {
            throw new TeiidComponentException((BundleUtil.Event)RuntimePlugin.Event.TEIID40062, (Throwable)e);
        }
        if (sessionInfo == null) {
            throw new InvalidSessionException((BundleUtil.Event)RuntimePlugin.Event.TEIID40063);
        }
        SessionToken st = sessionInfo.getSessionToken();
        if (!st.equals((Object)checkSession)) {
            throw new InvalidSessionException((BundleUtil.Event)RuntimePlugin.Event.TEIID40064);
        }
        this.updateDQPContext(sessionInfo);
    }

    class GSSResult {
        GSSContext context;
        byte[] serviceTicket;

        public GSSResult(GSSContext context, byte[] serviceTicket) {
            this.context = context;
            this.serviceTicket = serviceTicket;
        }
    }

    class GssAction
    implements PrivilegedAction<GSSResult> {
        byte[] serviceTicket;

        public GssAction(byte[] ticket) {
            this.serviceTicket = ticket;
        }

        @Override
        public GSSResult run() {
            GSSContext context = null;
            try {
                GSSManager manager = GSSManager.getInstance();
                context = manager.createContext((GSSCredential)null);
                this.serviceTicket = context.acceptSecContext(this.serviceTicket, 0, this.serviceTicket.length);
                return new GSSResult(context, this.serviceTicket);
            }
            catch (GSSException e) {
                LogManager.logError((String)"org.teiid.SECURITY", (Throwable)e, (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40014, new Object[0]));
                return null;
            }
        }
    }
}

