/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.UUID;
import org.teiid.core.types.DataTypeManager;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;

public class PgCatalogMetadataStore
extends MetadataFactory {
    private static final long serialVersionUID = 2158418324376966987L;
    public static final int PG_TYPE_OIDVECTOR = 30;
    public static final int PG_TYPE_OIDARRAY = 1028;
    public static final int PG_TYPE_CHARARRAY = 1002;
    public static final int PG_TYPE_TEXTARRAY = 1009;
    private Random random;

    public PgCatalogMetadataStore(String modelName, Map<String, Datatype> dataTypes) throws TranslatorException {
        super(modelName, 1, modelName, dataTypes, new Properties(), null);
        this.add_pg_namespace();
        this.add_pg_class();
        this.add_pg_attribute();
        this.add_pg_type();
        this.add_pg_index();
        this.add_pg_am();
        this.add_pg_proc();
        this.add_pg_trigger();
        this.add_pg_attrdef();
        this.add_pg_database();
        this.add_pg_user();
        this.add_matpg_relatt();
        this.add_matpg_datatype();
        this.addFunction("hasPerm", "has_function_privilege");
        this.addFunction("getExpr2", "pg_get_expr");
        this.addFunction("getExpr3", "pg_get_expr");
    }

    protected void setUUID(AbstractMetadataRecord record) {
        byte[] randomBytes = new byte[8];
        if (this.random == null) {
            this.random = new Random(2010L);
        }
        this.random.nextBytes(randomBytes);
        randomBytes[6] = (byte)(randomBytes[6] & 0xF);
        randomBytes[6] = (byte)(randomBytes[6] | 0x40);
        long msb = new BigInteger(randomBytes).longValue();
        this.random.nextBytes(randomBytes);
        randomBytes[0] = (byte)(randomBytes[0] & 0x3F);
        randomBytes[0] = (byte)(randomBytes[0] | 0x80);
        long lsb = new BigInteger(randomBytes).longValue();
        record.setUUID("mmuid:" + new UUID(msb, lsb));
    }

    private Table createView(String name) throws TranslatorException {
        Table t = this.addTable(name);
        t.setSystem(true);
        t.setSupportsUpdate(false);
        t.setVirtual(true);
        t.setTableType(Table.Type.Table);
        return t;
    }

    private Table add_pg_am() throws TranslatorException {
        Table t = this.createView("pg_am");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("amname", "string", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, 'btree' as amname";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_attrdef() throws TranslatorException {
        Table t = this.createView("pg_attrdef");
        this.addColumn("adrelid", "integer", (ColumnSet)t);
        this.addColumn("adnum", "short", (ColumnSet)t);
        this.addColumn("adbin", "string", (ColumnSet)t);
        this.addColumn("adsrc", "string", (ColumnSet)t);
        String transformation = "SELECT st.oid as adrelid, convert(t1.Position, short) as adnum, case when t1.IsAutoIncremented then 'nextval(' else t1.DefaultValue end as adbin, case when t1.IsAutoIncremented then 'nextval(' else t1.DefaultValue end as adsrc FROM SYS.Columns as t1 LEFT OUTER JOIN SYS.Tables st ON (st.Name = t1.TableName AND st.SchemaName = t1.SchemaName)";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_attribute() throws TranslatorException {
        Table t = this.createView("pg_attribute");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("attrelid", "integer", (ColumnSet)t);
        this.addColumn("attname", "string", (ColumnSet)t);
        this.addColumn("atttypid", "integer", (ColumnSet)t);
        this.addColumn("attlen", "short", (ColumnSet)t);
        this.addColumn("attnum", "short", (ColumnSet)t);
        this.addColumn("atttypmod", "integer", (ColumnSet)t);
        this.addColumn("attnotnull", "boolean", (ColumnSet)t);
        this.addColumn("attisdropped", "boolean", (ColumnSet)t);
        this.addColumn("atthasdef", "boolean", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_attr", Arrays.asList("oid"), t);
        String transformation = "SELECT t1.OID as oid, st.oid as attrelid, t1.Name as attname, pt.oid as atttypid,pt.typlen as attlen, convert(t1.Position, short) as attnum, (CASE WHEN (t1.DataType = 'bigdecimal' OR t1.DataType = 'biginteger' OR t1.DataType = 'float' OR t1.DataType='double') THEN (4+(65536*t1.Precision)+t1.Scale) ELSE (4+t1.Length) END) as atttypmod, CASE WHEN (t1.NullType = 'No Nulls') THEN true ELSE false END as attnotnull, false as attisdropped, false as atthasdef FROM SYS.Columns as t1 LEFT OUTER JOIN SYS.Tables st ON (st.Name = t1.TableName AND st.SchemaName = t1.SchemaName) LEFT OUTER JOIN pg_catalog.matpg_datatype pt ON t1.DataType = pt.Name";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private Table add_pg_class() throws TranslatorException {
        Table t = this.createView("pg_class");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("relname", "string", (ColumnSet)t);
        this.addColumn("relnamespace", "integer", (ColumnSet)t);
        this.addColumn("relkind", "char", (ColumnSet)t);
        this.addColumn("relam", "integer", (ColumnSet)t);
        this.addColumn("reltuples", "float", (ColumnSet)t);
        this.addColumn("relpages", "integer", (ColumnSet)t);
        this.addColumn("relhasrules", "boolean", (ColumnSet)t);
        this.addColumn("relhasoids", "boolean", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_class", Arrays.asList("oid"), t);
        String transformation = "SELECT t1.OID as oid, t1.name as relname, (SELECT OID FROM SYS.Schemas WHERE Name = t1.SchemaName) as relnamespace, convert((CASE t1.isPhysical WHEN true THEN 'r' ELSE 'v' END), char) as relkind,0 as relam, convert(0, float) as reltuples, 0 as relpages, false as relhasrules, false as relhasoids FROM SYS.Tables t1";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private Table add_pg_index() throws TranslatorException {
        Table t = this.createView("pg_index");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("indexrelid", "integer", (ColumnSet)t);
        this.addColumn("indrelid", "integer", (ColumnSet)t);
        this.addColumn("indisclustered", "boolean", (ColumnSet)t);
        this.addColumn("indisunique", "boolean", (ColumnSet)t);
        this.addColumn("indisprimary", "boolean", (ColumnSet)t);
        this.addColumn("indexprs", "string", (ColumnSet)t);
        this.addColumn("indkey", "string", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_index", Arrays.asList("oid"), t);
        String transformation = "SELECT t1.OID as oid, t1.OID as indexrelid, (SELECT OID FROM SYS.Tables WHERE SchemaName = t1.SchemaName AND Name = t1.TableName) as indrelid, false indisclustered, (CASE t1.KeyType WHEN 'Unique' THEN true ELSE false END) as indisunique, (CASE t1.KeyType WHEN 'Primary' THEN true ELSE false END) as indisprimary, '' as indexprs, '0' as indkey FROM SYS.KeyColumns as t1";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private Table add_pg_namespace() throws TranslatorException {
        Table t = this.createView("pg_namespace");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("nspname", "string", (ColumnSet)t);
        String transformation = "SELECT t1.OID as oid, t1.Name as nspname FROM SYS.Schemas as t1";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_proc() throws TranslatorException {
        Table t = this.createView("pg_proc");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("proname", "string", (ColumnSet)t);
        this.addColumn("proretset", "boolean", (ColumnSet)t);
        this.addColumn("prorettype", "integer", (ColumnSet)t);
        this.addColumn("pronargs", "short", (ColumnSet)t);
        Column c = this.addColumn("proargtypes", "object", (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(30));
        c = this.addColumn("proargnames", "object", (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1009));
        c = this.addColumn("proargmodes", "object", (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1002));
        c = this.addColumn("proallargtypes", "object", (ColumnSet)t);
        c.setProperty("pg_type:oid", String.valueOf(1028));
        this.addColumn("pronamespace", "integer", (ColumnSet)t);
        this.addPrimaryKey("pk_pg_proc", Arrays.asList("oid"), t);
        String transformation = "SELECT t1.OID as oid, t1.Name as proname, (SELECT (CASE WHEN count(pp.Type)>0 THEN true else false END) as x FROM ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName and pp.Type='ResultSet') as proretset, CASE WHEN (SELECT count(dt.oid) FROM ProcedureParams pp, matpg_datatype dt WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type IN ('ReturnValue', 'ResultSet') AND dt.Name = pp.DataType) IS NULL THEN (select oid from pg_type WHERE typname = 'void') WHEN (SELECT count(dt.oid) FROM ProcedureParams pp, matpg_datatype dt WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type = 'ResultSet' AND dt.Name = pp.DataType) IS NOT NULL THEN (select oid from pg_type WHERE typname = 'record') ELSE (SELECT dt.oid FROM ProcedureParams pp, matpg_datatype dt WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type = 'ReturnValue' AND dt.Name = pp.DataType) END as prorettype,  convert((SELECT count(*) FROM ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type IN ('In', 'InOut')), short) as pronargs, (select " + this.arrayAgg("y.oid", "y.type, y.position") + " FROM (" + this.paramTable("'ResultSet','ReturnValue', 'Out'") + ") as y) as proargtypes, " + "(select " + this.arrayAgg("y.name", "y.type, y.position") + " FROM (SELECT pp.Name as name, pp.position as position, pp.Type as type FROM ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type NOT IN ('ReturnValue' )) as y) as proargnames, " + "(select case WHEN count(distinct(y.type)) = 1 THEN null ELSE " + this.arrayAgg("CASE WHEN (y.type ='In') THEN 'i' WHEN (y.type = 'Out') THEN 'o' WHEN (y.type = 'InOut') THEN 'b' WHEN (y.type = 'ResultSet') THEN 't' END", "y.type,y.position") + " END FROM (SELECT pp.Type as type, pp.Position as position FROM ProcedureParams pp WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type NOT IN ('ReturnValue')) as y) as proargmodes, " + "(select case WHEN count(distinct(y.oid)) = 1 THEN null ELSE " + this.arrayAgg("y.oid", "y.type, y.position") + " END FROM (" + this.paramTable("'ReturnValue'") + ") as y) as proallargtypes, " + "(SELECT OID FROM SYS.Schemas WHERE Name = t1.SchemaName) as pronamespace " + "FROM SYS.Procedures as t1";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private String paramTable(String notIn) {
        return "SELECT case when pp.Type <> 'ResultSet' AND pp.DataType = 'object' then 2283 else dt.oid end as oid, pp.Position as position, pp.Type as type FROM ProcedureParams pp LEFT JOIN matpg_datatype dt ON pp.DataType=dt.Name WHERE pp.ProcedureName = t1.Name AND pp.SchemaName = t1.SchemaName AND pp.Type NOT IN (" + notIn + ")";
    }

    private String arrayAgg(String select, String orderby) {
        return "array_agg(" + select + " ORDER BY " + orderby + ")";
    }

    private Table add_pg_trigger() throws TranslatorException {
        Table t = this.createView("pg_trigger");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("tgconstrrelid", "integer", (ColumnSet)t);
        this.addColumn("tgfoid", "integer", (ColumnSet)t);
        this.addColumn("tgargs", "integer", (ColumnSet)t);
        this.addColumn("tgnargs", "integer", (ColumnSet)t);
        this.addColumn("tgdeferrable", "boolean", (ColumnSet)t);
        this.addColumn("tginitdeferred", "boolean", (ColumnSet)t);
        this.addColumn("tgconstrname", "string", (ColumnSet)t);
        this.addColumn("tgrelid", "integer", (ColumnSet)t);
        String transformation = "SELECT 1 as oid, 1 as tgconstrrelid, 1 as tgfoid, 1 as tgargs, 1 as tgnargs, false as tgdeferrable, false as tginitdeferred, 'dummy' as tgconstrname, 1 as tgrelid FROM SYS.Tables WHERE 1=2";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_type() throws TranslatorException {
        Table t = this.createView("pg_type");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("typname", "string", (ColumnSet)t);
        this.addColumn("typnamespace", "integer", (ColumnSet)t);
        this.addColumn("typlen", "short", (ColumnSet)t);
        this.addColumn("typtype", "char", (ColumnSet)t);
        this.addColumn("typnotnull", "boolean", (ColumnSet)t);
        this.addColumn("typbasetype", "integer", (ColumnSet)t);
        this.addColumn("typtypmod", "integer", (ColumnSet)t);
        this.addColumn("typdelim", "char", (ColumnSet)t);
        this.addColumn("typrelid", "integer", (ColumnSet)t);
        this.addColumn("typelem", "integer", (ColumnSet)t);
        String transformation = "select oid, typname, (SELECT OID FROM SYS.Schemas where Name = 'SYS') as typnamespace, typlen, typtype, false as typnotnull, typbasetype, typtypmod, cast(',' as char) as typdelim, typrelid, typelem from texttable('16,boolean,1,b,0,-1,0,0\n1043,string,-1,b,0,-1,0,0\n25,text,-1,b,0,-1,0,0\n1042,char,1,b,0,-1,0,0\n21,short,2,b,0,-1,0,0\n20,long,8,b,0,-1,0,0\n23,integer,4,b,0,-1,0,0\n26,oid,4,b,0,-1,0,0\n700,float,4,b,0,-1,0,0\n701,double,8,b,0,-1,0,0\n705,unknown,-2,b,0,-1,0,0\n1082,date,4,b,0,-1,0,0\n1083,datetime,8,b,0,-1,0,0\n1114,timestamp,8,b,0,-1,0,0\n1700,decimal,-1,b,0,-1,0,0\n142,xml,-1,b,0,-1,0,0\n14939,lo,-1,b,0,-1,0,0\n2278,void,4,p,0,-1,0,0\n2249,record,-1,p,0,-1,0,0\n30,oidvector,-1,b,0,-1,0,26\n1000,_bool,-1,b,0,-1,0,16\n1002,_char,-1,b,0,-1,0,18\n1005,_int2,-1,b,0,-1,0,21\n1007,_int4,-1,b,0,-1,0,23\n1009,_text,-1,b,0,-1,0,25\n1028,_oid,-1,b,0,-1,0,26\n1014,_bpchar,-1,b,0,-1,0,1042\n1015,_varchar,-1,b,0,-1,0,1043\n1016,_int8,-1,b,0,-1,0,20\n1021,_float4,-1,b,0,-1,0,700\n1022,_float8,-1,b,0,-1,0,701\n1115,_timestamp,-1,b,0,-1,0,1114\n1182,_date,-1,b,0,-1,0,1082\n1183,_time,-1,b,0,-1,0,1083\n2287,_record,-1,b,0,-1,0,2249\n2283,anyelement,4,p,0,-1,0,0' columns oid integer, typname string, typlen short, typtype char, typbasetype integer, typtypmod integer, typrelid integer, typelem integer) AS t";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_database() throws TranslatorException {
        Table t = this.createView("pg_database");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("datname", "string", (ColumnSet)t);
        this.addColumn("encoding", "integer", (ColumnSet)t);
        this.addColumn("datlastsysoid", "integer", (ColumnSet)t);
        this.addColumn("datallowconn", "char", (ColumnSet)t);
        this.addColumn("datconfig", "object", (ColumnSet)t);
        this.addColumn("datacl", "object", (ColumnSet)t);
        this.addColumn("datdba", "integer", (ColumnSet)t);
        this.addColumn("dattablespace", "integer", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, 'teiid' as datname, 6 as encoding, 100000 as datlastsysoid, convert('t', char) as datallowconn, null, null, 0 as datdba, 0 as dattablespace";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_pg_user() throws TranslatorException {
        Table t = this.createView("pg_user");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("usename", "string", (ColumnSet)t);
        this.addColumn("usecreatedb", "boolean", (ColumnSet)t);
        this.addColumn("usesuper", "boolean", (ColumnSet)t);
        String transformation = "SELECT 0 as oid, null as usename, false as usecreatedb, false as usesuper ";
        t.setSelectTransformation(transformation);
        return t;
    }

    private Table add_matpg_relatt() throws TranslatorException {
        Table t = this.createView("matpg_relatt");
        this.addColumn("attrelid", "integer", (ColumnSet)t);
        this.addColumn("attnum", "short", (ColumnSet)t);
        this.addColumn("attname", "string", (ColumnSet)t);
        this.addColumn("relname", "string", (ColumnSet)t);
        this.addColumn("nspname", "string", (ColumnSet)t);
        this.addColumn("autoinc", "boolean", (ColumnSet)t);
        this.addColumn("typoid", "integer", (ColumnSet)t);
        this.addPrimaryKey("pk_matpg_relatt_names", Arrays.asList("attname", "relname", "nspname"), t);
        this.addIndex("idx_matpg_relatt_ids", true, Arrays.asList("attrelid", "attnum"), t);
        String transformation = "select pg_class.oid as attrelid, attnum, attname, relname, nspname, IsAutoIncremented as autoinc, cast((select p.value from SYS.Properties p where p.name = 'pg_type:oid' and p.uid = SYS.Columns.uid) as integer) as typoid from pg_attribute, pg_class, pg_namespace, SYS.Columns where pg_attribute.attrelid = pg_class.oid and pg_namespace.oid = relnamespace and SchemaName = nspname and TableName = relname and Name = attname";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private Table add_matpg_datatype() throws TranslatorException {
        Table t = this.createView("matpg_datatype");
        this.addColumn("oid", "integer", (ColumnSet)t);
        this.addColumn("typname", "string", (ColumnSet)t);
        this.addColumn("name", "string", (ColumnSet)t);
        this.addColumn("uid", "string", (ColumnSet)t);
        this.addColumn("typlen", "short", (ColumnSet)t);
        this.addPrimaryKey("matpg_datatype_names", Arrays.asList("oid", "name"), t);
        this.addIndex("matpg_datatype_ids", true, Arrays.asList("typname", "oid"), t);
        String transformation = "select pt.oid as oid, pt.typname as typname, t.Name name, t.UID, pt.typlen from pg_catalog.pg_type pt JOIN (select (CASE WHEN (Name = 'clob' OR Name = 'blob') THEN 'lo' WHEN (Name = 'byte' ) THEN 'short' WHEN (Name = 'time' ) THEN 'datetime' WHEN (Name = 'biginteger' ) THEN 'decimal' WHEN (Name = 'bigdecimal' ) THEN 'decimal' WHEN (Name = 'object' ) THEN 'unknown' ELSE Name END) as pg_name, Name, UID from SYS.DataTypes) as t ON t.pg_name = pt.typname";
        t.setSelectTransformation(transformation);
        t.setMaterialized(true);
        return t;
    }

    private FunctionMethod addFunction(String javaFunction, String name) {
        Method[] methods;
        for (Method method : methods = FunctionMethods.class.getMethods()) {
            if (!method.getName().equals(javaFunction)) continue;
            String returnType = DataTypeManager.getDataTypeName(method.getReturnType());
            Class<?>[] params = method.getParameterTypes();
            String[] paramTypes = new String[params.length];
            for (int i = 0; i < params.length; ++i) {
                paramTypes[i] = DataTypeManager.getDataTypeName(params[i]);
            }
            FunctionMethod func = FunctionMethod.createFunctionMethod((String)name, (String)name, (String)"pg", (String)returnType, (String[])paramTypes);
            this.setUUID((AbstractMetadataRecord)func);
            this.getSchema().addFunction(func);
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            func.setInvocationMethod(javaFunction);
            func.setPushdown(FunctionMethod.PushDown.CANNOT_PUSHDOWN);
            func.setClassloader(classLoader);
            func.setInvocationClass(FunctionMethods.class.getName());
            return func;
        }
        throw new AssertionError((Object)"Could not find function");
    }

    public static class FunctionMethods {
        public static Boolean hasPerm(Integer oid, String permission) {
            return true;
        }

        public static String getExpr2(String text, Integer oid) {
            return text;
        }

        public static String getExpr3(String text, Integer oid, Boolean prettyPrint) {
            return text;
        }
    }
}

