/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.deployers.VDBRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.index.IndexMetadataStore;
import org.teiid.metadata.index.RuntimeMetadataPlugin;
import org.teiid.runtime.RuntimePlugin;

public class SystemVDBDeployer {
    private VDBRepository vdbRepository;
    private Closeable file;
    private static final TempFileProvider PROVIDER;

    public void start() {
        try {
            VirtualFile mountPoint = VFS.getChild((String)"content/System.vdb");
            if (!mountPoint.exists()) {
                InputStream contents = Thread.currentThread().getContextClassLoader().getResourceAsStream("System.vdb");
                if (contents == null) {
                    throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40021, RuntimeMetadataPlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40021, new Object[0]));
                }
                this.file = VFS.mountZip((InputStream)contents, (String)"System.vdb", (VirtualFile)mountPoint, (TempFileProvider)PROVIDER);
            }
            IndexMetadataStore idxStore = new IndexMetadataStore(mountPoint);
            idxStore.load(null);
            this.vdbRepository.setSystemStore((MetadataStore)idxStore);
        }
        catch (URISyntaxException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40022, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40022, new Object[0]));
        }
        catch (IOException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40023, (Throwable)e, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40023, new Object[0]));
        }
    }

    public void setVDBRepository(VDBRepository repo) {
        this.vdbRepository = repo;
    }

    public void stop() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        try {
            PROVIDER = TempFileProvider.create((String)"teiid-deployment", (ScheduledExecutorService)Executors.newScheduledThreadPool(2));
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to create temp file provider");
        }
    }
}

