/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.core.util.StringUtil;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorProperty;

public class TranslatorUtil {
    public static Map<Method, TranslatorProperty> getTranslatorProperties(Class<?> attachmentClass) {
        HashMap<Method, TranslatorProperty> props = new HashMap<Method, TranslatorProperty>();
        TranslatorUtil.buildTranslatorProperties(attachmentClass, props);
        return props;
    }

    public static Properties getTranslatorPropertiesAsProperties(Class<?> attachmentClass) {
        Properties props = new Properties();
        try {
            Object instance = attachmentClass.newInstance();
            Map<Method, TranslatorProperty> tps = TranslatorUtil.getTranslatorProperties(attachmentClass);
            for (Method m : tps.keySet()) {
                Object defaultValue = TranslatorUtil.getDefaultValue(instance, m, tps.get(m));
                if (defaultValue == null) continue;
                props.setProperty(TranslatorUtil.getPropertyName(m), defaultValue.toString());
            }
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return props;
    }

    private static void buildTranslatorProperties(Class<?> attachmentClass, Map<Method, TranslatorProperty> props) {
        Class<?>[] baseInterfaces;
        Method[] methods;
        for (Method m : methods = attachmentClass.getMethods()) {
            TranslatorProperty tp = m.getAnnotation(TranslatorProperty.class);
            if (tp == null) continue;
            props.put(m, tp);
        }
        for (Class<?> clazz : baseInterfaces = attachmentClass.getInterfaces()) {
            TranslatorUtil.buildTranslatorProperties(clazz, props);
        }
        Class<?> superClass = attachmentClass.getSuperclass();
        if (superClass != null) {
            TranslatorUtil.buildTranslatorProperties(superClass, props);
        }
    }

    public static ExecutionFactory buildExecutionFactory(VDBTranslatorMetaData data, ClassLoader classLoader) throws TeiidException {
        try {
            String executionClass = data.getPropertyValue("execution-factory-class");
            Object o = ReflectionHelper.create((String)executionClass, null, (ClassLoader)classLoader);
            if (!(o instanceof ExecutionFactory)) {
                throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40024, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40024, new Object[]{executionClass}));
            }
            ExecutionFactory executionFactory = (ExecutionFactory)o;
            TranslatorUtil.injectProperties(executionFactory, (org.teiid.adminapi.Translator)data);
            executionFactory.start();
            return executionFactory;
        }
        catch (InvocationTargetException e) {
            throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40025, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40026, (Throwable)e);
        }
    }

    private static void injectProperties(ExecutionFactory ef, org.teiid.adminapi.Translator data) throws InvocationTargetException, IllegalAccessException, TeiidException {
        Map<Method, TranslatorProperty> props = TranslatorUtil.getTranslatorProperties(ef.getClass());
        Properties p = data.getProperties();
        TreeMap<Object, Object> caseInsensitivProps = new TreeMap<Object, Object>(String.CASE_INSENSITIVE_ORDER);
        caseInsensitivProps.putAll(p);
        for (Method method : props.keySet()) {
            TranslatorProperty tp = props.get(method);
            String propertyName = TranslatorUtil.getPropertyName(method);
            String value = (String)caseInsensitivProps.remove(propertyName);
            if (value != null) {
                Method setterMethod = TranslatorUtil.getSetter(ef.getClass(), method);
                setterMethod.invoke((Object)ef, TranslatorUtil.convert(value, method.getReturnType()));
                continue;
            }
            if (!tp.required()) continue;
            throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40027, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40027, new Object[]{tp.display()}));
        }
        caseInsensitivProps.remove("execution-factory-class");
        if (!caseInsensitivProps.isEmpty()) {
            LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40001, new Object[]{caseInsensitivProps.keySet(), data.getName()}));
        }
    }

    public static String getPropertyName(Method method) {
        String result = method.getName();
        if (result.startsWith("get") || result.startsWith("set")) {
            return result.substring(3);
        }
        if (result.startsWith("is")) {
            return result.substring(2);
        }
        return result;
    }

    public static Method getSetter(Class<?> clazz, Method method) throws SecurityException, TeiidException {
        String setter = method.getName();
        setter = method.getName().startsWith("get") ? "set" + setter.substring(3) : (method.getName().startsWith("is") ? "set" + setter.substring(2) : "set" + method.getName().substring(0, 1).toUpperCase() + method.getName().substring(1));
        try {
            return clazz.getMethod(setter, method.getReturnType());
        }
        catch (NoSuchMethodException e) {
            try {
                return clazz.getMethod(method.getName(), method.getReturnType());
            }
            catch (NoSuchMethodException e1) {
                throw new TeiidException((BundleUtil.Event)RuntimePlugin.Event.TEIID40028, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40028, new Object[]{setter, method.getName()}));
            }
        }
    }

    private static Object convert(Object value, Class<?> type) {
        if (value.getClass() == type) {
            return value;
        }
        if (value instanceof String) {
            String str = (String)value;
            return StringUtil.valueOf((String)str, type);
        }
        return value;
    }

    public static String getTranslatorName(ExecutionFactory factory) {
        Translator translator = factory.getClass().getAnnotation(Translator.class);
        if (translator == null) {
            return null;
        }
        return translator.name();
    }

    public static VDBTranslatorMetaData buildTranslatorMetadata(ExecutionFactory factory, String moduleName) {
        Translator translator = factory.getClass().getAnnotation(Translator.class);
        if (translator == null) {
            return null;
        }
        VDBTranslatorMetaData metadata = new VDBTranslatorMetaData();
        metadata.setName(translator.name());
        metadata.setDescription(translator.description());
        metadata.setExecutionFactoryClass(factory.getClass());
        metadata.setModuleName(moduleName);
        Properties props = TranslatorUtil.getTranslatorPropertiesAsProperties(factory.getClass());
        for (String key : props.stringPropertyNames()) {
            metadata.addProperty(key, props.getProperty(key));
        }
        return metadata;
    }

    private static Object convert(Object instance, Method method, TranslatorProperty prop) {
        Class<Object> type = method.getReturnType();
        String[] allowedValues = null;
        Method getter = null;
        boolean readOnly = false;
        if (type == Void.TYPE) {
            Class<?>[] types = method.getParameterTypes();
            if (types.length != 1) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40029, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40029, new Object[]{method}));
            }
            type = types[0];
            try {
                getter = instance.getClass().getMethod("get" + method.getName(), null);
            }
            catch (Exception e) {
                try {
                    getter = instance.getClass().getMethod("get" + method.getName().substring(3), null);
                }
                catch (Exception e1) {}
            }
        } else {
            if (method.getParameterTypes().length != 0) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40030, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40030, new Object[]{method}));
            }
            getter = method;
            try {
                TranslatorUtil.getSetter(instance.getClass(), method);
            }
            catch (Exception e) {
                readOnly = true;
            }
        }
        Object defaultValue = null;
        if (prop.required()) {
            if (prop.advanced()) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40031, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40031, new Object[]{method}));
            }
        } else if (getter != null) {
            try {
                defaultValue = getter.invoke(instance, (Object[])null);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (type.isEnum()) {
            ?[] constants = type.getEnumConstants();
            allowedValues = new String[constants.length];
            for (int i = 0; i < constants.length; ++i) {
                allowedValues[i] = ((Enum)constants[i]).name();
            }
            type = String.class;
            if (defaultValue != null) {
                defaultValue = ((Enum)defaultValue).name();
            }
        }
        if (!(defaultValue instanceof Serializable)) {
            defaultValue = null;
        }
        return defaultValue;
    }

    public static Object getDefaultValue(Object instance, Method method, TranslatorProperty prop) {
        return TranslatorUtil.convert(instance, method, prop);
    }
}

