/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.util.HashMap;
import org.teiid.core.BundleUtil;
import org.teiid.core.ComponentNotFoundException;
import org.teiid.core.util.ReflectionHelper;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.SecurityHelper;
import org.teiid.transport.ClientServiceRegistry;

public class ClientServiceRegistryImpl
implements ClientServiceRegistry {
    private HashMap<String, ClientService> clientServices = new HashMap();
    private SecurityHelper securityHelper;
    private ClientServiceRegistry.Type type = ClientServiceRegistry.Type.JDBC;
    private AuthenticationType authenticationType = AuthenticationType.CLEARTEXT;

    public ClientServiceRegistryImpl() {
    }

    public ClientServiceRegistryImpl(ClientServiceRegistry.Type type) {
        this.type = type;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        this.authenticationType = authenticationType;
    }

    @Override
    public <T> T getClientService(Class<T> iface) throws ComponentNotFoundException {
        ClientService cs = this.getClientService(iface.getName());
        return iface.cast(cs.getInstance());
    }

    public ClientService getClientService(String iface) throws ComponentNotFoundException {
        ClientService cs = this.clientServices.get(iface);
        if (cs == null) {
            throw new ComponentNotFoundException((BundleUtil.Event)RuntimePlugin.Event.TEIID40070, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40070, new Object[]{this.type, iface}));
        }
        return cs;
    }

    public <T> void registerClientService(Class<T> iface, T instance, String loggingContext) {
        this.clientServices.put(iface.getName(), new ClientService(instance, loggingContext, new ReflectionHelper(iface)));
    }

    @Override
    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    @Override
    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public static class ClientService {
        private Object instance;
        private String loggingContext;
        private ReflectionHelper reflectionHelper;

        public ClientService(Object instance, String loggingContext, ReflectionHelper reflectionHelper) {
            this.instance = instance;
            this.loggingContext = loggingContext;
            this.reflectionHelper = reflectionHelper;
        }

        public Object getInstance() {
            return this.instance;
        }

        public String getLoggingContext() {
            return this.loggingContext;
        }

        public ReflectionHelper getReflectionHelper() {
            return this.reflectionHelper;
        }
    }
}

