/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.Arrays;
import junit.framework.Assert;
import org.junit.Test;
import org.teiid.deployers.ExtendedPropertyMetadata;

public class TestExtendedPropertyMetadata {
    @Test
    public void testDefault() {
        ExtendedPropertyMetadata metadata = new ExtendedPropertyMetadata("x", "java.lang.String", "some-name", null);
        Assert.assertEquals((String)"some-name", (String)metadata.display());
        Assert.assertEquals(null, (String)metadata.description());
        Assert.assertEquals((boolean)false, (boolean)metadata.advanced());
        Assert.assertEquals((boolean)false, (boolean)metadata.required());
        Assert.assertEquals((boolean)false, (boolean)metadata.masked());
        Assert.assertEquals((boolean)false, (boolean)metadata.readOnly());
    }

    @Test
    public void testFormatted() {
        ArrayList<String> allowed = new ArrayList<String>();
        allowed.add("get");
        allowed.add("post");
        ExtendedPropertyMetadata metadata = new ExtendedPropertyMetadata("x", "java.lang.String", "{$display:\"Is Immutable\",$description:\"True if the source never changes.\",$allowed:[\"get\",\"post\"], $required:\"true\",$advanced:\"true\"}", null);
        Assert.assertEquals((String)"Is Immutable", (String)metadata.display());
        Assert.assertEquals((String)"True if the source never changes.", (String)metadata.description());
        Assert.assertEquals((boolean)true, (boolean)metadata.advanced());
        Assert.assertEquals((boolean)true, (boolean)metadata.required());
        Assert.assertEquals((boolean)false, (boolean)metadata.masked());
        Assert.assertEquals((boolean)false, (boolean)metadata.readOnly());
        Assert.assertEquals(allowed, Arrays.asList(metadata.allowed()));
    }

    @Test
    public void testFormattedExtraCommasAndColons() {
        ArrayList<String> allowed = new ArrayList<String>();
        allowed.add("get");
        allowed.add("post");
        ExtendedPropertyMetadata metadata = new ExtendedPropertyMetadata("x", "java.lang.String", "{$display:\"Is Immu:table\",$description:\"True if the, source never changes.\",$allowed:[\"get\",\"post\"], $required:\"true\",$advanced:\"true\"}", null);
        Assert.assertEquals((String)"Is Immu:table", (String)metadata.display());
        Assert.assertEquals((String)"True if the, source never changes.", (String)metadata.description());
        Assert.assertEquals((boolean)true, (boolean)metadata.advanced());
        Assert.assertEquals((boolean)true, (boolean)metadata.required());
        Assert.assertEquals((boolean)false, (boolean)metadata.masked());
        Assert.assertEquals((boolean)false, (boolean)metadata.readOnly());
        Assert.assertEquals(allowed, Arrays.asList(metadata.allowed()));
    }

    @Test
    public void testBlankProperties() {
        ArrayList<String> allowed = new ArrayList<String>();
        allowed.add("get");
        allowed.add("post");
        ExtendedPropertyMetadata metadata = new ExtendedPropertyMetadata("x", "java.lang.String", "{$display:\"Is Immutable\",$description:\"\",$allowed:[\"get\",\"post\"], $required:\"true\",$advanced:\"true\"}", null);
        Assert.assertEquals((String)"Is Immutable", (String)metadata.display());
        Assert.assertEquals((String)"", (String)metadata.description());
        Assert.assertEquals((boolean)true, (boolean)metadata.advanced());
        Assert.assertEquals((boolean)true, (boolean)metadata.required());
        Assert.assertEquals((boolean)false, (boolean)metadata.masked());
        Assert.assertEquals((boolean)false, (boolean)metadata.readOnly());
        Assert.assertEquals(allowed, Arrays.asList(metadata.allowed()));
    }
}

