/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeSet;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnStats;
import org.teiid.metadata.DefaultMetadataRepository;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.metadata.TableStats;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.vdb.runtime.VDBKey;

public class CompositeVDB {
    private VDBMetaData vdb;
    private MetadataStore store;
    private LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap;
    private UDFMetaData udf;
    private LinkedHashMap<VDBKey, CompositeVDB> children;
    private MetadataStore[] additionalStores;
    private ConnectorManagerRepository cmr;
    private FunctionTree systemFunctions;
    private boolean metadataloadFinished = false;
    private VDBMetaData mergedVDB;

    public CompositeVDB(VDBMetaData vdb, MetadataStore metadataStore, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, UDFMetaData udf, FunctionTree systemFunctions, ConnectorManagerRepository cmr, MetadataStore ... additionalStores) {
        this.vdb = vdb;
        this.store = metadataStore;
        this.visibilityMap = visibilityMap;
        this.udf = udf;
        this.systemFunctions = systemFunctions;
        this.cmr = cmr;
        this.additionalStores = additionalStores;
        this.mergedVDB = vdb;
    }

    private static TransformationMetadata buildTransformationMetaData(VDBMetaData vdb, LinkedHashMap<String, TransformationMetadata.Resource> visibilityMap, MetadataStore store, UDFMetaData udf, FunctionTree systemFunctions, MetadataStore[] additionalStores) {
        ArrayList<FunctionTree> udfs = new ArrayList<FunctionTree>();
        if (udf != null) {
            for (Map.Entry<String, Collection<FunctionMethod>> entry : udf.getFunctions().entrySet()) {
                udfs.add(new FunctionTree(entry.getKey(), (FunctionMetadataSource)new UDFSource(entry.getValue()), true));
            }
        }
        CompositeMetadataStore compositeStore = new CompositeMetadataStore(store);
        for (MetadataStore s : additionalStores) {
            compositeStore.merge(s);
            for (Schema schema : s.getSchemas().values()) {
                if (schema.getFunctions().isEmpty()) continue;
                udfs.add(new FunctionTree(schema.getName(), (FunctionMetadataSource)new UDFSource(schema.getFunctions().values()), true));
            }
        }
        TransformationMetadata metadata = new TransformationMetadata(vdb, compositeStore, visibilityMap, systemFunctions, udfs);
        return metadata;
    }

    public VDBMetaData getVDB() {
        return this.mergedVDB;
    }

    void buildCompositeState(VDBRepository vdbRepository) throws VirtualDatabaseException {
        if (this.vdb.getVDBImports().isEmpty()) {
            this.vdb.addAttchment(ConnectorManagerRepository.class, (Object)this.cmr);
            return;
        }
        VDBMetaData newMergedVDB = new VDBMetaData();
        newMergedVDB.setName(this.vdb.getName());
        newMergedVDB.setVersion(this.vdb.getVersion());
        newMergedVDB.setModels(this.vdb.getModelMetaDatas().values());
        newMergedVDB.setDataPolicies(this.vdb.getDataPolicies());
        newMergedVDB.setDescription(this.vdb.getDescription());
        newMergedVDB.setStatus(this.vdb.getStatus());
        newMergedVDB.setJAXBProperties(this.vdb.getJAXBProperties());
        newMergedVDB.setConnectionType(this.vdb.getConnectionType());
        ConnectorManagerRepository mergedRepo = new ConnectorManagerRepository();
        mergedRepo.getConnectorManagers().putAll(this.cmr.getConnectorManagers());
        newMergedVDB.addAttchment(ConnectorManagerRepository.class, (Object)mergedRepo);
        this.children = new LinkedHashMap();
        newMergedVDB.setImportedModels(new TreeSet(String.CASE_INSENSITIVE_ORDER));
        for (VDBImportMetadata vdbImport : this.vdb.getVDBImports()) {
            CompositeVDB importedVDB = vdbRepository.getCompositeVDB(vdbImport.getName(), vdbImport.getVersion());
            if (importedVDB == null) {
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40083, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40083, new Object[]{this.vdb.getName(), this.vdb.getVersion(), vdbImport.getName(), vdbImport.getVersion()}));
            }
            VDBMetaData childVDB = importedVDB.getVDB();
            this.children.put(new VDBKey(childVDB.getName(), childVDB.getVersion()), importedVDB);
            if (vdbImport.isImportDataPolicies()) {
                for (DataPolicy dataPolicy : importedVDB.getVDB().getDataPolicies()) {
                    if (this.vdb.addDataPolicy((DataPolicyMetadata)dataPolicy) == null) continue;
                    throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40084, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40084, new Object[]{this.vdb.getName(), this.vdb.getVersion(), vdbImport.getName(), vdbImport.getVersion(), dataPolicy.getName()}));
                }
            }
            for (Model model : importedVDB.getVDB().getModels()) {
                if (newMergedVDB.addModel((ModelMetaData)model) != null) {
                    throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40085, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40085, new Object[]{this.vdb.getName(), this.vdb.getVersion(), vdbImport.getName(), vdbImport.getVersion(), model.getName()}));
                }
                newMergedVDB.getImportedModels().add(model.getName());
            }
            for (Map.Entry entry : importedVDB.cmr.getConnectorManagers().entrySet()) {
                if (mergedRepo.getConnectorManagers().put(entry.getKey(), entry.getValue()) == null) continue;
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40086, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40086, new Object[]{this.vdb.getName(), this.vdb.getVersion(), vdbImport.getName(), vdbImport.getVersion(), entry.getKey()}));
            }
        }
        this.mergedVDB = newMergedVDB;
    }

    private UDFMetaData getUDF() {
        Object funcs;
        UDFMetaData mergedUDF = new UDFMetaData();
        if (this.udf != null) {
            mergedUDF.addFunctions(this.udf);
        }
        for (Schema schema : this.store.getSchemas().values()) {
            funcs = schema.getFunctions().values();
            mergedUDF.addFunctions(schema.getName(), (Collection<FunctionMethod>)funcs);
        }
        if (this.cmr != null) {
            for (ConnectorManager cm : this.cmr.getConnectorManagers().values()) {
                funcs = cm.getPushDownFunctions();
                mergedUDF.addFunctions("SYS", (Collection<FunctionMethod>)funcs);
            }
        }
        if (this.children != null) {
            for (CompositeVDB child : this.children.values()) {
                funcs = child.getUDF();
                if (funcs == null) continue;
                mergedUDF.addFunctions((UDFMetaData)funcs);
            }
        }
        return mergedUDF;
    }

    private LinkedHashMap<String, TransformationMetadata.Resource> getVisibilityMap() {
        if (this.children == null || this.children.isEmpty()) {
            return this.visibilityMap;
        }
        LinkedHashMap<String, TransformationMetadata.Resource> mergedvisibilityMap = new LinkedHashMap<String, TransformationMetadata.Resource>();
        if (this.visibilityMap != null) {
            mergedvisibilityMap.putAll(this.visibilityMap);
        }
        for (CompositeVDB child : this.children.values()) {
            LinkedHashMap<String, TransformationMetadata.Resource> vm = child.getVisibilityMap();
            if (vm == null) continue;
            mergedvisibilityMap.putAll(vm);
        }
        return mergedvisibilityMap;
    }

    private MetadataStore getMetadataStore() {
        if (this.children == null || this.children.isEmpty()) {
            return this.store;
        }
        MetadataStore mergedStore = new MetadataStore();
        if (this.store != null) {
            mergedStore.merge(this.store);
        }
        for (CompositeVDB child : this.children.values()) {
            MetadataStore childStore = child.getMetadataStore();
            if (childStore == null) continue;
            mergedStore.merge(childStore);
        }
        return mergedStore;
    }

    private static void updateFromMetadataRepository(VDBMetaData vdb, Schema schema, DefaultMetadataRepository metadataRepository) {
        String vdbName = vdb.getName();
        int vdbVersion = vdb.getVersion();
        LinkedHashSet<Object> records = new LinkedHashSet<Object>();
        metadataRepository.startLoadVdb(vdbName, vdbVersion);
        records.add(schema);
        for (Table table : schema.getTables().values()) {
            Boolean enabled;
            records.add(table);
            records.addAll(table.getColumns());
            records.addAll(table.getAllKeys());
            if (table.isPhysical()) {
                TableStats stats = metadataRepository.getTableStats(vdbName, vdbVersion, table);
                if (stats != null) {
                    table.setTableStats(stats);
                }
                for (Column c : table.getColumns()) {
                    ColumnStats cStats = metadataRepository.getColumnStats(vdbName, vdbVersion, c);
                    if (cStats == null) continue;
                    c.setColumnStats(cStats);
                }
                continue;
            }
            String def = metadataRepository.getViewDefinition(vdbName, vdbVersion, table);
            if (def != null) {
                table.setSelectTransformation(def);
            }
            if (!table.supportsUpdate()) continue;
            def = metadataRepository.getInsteadOfTriggerDefinition(vdbName, vdbVersion, table, Table.TriggerEvent.INSERT);
            if (def != null) {
                table.setInsertPlan(def);
            }
            if ((enabled = metadataRepository.isInsteadOfTriggerEnabled(vdbName, vdbVersion, table, Table.TriggerEvent.INSERT)) != null) {
                table.setInsertPlanEnabled(enabled.booleanValue());
            }
            if ((def = metadataRepository.getInsteadOfTriggerDefinition(vdbName, vdbVersion, table, Table.TriggerEvent.UPDATE)) != null) {
                table.setUpdatePlan(def);
            }
            if ((enabled = metadataRepository.isInsteadOfTriggerEnabled(vdbName, vdbVersion, table, Table.TriggerEvent.UPDATE)) != null) {
                table.setUpdatePlanEnabled(enabled.booleanValue());
            }
            if ((def = metadataRepository.getInsteadOfTriggerDefinition(vdbName, vdbVersion, table, Table.TriggerEvent.DELETE)) != null) {
                table.setDeletePlan(def);
            }
            if ((enabled = metadataRepository.isInsteadOfTriggerEnabled(vdbName, vdbVersion, table, Table.TriggerEvent.DELETE)) == null) continue;
            table.setDeletePlanEnabled(enabled.booleanValue());
        }
        for (Procedure procedure : schema.getProcedures().values()) {
            String proc;
            records.add(procedure);
            records.addAll(procedure.getParameters());
            if (procedure.getResultSet() != null) {
                records.addAll(procedure.getResultSet().getColumns());
            }
            if (!procedure.isVirtual() || procedure.isFunction() || (proc = metadataRepository.getProcedureDefinition(vdbName, vdbVersion, procedure)) == null) continue;
            procedure.setQueryPlan(proc);
        }
        for (AbstractMetadataRecord abstractMetadataRecord : records) {
            LinkedHashMap p = metadataRepository.getProperties(vdbName, vdbVersion, abstractMetadataRecord);
            if (p == null) continue;
            abstractMetadataRecord.setProperties((Map)p);
        }
        metadataRepository.endLoadVdb(vdbName, vdbVersion);
    }

    public synchronized void metadataLoadFinished() {
        if (this.metadataloadFinished) {
            return;
        }
        this.metadataloadFinished = true;
        MetadataStore mergedStore = this.getMetadataStore();
        for (ModelMetaData model : this.vdb.getModelMetaDatas().values()) {
            MetadataRepository repo = (MetadataRepository)model.getAttachment(MetadataRepository.class);
            if (!(repo instanceof DefaultMetadataRepository)) continue;
            CompositeVDB.updateFromMetadataRepository(this.mergedVDB, mergedStore.getSchema(model.getName()), (DefaultMetadataRepository)repo);
        }
        TransformationMetadata metadata = CompositeVDB.buildTransformationMetaData(this.mergedVDB, this.getVisibilityMap(), mergedStore, this.getUDF(), this.systemFunctions, this.additionalStores);
        this.mergedVDB.addAttchment(QueryMetadataInterface.class, (Object)metadata);
        this.mergedVDB.addAttchment(TransformationMetadata.class, (Object)metadata);
        this.mergedVDB.addAttchment(MetadataStore.class, (Object)mergedStore);
    }
}

