/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.jboss.vfs.VirtualFile;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.metadata.FunctionMetadataReader;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.report.ActivityReport;
import org.teiid.runtime.RuntimePlugin;

public class UDFMetaData {
    private HashMap<String, Collection<FunctionMethod>> methods = new HashMap();
    private HashMap<String, VirtualFile> files = new HashMap();

    public void addModelFile(VirtualFile file) {
        this.files.put(file.getPathName(), file);
    }

    public void buildFunctionModelFile(String name, String path) throws IOException, XMLStreamException {
        VirtualFile file;
        for (String f : this.files.keySet()) {
            if (!f.endsWith(path)) continue;
            path = f;
            break;
        }
        if ((file = this.files.get(path)) == null) {
            throw new IOException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40075, new Object[]{name}));
        }
        List udfMethods = FunctionMetadataReader.loadFunctionMethods((InputStream)file.openStream());
        ActivityReport report = new ActivityReport("UDF load");
        FunctionMetadataValidator.validateFunctionMethods((Collection)udfMethods, (ActivityReport)report);
        if (report.hasItems()) {
            throw new IOException(QueryPlugin.Util.getString("ERR.015.001.0005", new Object[]{report}));
        }
        this.methods.put(name, udfMethods);
    }

    public Map<String, Collection<FunctionMethod>> getFunctions() {
        return this.methods;
    }

    public void addFunctions(String name, Collection<FunctionMethod> funcs) {
        if (funcs.isEmpty()) {
            return;
        }
        Collection<FunctionMethod> old = this.methods.put(name, funcs);
        if (old != null) {
            ArrayList<FunctionMethod> combined = new ArrayList<FunctionMethod>(old);
            combined.addAll(funcs);
            this.methods.put(name, combined);
        }
    }

    public void addFunctions(UDFMetaData funcs) {
        for (Map.Entry<String, Collection<FunctionMethod>> entry : funcs.getFunctions().entrySet()) {
            this.addFunctions(entry.getKey(), entry.getValue());
        }
    }

    public void setFunctionClassLoader(ClassLoader functionClassLoader) {
        for (String name : this.methods.keySet()) {
            Collection<FunctionMethod> funcs = this.methods.get(name);
            for (FunctionMethod fm : funcs) {
                fm.setClassloader(functionClassLoader);
            }
        }
    }
}

