/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.services;

import java.util.List;
import javax.security.auth.login.LoginException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.internal.progress.VerificationMode;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.security.Credentials;
import org.teiid.services.SessionServiceImpl;
import org.teiid.services.TeiidLoginContext;

public class TestSessionServiceImpl {
    SessionServiceImpl ssi;

    @Before
    public void setup() {
        this.ssi = new SessionServiceImpl(){

            protected TeiidLoginContext authenticate(String userName, Credentials credentials, String applicationName, List<String> domains) throws LoginException {
                return null;
            }
        };
    }

    @Test
    public void testActiveVDBWithNoVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name")).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.getActiveVDB("name", null);
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getVDB("name");
    }

    @Test
    public void testActiveVDBWithVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name", 1)).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.getActiveVDB("name", "1");
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getVDB("name", 1);
    }

    @Test
    public void testActiveVDBNameWithVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name", 1)).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        this.ssi.getActiveVDB("name.1", null);
        ((VDBRepository)Mockito.verify((Object)repo, (VerificationMode)Mockito.times((int)1))).getVDB("name", 1);
    }

    @Test
    public void testActiveVDBNameWithVersionNonInteger() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name", 1)).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        try {
            this.ssi.getActiveVDB("name.x", null);
            Assert.fail((String)"must have failed with non integer version");
        }
        catch (SessionServiceException sessionServiceException) {
            // empty catch block
        }
    }

    @Test
    public void testActiveVDBNameWithVersionAndVersion() throws Exception {
        VDBRepository repo = (VDBRepository)Mockito.mock(VDBRepository.class);
        VDBMetaData vdb = new VDBMetaData();
        vdb.setName("name");
        vdb.setVersion(1);
        vdb.setStatus(VDB.Status.ACTIVE);
        Mockito.stub((Object)repo.getVDB("name", 1)).toReturn((Object)vdb);
        this.ssi.setVDBRepository(repo);
        try {
            this.ssi.getActiveVDB("name.1", "1");
            Assert.fail((String)"must have failed with ambigious version info");
        }
        catch (SessionServiceException e) {
            // empty catch block
        }
        try {
            this.ssi.getActiveVDB("name..1", null);
            Assert.fail((String)"must have failed with ambigious version info");
        }
        catch (SessionServiceException sessionServiceException) {
            // empty catch block
        }
    }

    public void testBaseUsername() throws Exception {
        Assert.assertEquals((Object)"foo@bar.com", (Object)SessionServiceImpl.getBaseUsername((String)"foo\\@bar.com@foo"));
        Assert.assertEquals((Object)"foo", (Object)SessionServiceImpl.getDomainName((String)"me\\@bar.com@foo"));
        Assert.assertEquals(null, (Object)SessionServiceImpl.getDomainName((String)"@"));
        Assert.assertEquals((Object)"@", (Object)SessionServiceImpl.getBaseUsername((String)"@"));
    }
}

