/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.logging.LogManager;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.metadata.DDLMetadataRepository;
import org.teiid.query.metadata.NativeMetadataRepository;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.TranslatorException;

public abstract class AbstractVDBDeployer {
    private Map<String, MetadataRepository<?, ?>> repositories = new ConcurrentSkipListMap(String.CASE_INSENSITIVE_ORDER);

    public AbstractVDBDeployer() {
        this.repositories.put("ddl", (MetadataRepository<?, ?>)new DDLMetadataRepository());
        this.repositories.put("native", (MetadataRepository<?, ?>)new NativeMetadataRepository());
    }

    public void addMetadataRepository(String name, MetadataRepository<?, ?> metadataRepository) {
        this.repositories.put(name, metadataRepository);
    }

    protected void assignMetadataRepositories(VDBMetaData deployment, MetadataRepository<?, ?> defaultRepo) throws VirtualDatabaseException {
        for (ModelMetaData model : deployment.getModelMetaDatas().values()) {
            if (model.isSource() && model.getSourceNames().isEmpty()) {
                throw new VirtualDatabaseException(RuntimePlugin.Event.TEIID40093, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40093, new Object[]{model.getName(), deployment.getName(), deployment.getVersion()}));
            }
            if (model.getModelType() == Model.Type.FUNCTION || model.getModelType() == Model.Type.OTHER) continue;
            MetadataRepository<?, ?> repo = this.getMetadataRepository(deployment, model, defaultRepo);
            model.addAttchment(MetadataRepository.class, repo);
        }
    }

    private MetadataRepository<?, ?> getMetadataRepository(VDBMetaData vdb, ModelMetaData model, MetadataRepository<?, ?> defaultRepo) throws VirtualDatabaseException {
        if (model.getSchemaSourceType() == null) {
            if (!vdb.isDynamic()) {
                return defaultRepo;
            }
            if (model.isSource()) {
                return new NativeMetadataRepository();
            }
            throw new VirtualDatabaseException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40094, new Object[]{model.getName(), vdb.getName(), vdb.getVersion(), null}));
        }
        MetadataRepository<?, ?> first = null;
        MetadataRepository<?, ?> current = null;
        MetadataRepository<?, ?> previous = null;
        StringTokenizer st = new StringTokenizer(model.getSchemaSourceType(), ",");
        while (st.hasMoreTokens()) {
            String repoType = st.nextToken().trim();
            current = this.getMetadataRepository(repoType);
            if (current == null) {
                throw new VirtualDatabaseException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40094, new Object[]{model.getName(), vdb.getName(), vdb.getVersion(), repoType}));
            }
            if (first == null) {
                first = current;
            }
            if (previous != null) {
                previous.setNext(current);
            }
            previous = current;
            current = null;
        }
        return first;
    }

    protected ConnectorManager getConnectorManager(ModelMetaData model, ConnectorManagerRepository cmr) {
        List mappings;
        Iterator i$;
        if (model.isSource() && (i$ = (mappings = model.getSourceMappings()).iterator()).hasNext()) {
            SourceMappingMetadata mapping = (SourceMappingMetadata)i$.next();
            return cmr.getConnectorManager(mapping.getName());
        }
        return null;
    }

    protected void loadMetadata(VDBMetaData vdb, ConnectorManagerRepository cmr, MetadataStore store) throws TranslatorException {
        AtomicInteger loadCount = new AtomicInteger();
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            if (model.getModelType() != Model.Type.PHYSICAL && model.getModelType() != Model.Type.VIRTUAL) continue;
            loadCount.incrementAndGet();
        }
        for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
            MetadataRepository metadataRepository = (MetadataRepository)model.getAttachment(MetadataRepository.class);
            if (model.getModelType() == Model.Type.PHYSICAL || model.getModelType() == Model.Type.VIRTUAL) {
                this.loadMetadata(vdb, model, cmr, metadataRepository, store, loadCount);
                LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", vdb.getName(), " was being loaded from its repository"});
                continue;
            }
            LogManager.logTrace((String)"org.teiid.RUNTIME", (Object[])new Object[]{"Model ", model.getName(), "in VDB ", vdb.getName(), " skipped being loaded because of its type ", model.getModelType()});
            if (loadCount.decrementAndGet() != 0) continue;
            this.getVDBRepository().finishDeployment(vdb.getName(), vdb.getVersion());
        }
    }

    protected abstract VDBRepository getVDBRepository();

    protected abstract void loadMetadata(VDBMetaData var1, ModelMetaData var2, ConnectorManagerRepository var3, MetadataRepository var4, MetadataStore var5, AtomicInteger var6) throws TranslatorException;

    protected void metadataLoaded(VDBMetaData vdb, ModelMetaData model, MetadataStore vdbMetadataStore, AtomicInteger loadCount, MetadataFactory factory) {
        factory.mergeInto(vdbMetadataStore);
        model.clearRuntimeErrors();
        if (loadCount.decrementAndGet() == 0) {
            this.getVDBRepository().finishDeployment(vdb.getName(), vdb.getVersion());
        }
    }

    protected MetadataRepository<?, ?> getMetadataRepository(String repoType) throws VirtualDatabaseException {
        return this.repositories.get(repoType);
    }
}

