/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.teiid.Replicated;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.client.DQP;
import org.teiid.client.security.ILogon;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBufferCache;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.UDFMetaData;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.SessionAwareCache;
import org.teiid.dqp.internal.process.TransactionServerImpl;
import org.teiid.dqp.service.BufferService;
import org.teiid.dqp.service.TransactionContext;
import org.teiid.dqp.service.TransactionService;
import org.teiid.events.EventDistributor;
import org.teiid.events.EventDistributorFactory;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ConnectionProfile;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.ServerConnection;
import org.teiid.query.ObjectReplicator;
import org.teiid.query.function.SystemFunctionManager;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.query.validator.ValidatorFailure;
import org.teiid.query.validator.ValidatorReport;
import org.teiid.runtime.AbstractVDBDeployer;
import org.teiid.runtime.DoNothingSecurityHelper;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.ReplicatedCacheImpl;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.services.AbstractEventDistributorFactoryService;
import org.teiid.services.BufferServiceImpl;
import org.teiid.services.SessionServiceImpl;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.LogonImpl;
import org.teiid.vdb.runtime.VDBKey;

public class EmbeddedServer
extends AbstractVDBDeployer
implements EventDistributorFactory,
ConnectorManagerRepository.ExecutionFactoryProvider {
    protected DQPCore dqp = new DQPCore();
    protected VDBRepository repo = new VDBRepository(){

        @Override
        protected void processMetadataValidatorReport(VDBKey key, ValidatorReport report) {
            if (EmbeddedServer.this.throwMetadataErrors) {
                super.processMetadataValidatorReport(key, report);
                ValidatorFailure firstFailure = (ValidatorFailure)report.getItems().iterator().next();
                throw new VDBValidationError(RuntimePlugin.Event.TEIID40095, firstFailure.getMessage());
            }
        }
    };
    protected boolean throwMetadataErrors = true;
    private ConcurrentHashMap<String, ExecutionFactory<?, ?>> translators = new ConcurrentHashMap();
    private ConcurrentHashMap<String, ConnectionFactoryProvider<?>> connectionFactoryProviders = new ConcurrentHashMap();
    protected SessionServiceImpl sessionService = new SessionServiceImpl();
    protected ObjectReplicator replicator;
    protected BufferServiceImpl bufferService = new BufferServiceImpl();
    protected TransactionDetectingTransactionServer transactionService = new TransactionDetectingTransactionServer();
    protected boolean waitForLoad;
    protected ClientServiceRegistryImpl services = new ClientServiceRegistryImpl(){

        @Override
        public void waitForFinished(String vdbName, int vdbVersion, int timeOutMillis) throws ConnectionException {
            if (EmbeddedServer.this.waitForLoad) {
                EmbeddedServer.this.repo.waitForFinished(vdbName, vdbVersion, timeOutMillis);
            }
        }

        @Override
        public ClassLoader getCallerClassloader() {
            return this.getClass().getClassLoader();
        }
    };
    protected LogonImpl logon;
    private TeiidDriver driver = new TeiidDriver();
    protected ConnectorManagerRepository cmr = new ProviderAwareConnectorManagerRepository();
    protected DefaultCacheFactory dcf = new DefaultCacheFactory(){
        List<ReplicatedCache<?, ?>> caches = new ArrayList();

        public boolean isReplicated() {
            return true;
        }

        public <K, V> Cache<K, V> get(String location, CacheConfiguration config) {
            Cache result = super.get(location, config);
            if (EmbeddedServer.this.replicator != null) {
                try {
                    ReplicatedCache cache = (ReplicatedCache)EmbeddedServer.this.replicator.replicate("$RS$", ReplicatedCache.class, new ReplicatedCacheImpl(result), 0L);
                    this.caches.add(cache);
                    return cache;
                }
                catch (Exception e) {
                    throw new TeiidRuntimeException((Throwable)e);
                }
            }
            return result;
        }

        public void destroy() {
            if (EmbeddedServer.this.replicator != null) {
                for (ReplicatedCache<?, ?> cache : this.caches) {
                    EmbeddedServer.this.replicator.stop(cache);
                }
                this.caches.clear();
            }
            super.destroy();
        }
    };
    protected AbstractEventDistributorFactoryService eventDistributorFactoryService = new AbstractEventDistributorFactoryService(){

        @Override
        protected VDBRepository getVdbRepository() {
            return EmbeddedServer.this.repo;
        }

        @Override
        protected ObjectReplicator getObjectReplicator() {
            return EmbeddedServer.this.replicator;
        }
    };
    protected boolean useCallingThread = true;
    protected boolean detectTransactions = true;
    private Boolean running;

    public void addConnectionFactoryProvider(String name, ConnectionFactoryProvider<?> connectionFactoryProvider) {
        this.connectionFactoryProviders.put(name, connectionFactoryProvider);
    }

    public synchronized void start(EmbeddedConfiguration dqpConfiguration) {
        if (this.running != null) {
            throw new IllegalStateException();
        }
        this.eventDistributorFactoryService.start();
        this.dqp.setEventDistributor(this.eventDistributorFactoryService.getReplicatedEventDistributor());
        this.replicator = dqpConfiguration.getObjectReplicator();
        if (dqpConfiguration.getTransactionManager() == null) {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40089, new Object[0]));
            this.transactionService.setTransactionManager((TransactionManager)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{TransactionManager.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    throw new UnsupportedOperationException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40089, new Object[0]));
                }
            }));
            this.detectTransactions = false;
        } else {
            this.transactionService.setTransactionManager(dqpConfiguration.getTransactionManager());
        }
        if (dqpConfiguration.getSecurityHelper() != null) {
            this.sessionService.setSecurityHelper(dqpConfiguration.getSecurityHelper());
        } else {
            this.sessionService.setSecurityHelper(new DoNothingSecurityHelper());
        }
        if (dqpConfiguration.getSecurityDomains() != null) {
            this.sessionService.setSecurityDomains(dqpConfiguration.getSecurityDomains());
        } else {
            this.sessionService.setSecurityDomains(Arrays.asList("teiid-security"));
        }
        this.sessionService.setVDBRepository(this.repo);
        this.bufferService.setUseDisk(dqpConfiguration.isUseDisk());
        if (dqpConfiguration.isUseDisk()) {
            if (dqpConfiguration.getBufferDirectory() == null) {
                dqpConfiguration.setBufferDirectory(System.getProperty("java.io.tmpdir"));
            }
            this.bufferService.setDiskDirectory(dqpConfiguration.getBufferDirectory());
        }
        BufferService bs = this.getBufferService();
        this.dqp.setBufferManager(bs.getBufferManager());
        this.startVDBRepository();
        SessionAwareCache rs = new SessionAwareCache((CacheFactory)this.dcf, SessionAwareCache.Type.RESULTSET, new CacheConfiguration(CacheConfiguration.Policy.LRU, 60, 250, "resultsetcache"));
        SessionAwareCache ppc = new SessionAwareCache((CacheFactory)this.dcf, SessionAwareCache.Type.PREPAREDPLAN, new CacheConfiguration());
        rs.setTupleBufferCache(bs.getTupleBufferCache());
        this.dqp.setResultsetCache(rs);
        ppc.setTupleBufferCache(bs.getTupleBufferCache());
        this.dqp.setPreparedPlanCache(ppc);
        this.dqp.setTransactionService((TransactionService)this.transactionService);
        this.dqp.start((DQPConfiguration)dqpConfiguration);
        this.sessionService.setDqp(this.dqp);
        this.services.setSecurityHelper(this.sessionService.getSecurityHelper());
        this.logon = new LogonImpl(this.sessionService, null);
        this.services.registerClientService(ILogon.class, this.logon, null);
        this.services.registerClientService(DQP.class, this.dqp, null);
        this.initDriver();
        this.running = true;
    }

    private void initDriver() {
        this.driver.setEmbeddedProfile(new ConnectionProfile(){

            public ConnectionImpl connect(String url, Properties info) throws TeiidSQLException {
                LocalServerConnection conn;
                try {
                    conn = new LocalServerConnection(info, EmbeddedServer.this.useCallingThread){

                        @Override
                        protected ClientServiceRegistry getClientServiceRegistry() {
                            return EmbeddedServer.this.services;
                        }
                    };
                }
                catch (CommunicationException e) {
                    throw TeiidSQLException.create((Throwable)e);
                }
                catch (ConnectionException e) {
                    throw TeiidSQLException.create((Throwable)e);
                }
                return new ConnectionImpl((ServerConnection)conn, info, url);
            }
        });
    }

    private void startVDBRepository() {
        this.repo.addListener(new VDBLifeCycleListener(){

            @Override
            public void added(String name, int version, CompositeVDB vdb) {
            }

            @Override
            public void removed(String name, int version, CompositeVDB vdb) {
                if (EmbeddedServer.this.replicator != null) {
                    EmbeddedServer.this.replicator.stop(vdb.getVDB().getAttachment(GlobalTableStore.class));
                }
            }

            @Override
            public void finishedDeployment(String name, int version, CompositeVDB vdb) {
                GlobalTableStoreImpl gts = new GlobalTableStoreImpl(EmbeddedServer.this.dqp.getBufferManager(), (QueryMetadataInterface)vdb.getVDB().getAttachment(TransformationMetadata.class));
                if (EmbeddedServer.this.replicator != null) {
                    try {
                        gts = (GlobalTableStore)EmbeddedServer.this.replicator.replicate(name + version, GlobalTableStore.class, (Object)gts, 300000L);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                vdb.getVDB().addAttchment(GlobalTableStore.class, (Object)gts);
            }
        });
        this.repo.setSystemFunctionManager(new SystemFunctionManager());
        this.repo.start();
    }

    protected BufferService getBufferService() {
        this.bufferService.start();
        if (this.replicator != null) {
            try {
                final TupleBufferCache tbc = (TupleBufferCache)this.replicator.replicate("$BM$", TupleBufferCache.class, (Object)this.bufferService.getBufferManager(), 0L);
                return new BufferService(){

                    public BufferManager getBufferManager() {
                        return EmbeddedServer.this.bufferService.getBufferManager();
                    }

                    public TupleBufferCache getTupleBufferCache() {
                        return tbc;
                    }
                };
            }
            catch (Exception e) {
                throw new TeiidRuntimeException((Throwable)e);
            }
        }
        return this.bufferService;
    }

    public void addTranslator(ExecutionFactory<?, ?> ef) {
        Translator t = ef.getClass().getAnnotation(Translator.class);
        String name = ef.getClass().getName();
        if (t != null) {
            name = t.name();
        }
        this.addTranslator(name, ef);
    }

    void addTranslator(String name, ExecutionFactory<?, ?> ef) {
        this.translators.put(name, ef);
    }

    public void deployVDB(String name, ModelMetaData ... models) throws ConnectorManagerRepository.ConnectorManagerException, VirtualDatabaseException, TranslatorException {
        this.checkStarted();
        VDBMetaData vdb = new VDBMetaData();
        vdb.setDynamic(true);
        vdb.setName(name);
        vdb.setModels(Arrays.asList(models));
        this.cmr.createConnectorManagers(vdb, (ConnectorManagerRepository.ExecutionFactoryProvider)this);
        MetadataStore metadataStore = new MetadataStore();
        UDFMetaData udfMetaData = new UDFMetaData();
        udfMetaData.setFunctionClassLoader(Thread.currentThread().getContextClassLoader());
        this.assignMetadataRepositories(vdb, null);
        this.repo.addVDB(vdb, metadataStore, new LinkedHashMap<String, TransformationMetadata.Resource>(), udfMetaData, this.cmr);
        try {
            this.loadMetadata(vdb, this.cmr, metadataStore);
        }
        catch (VDBValidationError e) {
            throw new VirtualDatabaseException(RuntimePlugin.Event.valueOf(e.getCode()), e.getMessage());
        }
    }

    @Override
    protected void loadMetadata(VDBMetaData vdb, ModelMetaData model, ConnectorManagerRepository cmr, MetadataRepository metadataRepository, MetadataStore store, AtomicInteger loadCount) throws TranslatorException {
        Map<String, Datatype> datatypes = this.repo.getBuiltinDatatypes();
        MetadataFactory factory = new MetadataFactory(vdb.getName(), vdb.getVersion(), model.getName(), datatypes, model.getProperties(), model.getSchemaText());
        factory.getSchema().setPhysical(model.isSource());
        ExecutionFactory ef = null;
        Object cf = null;
        try {
            ConnectorManager cm = this.getConnectorManager(model, cmr);
            if (cm != null) {
                ef = cm.getExecutionFactory();
                cf = cm.getConnectionFactory();
            }
        }
        catch (TranslatorException e) {
            // empty catch block
        }
        metadataRepository.loadMetadata(factory, ef, cf);
        this.metadataLoaded(vdb, model, store, loadCount, factory, true);
    }

    public void undeployVDB(String vdbName) {
        this.repo.removeVDB(vdbName, 1);
    }

    public synchronized void stop() {
        this.dqp.stop();
        this.eventDistributorFactoryService.stop();
        this.bufferService = null;
        this.dqp = null;
        this.running = false;
    }

    private synchronized void checkStarted() {
        if (this.running == null || !this.running.booleanValue()) {
            throw new IllegalStateException();
        }
    }

    public TeiidDriver getDriver() {
        this.checkStarted();
        return this.driver;
    }

    public EventDistributor getEventDistributor() {
        return this.eventDistributorFactoryService.getEventDistributor();
    }

    public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
        ExecutionFactory<?, ?> ef = this.translators.get(name);
        if (ef == null) {
            throw new ConnectorManagerRepository.ConnectorManagerException(name);
        }
        return ef;
    }

    @Override
    protected VDBRepository getVDBRepository() {
        return this.repo;
    }

    private static class VDBValidationError
    extends TeiidRuntimeException {
        private VDBValidationError(BundleUtil.Event event, String message) {
            super(event, message);
        }
    }

    public static interface ReplicatedCache<K, V>
    extends Cache<K, V> {
        @Replicated(replicateState=Replicated.ReplicationMode.PULL)
        public V get(K var1);

        @Replicated(replicateState=Replicated.ReplicationMode.PUSH)
        public V put(K var1, V var2, Long var3);

        @Replicated
        public V remove(K var1);
    }

    public static interface ConnectionFactoryProvider<T> {
        public T getConnectionFactory() throws TranslatorException;
    }

    protected class ProviderAwareConnectorManagerRepository
    extends ConnectorManagerRepository {
        protected ProviderAwareConnectorManagerRepository() {
        }

        protected ConnectorManager createConnectorManager(String translatorName, String connectionName) {
            return new ConnectorManager(translatorName, connectionName){

                public Object getConnectionFactory() throws TranslatorException {
                    ConnectionFactoryProvider connectionFactoryProvider = (ConnectionFactoryProvider)EmbeddedServer.this.connectionFactoryProviders.get(this.getConnectionName());
                    if (connectionFactoryProvider != null) {
                        return connectionFactoryProvider.getConnectionFactory();
                    }
                    return super.getConnectionFactory();
                }
            };
        }
    }

    protected final class TransactionDetectingTransactionServer
    extends TransactionServerImpl {
        protected TransactionDetectingTransactionServer() {
        }

        public TransactionContext getOrCreateTransactionContext(final String threadId) {
            TransactionContext tc = super.getOrCreateTransactionContext(threadId);
            if (EmbeddedServer.this.useCallingThread && EmbeddedServer.this.detectTransactions && tc.getTransaction() == null) {
                try {
                    Transaction tx = this.transactionManager.getTransaction();
                    if (tx != null) {
                        tx.registerSynchronization(new Synchronization(){

                            public void beforeCompletion() {
                            }

                            public void afterCompletion(int status) {
                                TransactionDetectingTransactionServer.this.transactions.removeTransactionContext(threadId);
                            }
                        });
                        tc.setTransaction(tx);
                        tc.setTransactionType(TransactionContext.Scope.LOCAL);
                    }
                }
                catch (SystemException e) {
                }
                catch (IllegalStateException e) {
                }
                catch (RollbackException rollbackException) {
                    // empty catch block
                }
            }
            return tc;
        }
    }
}

