/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.ExtendedPropertyMetadata;
import org.teiid.deployers.ExtendedPropertyMetadataList;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.logging.LogManager;
import org.teiid.logging.Logger;
import org.teiid.metadata.Column;
import org.teiid.metadata.ExtensionMetadataProperty;
import org.teiid.metadata.MetadataFactory;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.MetadataProcessor;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;

public class TestTranslatorUtil {
    @Test
    public void testInitialSetValueExecutionFactory() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.setExecutionFactoryClass(MyTranslator2.class);
        MyTranslator2 my = (MyTranslator2)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"original-assigned", (Object)my.getSomeProperty());
    }

    @Test
    public void testBuildExecutionFactory() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("MyProperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator.class);
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
        Assert.assertNull((Object)my.other());
        tm.addProperty("other", "foo");
        tm.setExecutionFactoryClass(MyTranslator.class);
        my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"foo", (Object)my.other());
    }

    @Test
    public void testImportProperties() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.setExecutionFactoryClass(MyTranslator.class);
        tm.addProperty("MyProperty", "correctly-assigned");
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        VDBTranslatorMetaData translator = TranslatorUtil.buildTranslatorMetadata((ExecutionFactory)my, (String)"my-module");
        ExtendedPropertyMetadataList props = (ExtendedPropertyMetadataList)translator.getAttachment(ExtendedPropertyMetadataList.class);
        ArrayList<ExtendedPropertyMetadata> importProperties = new ArrayList<ExtendedPropertyMetadata>();
        for (ExtendedPropertyMetadata prop : props) {
            if (!prop.category().equals(TranslatorProperty.PropertyType.IMPORT.name())) continue;
            importProperties.add(prop);
        }
        Assert.assertEquals((long)1L, (long)importProperties.size());
        Assert.assertEquals((Object)"importer.ImportProperty", (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).name);
        Assert.assertEquals((Object)"java.lang.String", (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).dataType);
        Assert.assertEquals((Object)false, (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).required);
        Assert.assertEquals((Object)false, (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).advanced);
        Assert.assertEquals((Object)"", (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).description);
        Assert.assertEquals((Object)"Import Property", (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).displayName);
        Assert.assertEquals((Object)true, (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).editable);
        Assert.assertEquals((Object)false, (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).masked);
        Assert.assertEquals((Object)"default-import-property", (Object)((ExtendedPropertyMetadata)importProperties.get((int)0)).defaultValue);
    }

    @Test
    public void testInject() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.setExecutionFactoryClass(MyTranslator.class);
        tm.addProperty("MyProperty", "correctly-assigned");
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
        VDBTranslatorMetaData metadata = TranslatorUtil.buildTranslatorMetadata((ExecutionFactory)my, (String)"my-module");
        metadata.addProperty("MyProperty", "correctly-assigned");
        Logger logger = (Logger)Mockito.mock(Logger.class);
        Mockito.stub((Object)logger.isEnabled(Mockito.anyString(), Mockito.anyInt())).toReturn((Object)true);
        ((Logger)Mockito.doThrow((Throwable)new RuntimeException("fail")).when((Object)logger)).log(Mockito.eq((int)3), (String)Mockito.eq((Object)"org.teiid.RUNTIME"), new Object[]{Mockito.anyString()});
        LogManager.setLogListener((Logger)logger);
        TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)metadata);
    }

    @Test
    public void testExtensionMetadataProperties() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.setExecutionFactoryClass(MyTranslator.class);
        tm.addProperty("MyProperty", "correctly-assigned");
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        VDBTranslatorMetaData translator = TranslatorUtil.buildTranslatorMetadata((ExecutionFactory)my, (String)"my-module");
        ExtendedPropertyMetadataList props = (ExtendedPropertyMetadataList)translator.getAttachment(ExtendedPropertyMetadataList.class);
        ArrayList<ExtendedPropertyMetadata> importProperties = new ArrayList<ExtendedPropertyMetadata>();
        for (ExtendedPropertyMetadata prop : props) {
            if (!prop.category().equals(TranslatorProperty.PropertyType.EXTENSION_METADATA.name())) continue;
            importProperties.add(prop);
        }
        Assert.assertEquals((Object)"{http://teiid.org}/my-extension-property", (Object)((ExtendedPropertyMetadata)importProperties.get(0)).name());
        Assert.assertEquals((Object)"java.lang.String", (Object)((ExtendedPropertyMetadata)importProperties.get(0)).datatype());
        Assert.assertEquals((Object)"org.teiid.metadata.Column", (Object)((ExtendedPropertyMetadata)importProperties.get(0)).owner());
    }

    @Test
    public void testBuildExecutionFactoryWithDefaults() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        VDBTranslatorMetaData parent = new VDBTranslatorMetaData();
        parent.addProperty("myProperty", "default");
        parent.setExecutionFactoryClass(MyTranslator.class);
        tm.setParent(parent);
        tm.addProperty("MyProperty", "correctly-assigned");
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
    }

    @Test
    public void testBuildExecutionFactoryCaseInsensitive() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("myproperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator.class);
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
    }

    @Test
    public void testBuildExecutionFactory1() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("someproperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator1.class);
        MyTranslator1 my = (MyTranslator1)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertNull((Object)my.getMyProperty());
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getSomeProperty());
    }

    @Translator(name="my-translator2")
    public static class MyTranslator2
    extends MyTranslator1 {
        public MyTranslator2() {
            this.setSomeProperty("original-assigned");
        }
    }

    @Translator(name="my-translator1")
    public static class MyTranslator1
    extends MyTranslator
    implements SomeProperty {
        private String someProperty;

        @Override
        @TranslatorProperty(display="my-property", required=false)
        public String getMyProperty() {
            return super.getMyProperty();
        }

        @Override
        public String getSomeProperty() {
            return this.someProperty;
        }

        @Override
        public void setSomeProperty(String value) {
            this.someProperty = value;
        }
    }

    public static interface SomeProperty {
        @TranslatorProperty(display="my-property", required=false)
        public String getSomeProperty();

        public void setSomeProperty(String var1);
    }

    @Translator(name="my-translator")
    public static class MyTranslator
    extends ExecutionFactory<Object, Object> {
        @ExtensionMetadataProperty(applicable={Column.class}, datatype=String.class, description="description", required=true)
        public static final String EXTENSION_PROP = "{http://teiid.org}/my-extension-property";
        String mine;
        String other;

        @TranslatorProperty(display="my-property", required=true)
        public String getMyProperty() {
            return this.mine;
        }

        public void setMyProperty(String value) {
            this.mine = value;
        }

        @TranslatorProperty(display="other")
        public String other() {
            return this.other;
        }

        public void setOther(String other) {
            this.other = other;
        }

        public MetadataProcessor<Object> getMetadataProcessor() {
            return new MetadataProcessor<Object>(){

                public void process(MetadataFactory metadataFactory, Object connection) throws TranslatorException {
                }

                @TranslatorProperty(display="Import Property", category=TranslatorProperty.PropertyType.IMPORT)
                public String getImportProperty() {
                    return "default-import-property";
                }
            };
        }
    }
}

