/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.language.Command;
import org.teiid.language.QueryExpression;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;

public class TestEmbeddedServer {
    EmbeddedServer es;

    @Before
    public void setup() {
        this.es = new EmbeddedServer();
    }

    @After
    public void teardown() {
        this.es.stop();
    }

    @Test
    public void testDeploy() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("y", (ExecutionFactory)new ExecutionFactory<AtomicInteger, Object>(){

            public Object getConnection(AtomicInteger factory) throws TranslatorException {
                return factory.incrementAndGet();
            }

            public void closeConnection(Object connection, AtomicInteger factory) {
            }

            public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
                Assert.assertEquals((Object)conn, (Object)1);
                Table t = metadataFactory.addTable("my-table");
                t.setSupportsUpdate(true);
                Column c = metadataFactory.addColumn("my-column", "string", (ColumnSet)t);
                c.setUpdatable(true);
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                ResultSetExecution rse = new ResultSetExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        return null;
                    }
                };
                return rse;
            }

            public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                UpdateExecution ue = new UpdateExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                        return new int[]{2};
                    }
                };
                return ue;
            }
        });
        final AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.ConnectionFactoryProvider<AtomicInteger> cfp = new EmbeddedServer.ConnectionFactoryProvider<AtomicInteger>(){

            public AtomicInteger getConnectionFactory() throws TranslatorException {
                return counter;
            }
        };
        this.es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMapping("x", "y", "z");
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" OPTIONS (UPDATABLE 'true') as select * from \"my-table\"");
        this.es.deployVDB("test", new ModelMetaData[]{mmd, mmd1});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from \"my-view\"");
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"my-column", (Object)rs.getMetaData().getColumnLabel(1));
        s.execute("update \"my-view\" set \"my-column\" = 'a'");
        Assert.assertEquals((long)2L, (long)s.getUpdateCount());
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testDeploymentError() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" OPTIONS (UPDATABLE 'true') as select * from \"my-table\"");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1});
    }

    @Test
    public void testValidationOrder() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v as select 1");
        ModelMetaData mmd2 = new ModelMetaData();
        mmd2.setName("a");
        mmd2.setModelType(Model.Type.VIRTUAL);
        mmd2.setSchemaSourceType("ddl");
        mmd2.setSchemaText("create view v1 as select * from v");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1, mmd2});
        try {
            this.es.deployVDB("test2", new ModelMetaData[]{mmd2, mmd1});
            Assert.fail();
        }
        catch (VirtualDatabaseException e) {
            // empty catch block
        }
    }

    @Test
    public void testTransactions() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v as select 1; create virtual procedure proc () options (updatecount 2) as begin select * from v; end; create virtual procedure proc1 () as begin atomic select * from v; end; ");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        s.execute("select 1");
        c.setAutoCommit(true);
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        Transaction txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("call proc ()");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("call proc1()");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
    }

    private final class MockTransactionManager
    implements TransactionManager {
        ThreadLocal<Transaction> txns = new ThreadLocal();
        List<Transaction> txnHistory = new ArrayList<Transaction>();

        private MockTransactionManager() {
        }

        public Transaction suspend() throws SystemException {
            Transaction result = this.txns.get();
            this.txns.remove();
            return result;
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            Transaction result = this.txns.get();
            if (result == null) {
                throw new IllegalStateException();
            }
            result.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            Transaction t = this.checkNull(false);
            this.txns.remove();
            t.rollback();
        }

        public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
            this.checkNull(true);
            this.txns.set(tobj);
        }

        private Transaction checkNull(boolean isNull) {
            Transaction t = this.txns.get();
            if (!isNull && t == null || isNull && t != null) {
                throw new IllegalStateException();
            }
            return t;
        }

        public Transaction getTransaction() throws SystemException {
            return this.txns.get();
        }

        public int getStatus() throws SystemException {
            Transaction t = this.txns.get();
            if (t == null) {
                return 6;
            }
            return t.getStatus();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            Transaction t = this.checkNull(false);
            this.txns.remove();
            t.commit();
        }

        public void begin() throws NotSupportedException, SystemException {
            this.checkNull(true);
            Transaction t = (Transaction)Mockito.mock(Transaction.class);
            this.txnHistory.add(t);
            this.txns.set(t);
        }
    }
}

