/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetSocketAddress;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.teiid.client.security.ILogon;
import org.teiid.common.buffer.StorageManager;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgBackendProtocol;
import org.teiid.transport.PgFrontendProtocol;
import org.teiid.transport.SSLAwareChannelHandler;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;

public class ODBCSocketListener
extends SocketListener {
    private AuthenticationType authType = AuthenticationType.CLEARTEXT;
    private int maxBufferSize = Integer.parseInt(System.getProperty("org.teiid.ODBCPacketSize", "307200"));
    private int maxLobSize;
    private TeiidDriver driver;
    private ILogon logonService;

    public ODBCSocketListener(InetSocketAddress address, SocketConfiguration config, ClientServiceRegistryImpl csr, StorageManager storageManager, int maxLobSize, ILogon logon) {
        super(address, config, csr, storageManager);
        this.maxLobSize = maxLobSize;
        this.driver = new TeiidDriver();
        this.logonService = logon;
    }

    public void setDriver(TeiidDriver driver) {
        this.driver = driver;
    }

    public void setMaxBufferSize(int maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    protected SSLAwareChannelHandler createChannelPipelineFactory(final SSLConfiguration config, StorageManager storageManager) {
        return new SSLAwareChannelHandler(this, config, Thread.currentThread().getContextClassLoader(), storageManager){

            @Override
            public ChannelPipeline getPipeline() throws Exception {
                DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
                PgBackendProtocol pgBackendProtocol = new PgBackendProtocol(ODBCSocketListener.this.maxLobSize, ODBCSocketListener.this.maxBufferSize, config);
                pipeline.addLast("odbcFrontendProtocol", (ChannelHandler)new PgFrontendProtocol(pgBackendProtocol, 0x100000));
                pipeline.addLast("odbcBackendProtocol", (ChannelHandler)pgBackendProtocol);
                pipeline.addLast("handler", (ChannelHandler)this);
                return pipeline;
            }
        };
    }

    @Override
    public ChannelListener createChannelListener(ObjectChannel channel) {
        return new ODBCClientInstance(channel, this.authType, this.driver, this.logonService);
    }

    public void setAuthenticationType(AuthenticationType value) {
        this.authType = value;
    }
}

