/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.util.Properties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.client.security.ILogon;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.MemoryStorageManager;
import org.teiid.core.crypto.NullCryptor;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.net.CommunicationException;
import org.teiid.net.ConnectionException;
import org.teiid.net.TeiidURL;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.net.socket.SocketServerConnectionFactory;
import org.teiid.net.socket.UrlServerDiscovery;
import org.teiid.services.SessionServiceImpl;
import org.teiid.transport.ClientServiceRegistryImpl;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketListener;
import org.teiid.transport.SocketListenerStats;
import org.teiid.transport.TestSocketRemoting;

public class TestCommSockets {
    SocketListener listener;
    private SocketServerConnectionFactory sscf;
    private InetSocketAddress addr;
    private MemoryStorageManager storageManager;
    private SessionServiceImpl service;

    @Before
    public void setUp() {
        this.addr = new InetSocketAddress(0);
    }

    @After
    public void tearDown() throws Exception {
        if (this.listener != null) {
            this.listener.stop();
        }
    }

    @Test(expected=CommunicationException.class)
    public void testFailedConnect() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        this.listener = new SocketListener(this.addr, 1024, 1024, 1, config, null, (StorageManager)BufferManagerFactory.getStandaloneBufferManager());
        Properties p = new Properties();
        String url = new TeiidURL(this.addr.getHostName(), this.listener.getPort() - 1, false).getAppServerURL();
        p.setProperty("serverURL", url);
        SocketServerConnectionFactory.getInstance().getConnection(p);
    }

    @Test
    public void testConnectWithoutPooling() throws Exception {
        Properties p = new Properties();
        p.setProperty("org.teiid.sockets.maxCachedInstances", String.valueOf(0));
        SocketServerConnection conn = this.helpEstablishConnection(false, new SSLConfiguration(), p);
        SocketListenerStats stats = this.listener.getStats();
        Assert.assertEquals((long)2L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.close();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
        Assert.assertEquals((long)3L, (long)stats.objectsRead);
        if (stats.sockets > 0) {
            Thread.sleep(500L);
        }
        stats = this.listener.getStats();
        Assert.assertEquals((long)0L, (long)stats.sockets);
    }

    @Test
    public void testConnectWithPooling() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false);
        SocketListenerStats stats = this.listener.getStats();
        Assert.assertEquals((long)2L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.close();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
        Assert.assertEquals((long)3L, (long)stats.objectsRead);
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn = this.helpEstablishConnection(false);
        conn.close();
        stats = this.listener.getStats();
        Assert.assertEquals((long)1L, (long)stats.sockets);
        Assert.assertEquals((long)1L, (long)stats.maxSockets);
    }

    @Ignore
    @Test
    public void testLobs() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false);
        TestSocketRemoting.FakeService fs = (TestSocketRemoting.FakeService)conn.getService(TestSocketRemoting.FakeService.class);
        Assert.assertEquals((long)150L, (long)fs.lobMethod(new ByteArrayInputStream(new byte[100]), new StringReader(new String(new char[50]))));
        Assert.assertEquals((long)2L, (long)this.storageManager.getCreated());
        Assert.assertEquals((long)2L, (long)this.storageManager.getRemoved());
        Assert.assertEquals((long)0L, (long)fs.lobMethod(new ByteArrayInputStream(new byte[0]), new StringReader(new String(new char[0]))));
        Assert.assertEquals((long)4L, (long)this.storageManager.getCreated());
        Assert.assertEquals((long)4L, (long)this.storageManager.getRemoved());
        Assert.assertEquals((long)131122L, (long)fs.lobMethod(new ByteArrayInputStream(new byte[131072]), new StringReader(new String(new char[50]))));
        Assert.assertEquals((long)6L, (long)this.storageManager.getCreated());
        Assert.assertEquals((long)6L, (long)this.storageManager.getRemoved());
    }

    @Test
    public void testServerRemoteStreaming() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false);
        TestSocketRemoting.FakeService fs = (TestSocketRemoting.FakeService)conn.getService(TestSocketRemoting.FakeService.class);
        Assert.assertEquals((Object)"hello world", (Object)ObjectConverterUtil.convertToString((Reader)fs.getReader()));
        Assert.assertTrue((boolean)Serializable.class.isAssignableFrom(fs.getReader().getClass()));
    }

    @Test
    public void testConnectWithoutClientEncryption() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        config.setMode("disabled");
        SocketServerConnection conn = this.helpEstablishConnection(false, config, new Properties());
        Assert.assertTrue((boolean)(conn.selectServerInstance(false).getCryptor() instanceof NullCryptor));
        conn.close();
    }

    private SocketServerConnection helpEstablishConnection(boolean secure) throws CommunicationException, ConnectionException {
        return this.helpEstablishConnection(secure, new SSLConfiguration(), new Properties());
    }

    private SocketServerConnection helpEstablishConnection(boolean clientSecure, SSLConfiguration config, Properties socketConfig) throws CommunicationException, ConnectionException {
        if (this.listener == null) {
            ClientServiceRegistryImpl server = new ClientServiceRegistryImpl(){

                public ClassLoader getCallerClassloader() {
                    return ((Object)((Object)this)).getClass().getClassLoader();
                }
            };
            this.service = new SessionServiceImpl();
            server.registerClientService(ILogon.class, (Object)new LogonImpl((SessionService)this.service, "fakeCluster"), null);
            server.registerClientService(TestSocketRemoting.FakeService.class, (Object)new TestSocketRemoting.FakeServiceImpl(), null);
            this.storageManager = new MemoryStorageManager();
            this.listener = new SocketListener(this.addr, 1024, 1024, 1, config, server, (StorageManager)this.storageManager);
            SocketListenerStats stats = this.listener.getStats();
            Assert.assertEquals((long)0L, (long)stats.maxSockets);
            Assert.assertEquals((long)0L, (long)stats.objectsRead);
            Assert.assertEquals((long)0L, (long)stats.objectsWritten);
            Assert.assertEquals((long)0L, (long)stats.sockets);
        }
        Properties p = new Properties();
        String url = new TeiidURL(this.addr.getHostName(), this.listener.getPort(), clientSecure).getAppServerURL();
        p.setProperty("serverURL", url);
        p.setProperty("ApplicationName", "test");
        p.setProperty("discoveryStategy", UrlServerDiscovery.class.getName());
        if (this.sscf == null) {
            this.sscf = new SocketServerConnectionFactory();
            this.sscf.initialize(socketConfig);
        }
        return this.sscf.getConnection(p);
    }

    @Test
    public void testSSLConnectWithNonSSLServer() throws Exception {
        SocketServerConnection conn = this.helpEstablishConnection(false);
        conn.close();
        try {
            this.helpEstablishConnection(true);
            Assert.fail((String)"exception expected");
        }
        catch (CommunicationException communicationException) {
            // empty catch block
        }
    }

    @Test
    public void testAnonSSLConnect() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        config.setMode("enabled");
        config.setEnabledCipherSuites("x");
        config.setAuthenticationMode("anonymous");
        Properties p = new Properties();
        p.setProperty("org.teiid.sockets.soTimeout", "100");
        this.helpEstablishConnection(true, config, p);
        SocketServerConnection conn = this.helpEstablishConnection(true, config, p);
        conn.close();
        try {
            this.helpEstablishConnection(false, config, p);
        }
        catch (CommunicationException e) {
            // empty catch block
        }
    }

    @Test(expected=CommunicationException.class)
    public void testNonAnonSSLConnectWithSSLServer() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        config.setMode("enabled");
        config.setAuthenticationMode("anonymous");
        Properties p = new Properties();
        p.setProperty("org.teiid.ssl.allowAnon", Boolean.FALSE.toString());
        this.helpEstablishConnection(true, config, p);
    }

    @Test
    public void testSelectNewInstanceWithoutPooling() throws Exception {
        Properties p = new Properties();
        p.setProperty("org.teiid.sockets.maxCachedInstances", "0");
        this.helpTestNewInstance(p);
    }

    @Test
    public void testSelectNewInstanceWithPooling() throws Exception {
        Properties p = new Properties();
        p.setProperty("org.teiid.sockets.maxCachedInstances", "16");
        this.helpTestNewInstance(p);
    }

    private void helpTestNewInstance(Properties p) throws CommunicationException, ConnectionException, SessionServiceException {
        SSLConfiguration config = new SSLConfiguration();
        SocketServerConnection conn = this.helpEstablishConnection(false, config, p);
        SocketListenerStats stats = this.listener.getStats();
        Assert.assertEquals((long)2L, (long)stats.objectsRead);
        Assert.assertEquals((long)1L, (long)stats.sockets);
        conn.cleanUp();
        Assert.assertEquals((long)1L, (long)this.service.getActiveSessionsCount());
        SocketServerConnection conn2 = this.helpEstablishConnection(false, config, p);
        Assert.assertEquals((long)2L, (long)this.service.getActiveSessionsCount());
        conn.selectServerInstance(false);
        Assert.assertEquals((long)2L, (long)this.service.getActiveSessionsCount());
        Assert.assertTrue((boolean)conn.isOpen(1000L));
        stats = this.listener.getStats();
        Assert.assertEquals((long)8L, (long)stats.objectsRead);
        Assert.assertEquals((long)2L, (long)stats.sockets);
        conn.close();
        conn2.close();
    }

    @Test
    public void testEnableCipherSuites() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        config.setEnabledCipherSuites("x,y,z");
        Assert.assertArrayEquals((Object[])new String[]{"x", "y", "z"}, (Object[])config.getEnabledCipherSuitesAsArray());
    }

    @Test
    public void testAnonSSLMode() throws Exception {
        SSLConfiguration config = new SSLConfiguration();
        config.setMode("enabled");
        Assert.assertFalse((boolean)config.isClientEncryptionEnabled());
        Assert.assertTrue((boolean)config.isSslEnabled());
        config.setMode("login");
        Assert.assertTrue((boolean)config.isClientEncryptionEnabled());
    }
}

