/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.concurrent.Executor;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.TestCompositeVDB;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.unittest.RealMetadataFactory;

public class TestVDBStatusChecker {
    @Test
    public void testDataSourceReplaced() throws Exception {
        final VDBRepository repo = new VDBRepository();
        repo.setSystemFunctionManager(RealMetadataFactory.SFM);
        repo.start();
        VDBStatusChecker vsc = new VDBStatusChecker(){

            public VDBRepository getVDBRepository() {
                return repo;
            }

            public Executor getExecutor() {
                return null;
            }
        };
        Assert.assertFalse((boolean)vsc.dataSourceReplaced("x", 1, "y", "z", "t", "dsName"));
        CompositeMetadataStore metadataStore = RealMetadataFactory.exampleBQTCached().getMetadataStore();
        VDBMetaData vdb = TestCompositeVDB.createVDBMetadata((MetadataStore)metadataStore, "bqt");
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        cmr.addConnectorManager("BQT1", new ConnectorManager("oracle", "dsName"));
        repo.addVDB(vdb, (MetadataStore)metadataStore, null, null, cmr);
        Assert.assertTrue((boolean)vsc.dataSourceReplaced("bqt", 1, "BQT1", "BQT1", "oracle", "dsName1"));
        Assert.assertFalse((boolean)vsc.dataSourceReplaced("bqt", 1, "BQT1", "BQT1", "oracle", "dsName1"));
    }
}

