/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.File;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.QueryExpression;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;

public class TestEmbeddedServer {
    EmbeddedServer es;
    public static boolean started;

    @Before
    public void setup() {
        this.es = new EmbeddedServer();
    }

    @After
    public void teardown() {
        this.es.stop();
    }

    @Test
    public void testDeploy() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("y", (ExecutionFactory)new ExecutionFactory<AtomicInteger, Object>(){

            public Object getConnection(AtomicInteger factory) throws TranslatorException {
                return factory.incrementAndGet();
            }

            public void closeConnection(Object connection, AtomicInteger factory) {
            }

            public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
                Assert.assertEquals((Object)conn, (Object)1);
                Table t = metadataFactory.addTable("my-table");
                t.setSupportsUpdate(true);
                Column c = metadataFactory.addColumn("my-column", "string", (ColumnSet)t);
                c.setUpdatable(true);
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                ResultSetExecution rse = new ResultSetExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        return null;
                    }
                };
                return rse;
            }

            public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                UpdateExecution ue = new UpdateExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                        return new int[]{2};
                    }
                };
                return ue;
            }
        });
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        this.es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMapping("x", "y", "z");
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" OPTIONS (UPDATABLE 'true') as select * from \"my-table\"");
        this.es.deployVDB("test", new ModelMetaData[]{mmd, mmd1});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from \"my-view\"");
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"my-column", (Object)rs.getMetaData().getColumnLabel(1));
        s.execute("update \"my-view\" set \"my-column\" = 'a'");
        Assert.assertEquals((long)2L, (long)s.getUpdateCount());
        this.es.deployVDB("empty", new ModelMetaData[0]);
        c = this.es.getDriver().connect("jdbc:teiid:empty", null);
        s = c.createStatement();
        s.execute("select * from tables");
        Assert.assertNotNull((Object)this.es.getSchemaDdl("empty", "SYS"));
        Assert.assertNull((Object)this.es.getSchemaDdl("empty", "xxx"));
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testDeploymentError() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" OPTIONS (UPDATABLE 'true') as select * from \"my-table\"");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1});
    }

    @Test
    public void testValidationOrder() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v as select 1");
        ModelMetaData mmd2 = new ModelMetaData();
        mmd2.setName("a");
        mmd2.setModelType(Model.Type.VIRTUAL);
        mmd2.setSchemaSourceType("ddl");
        mmd2.setSchemaText("create view v1 as select * from v");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1, mmd2});
        try {
            this.es.deployVDB("test2", new ModelMetaData[]{mmd2, mmd1});
            Assert.fail();
        }
        catch (VirtualDatabaseException e) {
            // empty catch block
        }
    }

    @Test
    public void testTransactions() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v as select 1; create virtual procedure proc () options (updatecount 2) as begin select * from v; end; create virtual procedure proc1 () as begin atomic select * from v; end; create virtual procedure proc2 (x integer) as begin atomic select 1; begin select 1/x; end exception e end;");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        s.execute("select 1");
        c.setAutoCommit(true);
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        Transaction txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("call proc ()");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("call proc1()");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("set autoCommitTxn on");
        s.execute("set noexec on");
        s.execute("select 1");
        Assert.assertFalse((boolean)s.getResultSet().next());
        s.execute("set autoCommitTxn off");
        s.execute("set noexec off");
        s.execute("call proc2(0)");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        tm.txnHistory.clear();
        tm.begin();
        try {
            c.setAutoCommit(false);
            s.execute("select 1");
            Assert.fail((String)"should fail since we aren't allowing a nested transaction");
        }
        catch (TeiidSQLException e) {
            // empty catch block
        }
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn, (VerificationMode)Mockito.times((int)0))).commit();
    }

    @Test
    public void testMultiSourcePreparedDynamicUpdate() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", new ExecutionFactory());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v (i integer) OPTIONS (UPDATABLE true) as select 1; create trigger on v instead of update as for each row begin atomic IF (CHANGING.i)\nEXECUTE IMMEDIATE 'select \"new\".i'; end; ");
        mmd1.setSupportsMultiSourceBindings(true);
        mmd1.addSourceMapping("x", "t", null);
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("update v set i = ? where i = ?");
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
        ps.setInt(1, 3);
        ps.setInt(2, 1);
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
    }

    @Test
    public void testMultiSourceMetadata() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", new ExecutionFactory());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create foreign table t (x string)");
        mmd1.setSupportsMultiSourceBindings(true);
        mmd1.addSourceMapping("x", "t", null);
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("select * from t");
        ResultSetMetaData metadata = ps.getMetaData();
        Assert.assertEquals((long)1L, (long)metadata.getColumnCount());
        mmd1.addProperty("multisource.addColumn", Boolean.TRUE.toString());
        this.es.undeployVDB("vdb");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        ps = c.prepareStatement("select * from t");
        metadata = ps.getMetaData();
        Assert.assertEquals((long)2L, (long)metadata.getColumnCount());
    }

    @Test
    public void testDynamicUpdate() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", (ExecutionFactory)new ExecutionFactory<Void, Void>(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public boolean isSourceRequired() {
                return false;
            }

            public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Void connection) throws TranslatorException {
                Collection values = CollectorVisitor.collectObjects(Literal.class, (LanguageObject)command);
                Assert.assertEquals((long)2L, (long)values.size());
                for (Literal literal : values) {
                    Assert.assertFalse((boolean)(literal.getValue() instanceof Reference));
                }
                return new UpdateExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                        return new int[]{1};
                    }
                };
            }
        });
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("accounts");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText(ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"dynamic_update.sql")));
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("update hello1 set SchemaName=? where Name=?");
        ps.setString(1, "test1223");
        ps.setString(2, "Columns");
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
    }

    @Test
    public void testStart() throws TranslatorException {
        this.es.addTranslator(MyEF.class);
        Assert.assertTrue((boolean)started);
    }

    public static class MyEF
    extends ExecutionFactory<Void, Void> {
        public void start() throws TranslatorException {
            started = true;
        }
    }

    private final class MockTransactionManager
    implements TransactionManager {
        ThreadLocal<Transaction> txns = new ThreadLocal();
        List<Transaction> txnHistory = new ArrayList<Transaction>();

        private MockTransactionManager() {
        }

        public Transaction suspend() throws SystemException {
            Transaction result = this.txns.get();
            this.txns.remove();
            return result;
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            Transaction result = this.txns.get();
            if (result == null) {
                throw new IllegalStateException();
            }
            result.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            Transaction t = this.checkNull(false);
            this.txns.remove();
            t.rollback();
        }

        public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
            this.checkNull(true);
            this.txns.set(tobj);
        }

        private Transaction checkNull(boolean isNull) {
            Transaction t = this.txns.get();
            if (!isNull && t == null || isNull && t != null) {
                throw new IllegalStateException();
            }
            return t;
        }

        public Transaction getTransaction() throws SystemException {
            return this.txns.get();
        }

        public int getStatus() throws SystemException {
            Transaction t = this.txns.get();
            if (t == null) {
                return 6;
            }
            return t.getStatus();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            Transaction t = this.checkNull(false);
            this.txns.remove();
            t.commit();
        }

        public void begin() throws NotSupportedException, SystemException {
            this.checkNull(true);
            Transaction t = (Transaction)Mockito.mock(Transaction.class);
            this.txnHistory.add(t);
            this.txns.set(t);
        }
    }
}

