/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorProperty;

public class TestTranslatorUtil {
    @Test
    public void testBuildExecutionFactory() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("MyProperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator.class);
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
    }

    @Test
    public void testBuildExecutionFactoryCaseInsensitive() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("myproperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator.class);
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
    }

    @Test
    public void testBuildExecutionFactory1() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("someproperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator1.class);
        MyTranslator1 my = (MyTranslator1)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm, (ClassLoader)this.getClass().getClassLoader());
        Assert.assertNull((Object)my.getMyProperty());
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getSomeProperty());
    }

    @Translator(name="my-translator1")
    public static class MyTranslator1
    extends MyTranslator
    implements SomeProperty {
        private String someProperty;

        @Override
        @TranslatorProperty(display="my-property", required=false)
        public String getMyProperty() {
            return super.getMyProperty();
        }

        @Override
        public String getSomeProperty() {
            return this.someProperty;
        }

        @Override
        public void setSomeProperty(String value) {
            this.someProperty = value;
        }
    }

    public static interface SomeProperty {
        @TranslatorProperty(display="my-property", required=false)
        public String getSomeProperty();

        public void setSomeProperty(String var1);
    }

    @Translator(name="my-translator")
    public static class MyTranslator
    extends ExecutionFactory<Object, Object> {
        String mine;

        @TranslatorProperty(display="my-property", required=true)
        public String getMyProperty() {
            return this.mine;
        }

        public void setMyProperty(String value) {
            this.mine = value;
        }
    }
}

