/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Executor;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidException;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.TranslatorRepository;
import org.teiid.logging.LogManager;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.translator.ExecutionFactory;
import org.teiid.vdb.runtime.VDBKey;

public abstract class VDBStatusChecker {
    private static final String JAVA_CONTEXT = "java:/";
    private TranslatorRepository translatorRepository;

    public void translatorAdded(String translatorName) {
    }

    public void translatorRemoved(String translatorName) {
    }

    public void dataSourceAdded(String dataSourceName, VDBKey vdbKey) {
        dataSourceName = VDBStatusChecker.stripContext(dataSourceName);
        if (vdbKey == null) {
            this.resourceAdded(dataSourceName);
        } else {
            CompositeVDB cvdb = this.getVDBRepository().getCompositeVDB(vdbKey);
            if (cvdb == null) {
                return;
            }
            VDBMetaData vdb = cvdb.getVDB();
            this.resourceAdded(dataSourceName, new LinkedList<Runnable>(), vdb);
        }
    }

    public static String stripContext(String dataSourceName) {
        if (dataSourceName == null) {
            return null;
        }
        if (dataSourceName.startsWith(JAVA_CONTEXT)) {
            dataSourceName = dataSourceName.substring(5);
        }
        return dataSourceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataSourceRemoved(String dataSourceName, VDBKey vdbKey) {
        dataSourceName = VDBStatusChecker.stripContext(dataSourceName);
        CompositeVDB cvdb = this.getVDBRepository().getCompositeVDB(vdbKey);
        if (cvdb == null) {
            return;
        }
        VDBMetaData vdb = cvdb.getVDB();
        if (vdb.getStatus() == VDB.Status.FAILED) {
            return;
        }
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
            for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                String sourceName = this.getSourceName(dataSourceName, model);
                if (sourceName == null) continue;
                ModelMetaData.Message.Severity severity = ModelMetaData.Message.Severity.WARNING;
                ConnectorManager cm = cmr.getConnectorManager(sourceName);
                if (cm.getExecutionFactory().isSourceRequired() && vdb.getStatus() == VDB.Status.ACTIVE) {
                    severity = ModelMetaData.Message.Severity.ERROR;
                }
                String msg = RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40012, new Object[]{vdb.getName(), vdb.getVersion(), dataSourceName});
                model.addRuntimeMessage(severity, msg);
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dataSourceReplaced(String vdbName, int vdbVersion, String modelName, String sourceName, String translatorName, String dsName) throws AdminProcessingException {
        dsName = VDBStatusChecker.stripContext(dsName);
        VDBMetaData vdb = this.getVDBRepository().getLiveVDB(vdbName, vdbVersion);
        if (vdb == null || vdb.getStatus() == VDB.Status.FAILED) {
            return false;
        }
        ModelMetaData model = vdb.getModel(modelName);
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
            ConnectorManager cm = cmr.getConnectorManager(sourceName);
            ExecutionFactory ef = cm.getExecutionFactory();
            boolean dsReplaced = false;
            String oldDsName = VDBStatusChecker.stripContext(cm.getConnectionName());
            if (dsName != null && !dsName.equals(oldDsName) || dsName == null && oldDsName != null) {
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40076, new Object[]{vdb.getName(), vdb.getVersion(), model.getSourceTranslatorName(sourceName), dsName}));
                cm = new ConnectorManager(translatorName, dsName);
                cm.setExecutionFactory(ef);
                cmr.addConnectorManager(sourceName, cm);
                dsReplaced = true;
            }
            if (!cm.getTranslatorName().equals(translatorName)) {
                try {
                    TranslatorRepository repo = (TranslatorRepository)vdb.getAttachment(TranslatorRepository.class);
                    VDBTranslatorMetaData t = null;
                    if (repo != null) {
                        t = repo.getTranslatorMetaData(translatorName);
                    }
                    if (t == null) {
                        t = this.translatorRepository.getTranslatorMetaData(translatorName);
                    }
                    if (t == null) {
                        throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40032, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40032, new Object[]{vdb.getName(), vdb.getVersion(), translatorName}));
                    }
                    ef = TranslatorUtil.buildExecutionFactory(t);
                    cm.setExecutionFactory(ef);
                }
                catch (TeiidException e) {
                    throw new AdminProcessingException((BundleUtil.Event)RuntimePlugin.Event.TEIID40033, e.getCause());
                }
            }
            if (dsReplaced) {
                ArrayList<Runnable> runnables = new ArrayList<Runnable>(1);
                this.checkStatus(runnables, vdb, model, cm);
                this.updateVDB(runnables, vdb);
            }
            return dsReplaced;
        }
    }

    void resourceAdded(String resourceName) {
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        for (CompositeVDB cvdb : this.getVDBRepository().getCompositeVDBs()) {
            VDBMetaData vdb = cvdb.getVDB();
            if (vdb.getStatus() == VDB.Status.FAILED) continue;
            this.resourceAdded(resourceName, runnables, vdb);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resourceAdded(String resourceName, List<Runnable> runnables, VDBMetaData vdb) {
        VDBMetaData vDBMetaData = vdb;
        synchronized (vDBMetaData) {
            ConnectorManagerRepository cmr = (ConnectorManagerRepository)vdb.getAttachment(ConnectorManagerRepository.class);
            boolean usesResourse = false;
            for (ModelMetaData model : vdb.getModelMetaDatas().values()) {
                if (!model.hasRuntimeMessages()) {
                    return;
                }
                String sourceName = this.getSourceName(resourceName, model);
                if (sourceName == null) {
                    return;
                }
                usesResourse = true;
                ConnectorManager cm = cmr.getConnectorManager(sourceName);
                this.checkStatus(runnables, vdb, model, cm);
            }
            if (usesResourse) {
                this.updateVDB(runnables, vdb);
            }
        }
    }

    private void updateVDB(List<Runnable> runnables, VDBMetaData vdb) {
        if (!runnables.isEmpty()) {
            for (Runnable runnable : runnables) {
                this.getExecutor().execute(runnable);
            }
            runnables.clear();
        } else if (vdb.hasErrors()) {
            LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40003, new Object[]{vdb.getName(), vdb.getVersion(), vdb.getStatus()}));
        }
    }

    private void checkStatus(List<Runnable> runnables, VDBMetaData vdb, ModelMetaData model, ConnectorManager cm) {
        Runnable r = (Runnable)model.removeAttachment(Runnable.class);
        if (r != null) {
            runnables.add(r);
        } else {
            String status = cm.getStausMessage();
            if (status != null && status.length() > 0) {
                ModelMetaData.Message.Severity severity = vdb.getStatus() == VDB.Status.LOADING ? ModelMetaData.Message.Severity.WARNING : ModelMetaData.Message.Severity.ERROR;
                model.addRuntimeMessage(severity, status);
                LogManager.logInfo((String)"org.teiid.RUNTIME", (Object)status);
            } else if (vdb.getStatus() != VDB.Status.LOADING) {
                model.clearRuntimeMessages();
            }
        }
    }

    private String getSourceName(String factoryName, ModelMetaData model) {
        for (SourceMappingMetadata source : model.getSources().values()) {
            String jndiName = source.getConnectionJndiName();
            if (jndiName == null || !factoryName.equals(jndiName = VDBStatusChecker.stripContext(jndiName))) continue;
            return source.getName();
        }
        return null;
    }

    public abstract Executor getExecutor();

    public abstract VDBRepository getVDBRepository();

    public void setTranslatorRepository(TranslatorRepository repo) {
        this.translatorRepository = repo;
    }
}

