/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.SSLConfiguration;

public class SocketConfiguration {
    private int outputBufferSize;
    private int inputBufferSize;
    private int maxSocketThreads;
    private int portNumber;
    private InetAddress hostAddress;
    private SSLConfiguration sslConfiguration;
    private String hostName;
    private String name;
    private String protocol = "teiid";

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setBindAddress(String addr) {
        this.hostName = addr;
    }

    public void setPortNumber(int port) {
        this.portNumber = port;
    }

    public void setMaxSocketThreads(int value) {
        this.maxSocketThreads = value;
    }

    public void setInputBufferSize(int value) {
        this.inputBufferSize = value;
    }

    public void setOutputBufferSize(int value) {
        this.outputBufferSize = value;
    }

    public void setSSLConfiguration(SSLConfiguration value) {
        this.sslConfiguration = value;
    }

    private void resolveHostName() {
        try {
            if (this.hostName == null) {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
        }
        catch (UnknownHostException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40065, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40065, new Object[0]));
        }
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getMaxSocketThreads() {
        return this.maxSocketThreads;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public InetAddress getHostAddress() {
        this.resolveHostName();
        if (this.hostAddress != null) {
            return this.hostAddress;
        }
        try {
            InetAddress addr = InetAddress.getByName(this.hostName);
            if (addr.getHostAddress().equalsIgnoreCase(this.hostName)) {
                this.hostAddress = addr;
            }
            return addr;
        }
        catch (UnknownHostException e) {
            throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40065, RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40065, new Object[0]));
        }
    }

    public void setHostAddress(InetAddress hostAddress) {
        this.hostAddress = hostAddress;
        this.hostName = hostAddress.getHostName();
    }

    public String getHostName() {
        this.resolveHostName();
        return this.hostName;
    }

    public SSLConfiguration getSSLConfiguration() {
        return this.sslConfiguration;
    }

    public boolean getSslEnabled() {
        return this.sslConfiguration != null && this.sslConfiguration.isSslEnabled();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }
}

