/*
 * Decompiled with CFR 0.152.
 */
package TestScriptReader;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.odbc.ScriptReader;

public class TestScriptReader {
    @Test
    public void testRewrite() throws Exception {
        ScriptReader sr = new ScriptReader("select 'a'::b from foo");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select cast('a' AS b) from foo", (Object)result);
    }

    @Test
    public void testRewriteComplexLiteral() throws Exception {
        ScriptReader sr = new ScriptReader("select 'a''c'::b");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select cast('a''c' AS b)", (Object)result);
    }

    @Test
    public void testRewrite1() throws Exception {
        ScriptReader sr = new ScriptReader("select a~b, a!~~c from foo");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select a LIKE_REGEX b, a NOT LIKE c from foo", (Object)result);
    }

    @Test
    public void testRewrite2() throws Exception {
        ScriptReader sr = new ScriptReader("select a~");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select a LIKE_REGEX ", (Object)result);
    }

    @Test
    public void testRewrite3() throws Exception {
        ScriptReader sr = new ScriptReader("select a::b");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"select a", (Object)result);
    }

    @Test
    public void testDelimited() throws Exception {
        ScriptReader sr = new ScriptReader("set foo 'bar'; set foo1 'bar1'");
        String result = sr.readStatement();
        Assert.assertEquals((Object)"set foo 'bar'", (Object)result);
        result = sr.readStatement();
        Assert.assertEquals((Object)" set foo1 'bar1'", (Object)result);
    }

    @Test
    public void testRegClassCast() throws Exception {
        ScriptReader sr = new ScriptReader("where oid='\"a\"'::regclass");
        sr.setRewrite(true);
        String result = sr.readStatement();
        Assert.assertEquals((Object)"where oid=(SELECT oid FROM pg_class WHERE upper(relname) = 'A')", (Object)result);
    }
}

