/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.concurrent.Executor;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.TestCompositeVDB;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VDBStatusChecker;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadata.MetadataStore;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionFactory;

public class TestVDBStatusChecker {
    @Test
    public void testDataSourceReplaced() throws Exception {
        final VDBRepository repo = new VDBRepository();
        repo.setSystemFunctionManager(RealMetadataFactory.SFM);
        repo.start();
        VDBStatusChecker vsc = new VDBStatusChecker(){

            public VDBRepository getVDBRepository() {
                return repo;
            }

            public Executor getExecutor() {
                return null;
            }
        };
        VDBTranslatorMetaData factory = new VDBTranslatorMetaData();
        factory.setExecutionFactoryClass(ExecutionFactory.class);
        Assert.assertFalse((boolean)vsc.dataSourceReplaced("x", 1, "y", "z", "t", "dsName"));
        CompositeMetadataStore metadataStore = RealMetadataFactory.exampleBQTCached().getMetadataStore();
        VDBMetaData vdb = TestCompositeVDB.createVDBMetadata((MetadataStore)metadataStore, "bqt");
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        cmr.setProvider(new ConnectorManagerRepository.ExecutionFactoryProvider(){

            public ExecutionFactory<Object, Object> getExecutionFactory(String name) throws ConnectorManagerRepository.ConnectorManagerException {
                return new ExecutionFactory();
            }
        });
        ExecutionFactory ef1 = new ExecutionFactory();
        ConnectorManager mgr = new ConnectorManager("oracle", "dsName", ef1);
        cmr.addConnectorManager("BQT1", mgr);
        repo.addVDB(vdb, (MetadataStore)metadataStore, null, null, cmr);
        Assert.assertTrue((boolean)vsc.dataSourceReplaced("bqt", 1, "BQT1", "BQT1", "oracle", "dsName1"));
        ExecutionFactory ef = cmr.getConnectorManager("BQT1").getExecutionFactory();
        Assert.assertSame((Object)ef, (Object)ef1);
        Assert.assertFalse((boolean)vsc.dataSourceReplaced("bqt", 1, "BQT1", "BQT1", "sqlserver", "dsName1"));
        ExecutionFactory ef2 = cmr.getConnectorManager("BQT1").getExecutionFactory();
        Assert.assertNotNull((Object)ef2);
        Assert.assertNotSame((Object)ef, (Object)ef2);
        Assert.assertTrue((boolean)vsc.dataSourceReplaced("bqt", 1, "BQT1", "BQT1", "oracle", "dsName2"));
        ef = cmr.getConnectorManager("BQT1").getExecutionFactory();
        Assert.assertNotNull((Object)ef);
        Assert.assertNotSame((Object)ef, (Object)ef2);
    }
}

