/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.Executors;
import javax.resource.spi.work.WorkManager;
import javax.transaction.TransactionManager;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jgroups.Channel;
import org.jgroups.ChannelListener;
import org.jgroups.JChannel;
import org.teiid.PolicyDecider;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.infinispan.InfinispanCacheFactory;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.dqp.internal.process.AuthorizationValidator;
import org.teiid.dqp.internal.process.DQPConfiguration;
import org.teiid.dqp.internal.process.DataRolePolicyDecider;
import org.teiid.dqp.internal.process.DefaultAuthorizationValidator;
import org.teiid.dqp.internal.process.TeiidExecutor;
import org.teiid.query.ObjectReplicator;
import org.teiid.replication.jgroups.ChannelFactory;
import org.teiid.replication.jgroups.JGroupsObjectReplicator;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.runtime.WorkManagerTeiidExecutor;
import org.teiid.security.SecurityHelper;
import org.teiid.transport.SocketConfiguration;

public class EmbeddedConfiguration
extends DQPConfiguration {
    private SecurityHelper securityHelper;
    private List<String> securityDomains;
    private TransactionManager transactionManager;
    private ObjectReplicator objectReplicator;
    private WorkManager workManager;
    private boolean useDisk = true;
    private String bufferDirectory;
    private CacheFactory cacheFactory;
    private int maxResultSetCacheStaleness = 60;
    private String infinispanConfigFile = "infinispan-config.xml";
    private String jgroupsConfigFile;
    private List<SocketConfiguration> transports;
    private int maxODBCLobSizeAllowed = 0x500000;
    private DefaultCacheManager manager;
    private SimpleChannelFactory channelFactory;

    public EmbeddedConfiguration() {
        DefaultAuthorizationValidator authorizationValidator = new DefaultAuthorizationValidator();
        authorizationValidator.setPolicyDecider((PolicyDecider)new DataRolePolicyDecider());
        this.setAuthorizationValidator((AuthorizationValidator)authorizationValidator);
    }

    public SecurityHelper getSecurityHelper() {
        return this.securityHelper;
    }

    public void setSecurityHelper(SecurityHelper securityHelper) {
        this.securityHelper = securityHelper;
    }

    public List<String> getSecurityDomains() {
        return this.securityDomains;
    }

    public void setSecurityDomains(List<String> securityDomains) {
        this.securityDomains = securityDomains;
    }

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public ObjectReplicator getObjectReplicator() {
        if (this.objectReplicator == null && this.jgroupsConfigFile != null) {
            this.channelFactory = new SimpleChannelFactory();
            this.objectReplicator = new JGroupsObjectReplicator(this.channelFactory, Executors.newCachedThreadPool());
        }
        return this.objectReplicator;
    }

    public void setObjectReplicator(ObjectReplicator objectReplicator) {
        this.objectReplicator = objectReplicator;
    }

    public void setWorkManager(WorkManager workManager) {
        this.workManager = workManager;
    }

    public WorkManager getWorkManager() {
        return this.workManager;
    }

    public TeiidExecutor getTeiidExecutor() {
        if (this.workManager == null) {
            return super.getTeiidExecutor();
        }
        return new WorkManagerTeiidExecutor(this.workManager);
    }

    public boolean isUseDisk() {
        return this.useDisk;
    }

    public void setUseDisk(boolean useDisk) {
        this.useDisk = useDisk;
    }

    public void setBufferDirectory(String dir) {
        this.bufferDirectory = dir;
    }

    public String getBufferDirectory() {
        return this.bufferDirectory;
    }

    public String getInfinispanConfigFile() {
        return this.infinispanConfigFile;
    }

    public void setInfinispanConfigFile(String infinispanConfigFile) {
        this.infinispanConfigFile = infinispanConfigFile;
    }

    public CacheFactory getCacheFactory() {
        if (this.cacheFactory == null) {
            try {
                this.manager = new DefaultCacheManager(this.infinispanConfigFile, true);
                for (String cacheName : this.manager.getCacheNames()) {
                    this.manager.startCache(cacheName);
                }
                this.cacheFactory = new InfinispanCacheFactory((EmbeddedCacheManager)this.manager, ((Object)((Object)this)).getClass().getClassLoader());
            }
            catch (IOException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)RuntimePlugin.Event.TEIID40100, (Throwable)e);
            }
        }
        return this.cacheFactory;
    }

    public void setCacheFactory(CacheFactory cacheFactory) {
        this.cacheFactory = cacheFactory;
    }

    public int getMaxResultSetCacheStaleness() {
        return this.maxResultSetCacheStaleness;
    }

    public void setMaxResultSetCacheStaleness(int maxResultSetCacheStaleness) {
        this.maxResultSetCacheStaleness = maxResultSetCacheStaleness;
    }

    public String getJgroupsConfigFile() {
        return this.jgroupsConfigFile;
    }

    public void setJgroupsConfigFile(String jgroupsConfigFile) {
        this.jgroupsConfigFile = jgroupsConfigFile;
    }

    protected void stop() {
        if (this.manager != null) {
            this.manager.stop();
        }
        if (this.channelFactory != null) {
            this.channelFactory.stop();
        }
    }

    public void addTransport(SocketConfiguration configuration) {
        if (this.transports == null) {
            this.transports = new ArrayList<SocketConfiguration>();
        }
        this.transports.add(configuration);
    }

    public List<SocketConfiguration> getTransports() {
        return this.transports;
    }

    public int getMaxODBCLobSizeAllowed() {
        return this.maxODBCLobSizeAllowed;
    }

    public void setMaxODBCLobSizeAllowed(int lobSize) {
        this.maxODBCLobSizeAllowed = lobSize;
    }

    private final class SimpleChannelFactory
    implements ChannelFactory,
    ChannelListener {
        private final Map<Channel, String> channels = new WeakHashMap<Channel, String>();

        private SimpleChannelFactory() {
        }

        @Override
        public Channel createChannel(String id) throws Exception {
            JChannel channel = new JChannel(this.getClass().getClassLoader().getResource(EmbeddedConfiguration.this.getJgroupsConfigFile()));
            this.channels.put((Channel)channel, id);
            channel.addChannelListener((ChannelListener)this);
            return channel;
        }

        public void channelClosed(Channel channel) {
            this.channels.remove(channel);
        }

        public void channelConnected(Channel channel) {
        }

        public void channelDisconnected(Channel channel) {
        }

        void stop() {
            for (Channel c : new ArrayList<Channel>(this.channels.keySet())) {
                c.close();
            }
        }
    }
}

