/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import org.junit.Assert;
import org.junit.Test;
import org.teiid.adminapi.impl.VDBTranslatorMetaData;
import org.teiid.deployers.TranslatorUtil;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorProperty;

public class TestTranslatorUtil {
    @Test
    public void testInitialSetValueExecutionFactory() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.setExecutionFactoryClass(MyTranslator2.class);
        MyTranslator2 my = (MyTranslator2)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"original-assigned", (Object)my.getSomeProperty());
    }

    @Test
    public void testBuildExecutionFactory() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("MyProperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator.class);
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
        Assert.assertNull((Object)my.other());
        tm.addProperty("other", "foo");
        tm.setExecutionFactoryClass(MyTranslator.class);
        my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"foo", (Object)my.other());
    }

    @Test
    public void testBuildExecutionFactoryWithDefaults() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        VDBTranslatorMetaData parent = new VDBTranslatorMetaData();
        parent.addProperty("myProperty", "default");
        parent.setExecutionFactoryClass(MyTranslator.class);
        tm.setParent(parent);
        tm.addProperty("MyProperty", "correctly-assigned");
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
    }

    @Test
    public void testBuildExecutionFactoryCaseInsensitive() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("myproperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator.class);
        MyTranslator my = (MyTranslator)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getMyProperty());
    }

    @Test
    public void testBuildExecutionFactory1() throws Exception {
        VDBTranslatorMetaData tm = new VDBTranslatorMetaData();
        tm.addProperty("someproperty", "correctly-assigned");
        tm.setExecutionFactoryClass(MyTranslator1.class);
        MyTranslator1 my = (MyTranslator1)TranslatorUtil.buildExecutionFactory((VDBTranslatorMetaData)tm);
        Assert.assertNull((Object)my.getMyProperty());
        Assert.assertEquals((Object)"correctly-assigned", (Object)my.getSomeProperty());
    }

    @Translator(name="my-translator2")
    public static class MyTranslator2
    extends MyTranslator1 {
        public MyTranslator2() {
            this.setSomeProperty("original-assigned");
        }
    }

    @Translator(name="my-translator1")
    public static class MyTranslator1
    extends MyTranslator
    implements SomeProperty {
        private String someProperty;

        @Override
        @TranslatorProperty(display="my-property", required=false)
        public String getMyProperty() {
            return super.getMyProperty();
        }

        @Override
        public String getSomeProperty() {
            return this.someProperty;
        }

        @Override
        public void setSomeProperty(String value) {
            this.someProperty = value;
        }
    }

    public static interface SomeProperty {
        @TranslatorProperty(display="my-property", required=false)
        public String getSomeProperty();

        public void setSomeProperty(String var1);
    }

    @Translator(name="my-translator")
    public static class MyTranslator
    extends ExecutionFactory<Object, Object> {
        String mine;
        String other;

        @TranslatorProperty(display="my-property", required=true)
        public String getMyProperty() {
            return this.mine;
        }

        public void setMyProperty(String value) {
            this.mine = value;
        }

        @TranslatorProperty(display="other")
        public String other() {
            return this.other;
        }

        public void setOther(String other) {
            this.other = other;
        }
    }
}

