/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odbc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;

public class ScriptReader {
    private Reader reader;
    private StringBuilder builder;
    private boolean endOfFile;
    private boolean insideRemark;
    private boolean blockRemark;
    private boolean rewrite;
    private int expressionStart = -1;
    private int expressionEnd = -1;

    public ScriptReader(Reader reader) {
        this.reader = reader;
        this.builder = new StringBuilder(8192);
    }

    public ScriptReader(String string) {
        this.reader = new StringReader(string);
        this.builder = new StringBuilder(string.length());
    }

    public void close() throws IOException {
        this.reader.close();
    }

    public String readStatement() throws IOException {
        if (this.endOfFile) {
            return null;
        }
        return this.readStatementLoop();
    }

    private String readStatementLoop() throws IOException {
        int c = this.read();
        block9: while (true) {
            if (c < 0) {
                this.endOfFile = true;
                break;
            }
            if (c == 59) {
                this.builder.setLength(this.builder.length() - 1);
                break;
            }
            switch (c) {
                case 36: {
                    c = this.read();
                    if (c != 36 || this.builder.length() >= 3 && this.builder.charAt(this.builder.length() - 3) > ' ') continue block9;
                    while ((c = this.read()) >= 0 && (c != 36 || (c = this.read()) >= 0 && c != 36)) {
                    }
                    c = this.read();
                    continue block9;
                }
                case 39: {
                    if (this.expressionEnd != this.builder.length() - 1) {
                        this.expressionStart = this.builder.length() - 1;
                    }
                    while ((c = this.read()) >= 0 && c != 39) {
                    }
                    this.expressionEnd = this.builder.length();
                    c = this.read();
                    continue block9;
                }
                case 34: {
                    while ((c = this.read()) >= 0 && c != 34) {
                    }
                    c = this.read();
                    continue block9;
                }
                case 47: {
                    c = this.read();
                    if (c == 42) {
                        this.startRemark(false);
                        while ((c = this.read()) >= 0) {
                            if (c != 42) continue;
                            c = this.read();
                            if (c < 0) break;
                            if (c != 47) continue;
                            this.endRemark();
                            break;
                        }
                        c = this.read();
                        continue block9;
                    }
                    if (c != 47) continue block9;
                    this.startRemark(false);
                    while ((c = this.read()) >= 0) {
                        if (c != 13 && c != 10) continue;
                        this.endRemark();
                        break;
                    }
                    c = this.read();
                    continue block9;
                }
                case 45: {
                    c = this.read();
                    if (c != 45) continue block9;
                    this.startRemark(false);
                    while ((c = this.read()) >= 0) {
                        if (c != 13 && c != 10) continue;
                        this.endRemark();
                        break;
                    }
                    c = this.read();
                    continue block9;
                }
                case 58: {
                    int start;
                    if (this.rewrite) {
                        start = this.builder.length();
                        c = this.read();
                        if (c != 58) continue block9;
                        while ((c = this.read()) >= 0 && Character.isLetterOrDigit(c)) {
                        }
                        String type = this.builder.substring(start + 1, this.builder.length() - (c < 0 ? 0 : 1));
                        this.builder.setLength(start - 1);
                        if (this.expressionStart != -1 && this.expressionEnd == start - 1) {
                            if ("regclass".equalsIgnoreCase(type)) {
                                String name = this.builder.substring(this.expressionStart);
                                if (name.startsWith("'\"") && name.length() > 4) {
                                    name = name.substring(2, name.length() - 2);
                                    name = '\'' + name + '\'';
                                }
                                if (name.startsWith("'")) {
                                    this.builder.setLength(this.expressionStart);
                                    this.builder.append(name.toUpperCase());
                                }
                                this.builder.insert(this.expressionStart, "(SELECT oid FROM pg_class WHERE upper(relname) = ");
                                this.builder.append(")");
                            } else if ("regproc".equalsIgnoreCase(type)) {
                                String name = this.builder.substring(this.expressionStart);
                                if (name.startsWith("'\"") && name.length() > 4) {
                                    name = name.substring(2, name.length() - 2);
                                    name = '\'' + name + '\'';
                                }
                                if (name.startsWith("'")) {
                                    this.builder.setLength(this.expressionStart);
                                    this.builder.append(name.toUpperCase());
                                }
                                this.builder.insert(this.expressionStart, "(SELECT oid FROM pg_proc WHERE upper(proname) = ");
                                this.builder.append(")");
                            } else {
                                this.builder.insert(this.expressionStart, "cast(");
                                this.builder.append(" AS ").append(type).append(")");
                            }
                        }
                        if (c == -1) continue block9;
                        this.builder.append((char)c);
                        continue block9;
                    }
                    c = this.read();
                    continue block9;
                }
                case 126: {
                    int start;
                    if (this.rewrite) {
                        start = this.builder.length() - 1;
                        boolean not = false;
                        if (start > 0 && this.builder.charAt(start - 1) == '!') {
                            not = true;
                            --start;
                        }
                        c = this.read();
                        boolean like = false;
                        if (c == 126) {
                            like = true;
                            c = this.read();
                        }
                        if (c == 42) continue block9;
                        this.builder.setLength(start);
                        if (not) {
                            this.builder.append(" NOT");
                        }
                        if (like) {
                            this.builder.append(" LIKE ");
                        } else {
                            this.builder.append(" LIKE_REGEX ");
                        }
                        if (c != -1) {
                            this.builder.append((char)c);
                        }
                    }
                    c = this.read();
                    continue block9;
                }
            }
            c = this.read();
        }
        String result = this.builder.toString();
        this.builder.setLength(0);
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    private void startRemark(boolean block) {
        this.blockRemark = block;
        this.insideRemark = true;
    }

    private void endRemark() {
        this.insideRemark = false;
    }

    private int read() throws IOException {
        int c = this.reader.read();
        if (c != -1) {
            this.builder.append((char)c);
        }
        return c;
    }

    public boolean isInsideRemark() {
        return this.insideRemark;
    }

    public boolean isBlockRemark() {
        return this.blockRemark;
    }

    public void setRewrite(boolean rewrite) {
        this.rewrite = rewrite;
    }
}

