/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.OutputStream;
import java.io.StreamCorruptedException;
import java.util.List;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBufferInputStream;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.handler.codec.frame.LengthFieldBasedFrameDecoder;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.FileStoreInputStreamFactory;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.util.ExternalizeUtil;
import org.teiid.netty.handler.codec.serialization.CompactObjectInputStream;

public class ObjectDecoder
extends LengthFieldBasedFrameDecoder {
    public static final long MAX_LOB_SIZE = 0x100000000L;
    private final ClassLoader classLoader;
    private Object result;
    private int streamIndex;
    private OutputStream stream;
    private List<InputStreamFactory.StreamFactoryReference> streams;
    private StorageManager storageManager;
    private FileStore store;
    private StreamCorruptedException error;

    public ObjectDecoder(int maxObjectSize, ClassLoader classLoader, StorageManager storageManager) {
        super(maxObjectSize, 0, 4, 0, 4);
        this.classLoader = classLoader;
        this.storageManager = storageManager;
    }

    protected Object decode(ChannelHandlerContext ctx, Channel channel, ChannelBuffer buffer) throws Exception {
        if (this.result == null) {
            ChannelBuffer frame = (ChannelBuffer)super.decode(ctx, channel, buffer);
            if (frame == null) {
                return null;
            }
            CompactObjectInputStream cois = new CompactObjectInputStream((InputStream)new ChannelBufferInputStream(frame), this.classLoader);
            this.result = cois.readObject();
            this.streams = ExternalizeUtil.readList((ObjectInput)cois, InputStreamFactory.StreamFactoryReference.class);
            this.streamIndex = 0;
        }
        while (this.streamIndex < this.streams.size()) {
            if (buffer.readableBytes() < 2) {
                return null;
            }
            int dataLen = buffer.getShort(buffer.readerIndex()) & 0xFFFF;
            if (buffer.readableBytes() < dataLen + 2) {
                return null;
            }
            buffer.skipBytes(2);
            if (this.stream == null) {
                this.store = this.storageManager.createFileStore("temp-stream");
                InputStreamFactory.StreamFactoryReference sfr = this.streams.get(this.streamIndex);
                sfr.setStreamFactory((InputStreamFactory)new FileStoreInputStreamFactory(this.store, "UTF-8"));
                this.stream = new BufferedOutputStream(this.store.createOutputStream());
            }
            if (dataLen == 0) {
                this.stream.close();
                this.stream = null;
                ++this.streamIndex;
                continue;
            }
            if (this.store.getLength() + (long)dataLen > 0x100000000L && this.error == null) {
                this.error = new StreamCorruptedException("lob too big: " + this.store.getLength() + dataLen + " (max: " + 0x100000000L + ')');
            }
            if (this.error == null) {
                buffer.readBytes(this.stream, dataLen);
                continue;
            }
            buffer.skipBytes(dataLen);
        }
        Object toReturn = this.result;
        this.result = null;
        this.streams = null;
        this.stream = null;
        this.store = null;
        if (this.error != null) {
            StreamCorruptedException sce = this.error;
            this.error = null;
            throw sce;
        }
        return toReturn;
    }

    protected ChannelBuffer extractFrame(ChannelBuffer buffer, int index, int length) {
        return buffer.slice(index, length);
    }
}

