/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.transport;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.net.ssl.SSLEngine;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.DefaultChannelPipeline;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelHandler;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.teiid.common.buffer.StorageManager;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.ObjectChannel;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.transport.ChannelListener;
import org.teiid.transport.ObjectDecoder;
import org.teiid.transport.ObjectEncoder;
import org.teiid.transport.SSLConfiguration;

@ChannelHandler.Sharable
public class SSLAwareChannelHandler
extends SimpleChannelHandler
implements ChannelPipelineFactory {
    private static final int DEFAULT_MAX_MESSAGE_SIZE = 0x200000;
    private final ChannelListener.ChannelListenerFactory listenerFactory;
    private final SSLConfiguration config;
    private final ClassLoader classLoader;
    private final StorageManager storageManager;
    private Map<Channel, ChannelListener> listeners = new ConcurrentHashMap<Channel, ChannelListener>();
    private AtomicLong objectsRead = new AtomicLong(0L);
    private AtomicLong objectsWritten = new AtomicLong(0L);
    private volatile int maxChannels;
    private int maxMessageSize = PropertiesUtils.getIntProperty((Properties)System.getProperties(), (String)"org.teiid.maxMessageSize", (int)0x200000);
    private ChannelFutureListener completionListener = new ChannelFutureListener(){

        public void operationComplete(ChannelFuture arg0) throws Exception {
            if (arg0.isSuccess()) {
                SSLAwareChannelHandler.this.objectsWritten.getAndIncrement();
            }
        }
    };

    public SSLAwareChannelHandler(ChannelListener.ChannelListenerFactory listenerFactory, SSLConfiguration config, ClassLoader classloader, StorageManager storageManager) {
        this.listenerFactory = listenerFactory;
        this.config = config;
        this.classLoader = classloader;
        this.storageManager = storageManager;
    }

    public void channelConnected(ChannelHandlerContext ctx, final ChannelStateEvent e) throws Exception {
        ChannelListener listener = this.listenerFactory.createChannelListener(new ObjectChannelImpl(e.getChannel()));
        this.listeners.put(e.getChannel(), listener);
        this.maxChannels = Math.max(this.maxChannels, this.listeners.size());
        SslHandler sslHandler = (SslHandler)ctx.getPipeline().get(SslHandler.class);
        if (sslHandler != null) {
            sslHandler.handshake().addListener(new ChannelFutureListener(){

                public void operationComplete(ChannelFuture arg0) throws Exception {
                    SSLAwareChannelHandler.this.onConnection(e.getChannel());
                }
            });
        } else {
            this.onConnection(e.getChannel());
        }
    }

    private void onConnection(Channel channel) throws Exception {
        ChannelListener listener = this.listeners.get(channel);
        if (listener != null) {
            listener.onConnection();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
        ChannelListener listener = this.listeners.get(e.getChannel());
        if (listener != null) {
            listener.exceptionOccurred(e.getCause());
        } else {
            e.getChannel().close();
        }
    }

    public void messageReceived(ChannelHandlerContext ctx, MessageEvent e) throws Exception {
        this.objectsRead.getAndIncrement();
        ChannelListener listener = this.listeners.get(e.getChannel());
        if (listener != null) {
            listener.receivedMessage(e.getMessage());
        }
    }

    public void channelDisconnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
        ChannelListener listener = this.listeners.remove(e.getChannel());
        if (listener != null) {
            LogManager.logDetail((String)"org.teiid.TRANSPORT", (Object)RuntimePlugin.Util.getString("SSLAwareChannelHandler.channel_closed"));
            listener.disconnected();
        }
    }

    public ChannelPipeline getPipeline() throws Exception {
        SSLEngine engine;
        DefaultChannelPipeline pipeline = new DefaultChannelPipeline();
        if (this.config != null && (engine = this.config.getServerSSLEngine()) != null) {
            pipeline.addLast("ssl", (ChannelHandler)new SslHandler(engine));
        }
        pipeline.addLast("decoder", (ChannelHandler)new ObjectDecoder(this.maxMessageSize, this.classLoader, this.storageManager));
        pipeline.addLast("chunker", (ChannelHandler)new ChunkedWriteHandler());
        pipeline.addLast("encoder", (ChannelHandler)new ObjectEncoder());
        pipeline.addLast("handler", (ChannelHandler)this);
        return pipeline;
    }

    public long getObjectsRead() {
        return this.objectsRead.get();
    }

    public long getObjectsWritten() {
        return this.objectsWritten.get();
    }

    public int getConnectedChannels() {
        return this.listeners.size();
    }

    public int getMaxConnectedChannels() {
        return this.maxChannels;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public class ObjectChannelImpl
    implements ObjectChannel {
        private final Channel channel;

        public ObjectChannelImpl(Channel channel) {
            this.channel = channel;
        }

        public void close() {
            this.channel.close();
        }

        public boolean isOpen() {
            return this.channel.isOpen();
        }

        public SocketAddress getRemoteAddress() {
            return this.channel.getRemoteAddress();
        }

        public InetAddress getLocalAddress() {
            throw new UnsupportedOperationException();
        }

        public Object read() throws IOException, ClassNotFoundException {
            throw new UnsupportedOperationException();
        }

        public Future<?> write(Object msg) {
            final ChannelFuture future = this.channel.write(msg);
            future.addListener(SSLAwareChannelHandler.this.completionListener);
            return new Future<Void>(){

                @Override
                public boolean cancel(boolean arg0) {
                    return future.cancel();
                }

                @Override
                public Void get() throws InterruptedException, ExecutionException {
                    future.await();
                    if (!future.isSuccess()) {
                        throw new ExecutionException(future.getCause());
                    }
                    return null;
                }

                @Override
                public Void get(long arg0, TimeUnit arg1) throws InterruptedException, ExecutionException, TimeoutException {
                    if (future.await(arg0, arg1)) {
                        if (!future.isSuccess()) {
                            throw new ExecutionException(future.getCause());
                        }
                        return null;
                    }
                    throw new TimeoutException();
                }

                @Override
                public boolean isCancelled() {
                    return future.isCancelled();
                }

                @Override
                public boolean isDone() {
                    return future.isDone();
                }
            };
        }
    }
}

