/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.ArrayList;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.teiid.deployers.ExtendedPropertyMetadata;

public class TestExtendedPropertyMetadata {
    @Test
    public void testDefault() {
        ExtendedPropertyMetadata metadata = new ExtendedPropertyMetadata("x", "java.lang.String", "some-name", null);
        Assert.assertEquals((Object)"some-name", (Object)metadata.display());
        Assert.assertEquals(null, (Object)metadata.description());
        Assert.assertEquals((Object)false, (Object)metadata.advanced());
        Assert.assertEquals((Object)false, (Object)metadata.required());
        Assert.assertEquals((Object)false, (Object)metadata.masked());
        Assert.assertEquals((Object)false, (Object)metadata.readOnly());
    }

    @Test
    public void testFormatted() {
        ArrayList<String> allowed = new ArrayList<String>();
        allowed.add("get");
        allowed.add("post");
        ExtendedPropertyMetadata metadata = new ExtendedPropertyMetadata("x", "java.lang.String", "{$display:\"Is Immutable\",$description:\"True if the source never changes.\",$allowed:[\"get\",\"post\"], $required:\"true\",$advanced:\"true\"}", null);
        Assert.assertEquals((Object)"Is Immutable", (Object)metadata.display());
        Assert.assertEquals((Object)"True if the source never changes.", (Object)metadata.description());
        Assert.assertEquals((Object)true, (Object)metadata.advanced());
        Assert.assertEquals((Object)true, (Object)metadata.required());
        Assert.assertEquals((Object)false, (Object)metadata.masked());
        Assert.assertEquals((Object)false, (Object)metadata.readOnly());
        Assert.assertEquals(allowed, Arrays.asList(metadata.allowed()));
    }

    @Test
    public void testFormattedExtraCommasAndColons() {
        ArrayList<String> allowed = new ArrayList<String>();
        allowed.add("get");
        allowed.add("post");
        ExtendedPropertyMetadata metadata = new ExtendedPropertyMetadata("x", "java.lang.String", "{$display:\"Is Immu:table\",$description:\"True if the, source never changes.\",$allowed:[\"get\",\"post\"], $required:\"true\",$advanced:\"true\"}", null);
        Assert.assertEquals((Object)"Is Immu:table", (Object)metadata.display());
        Assert.assertEquals((Object)"True if the, source never changes.", (Object)metadata.description());
        Assert.assertEquals((Object)true, (Object)metadata.advanced());
        Assert.assertEquals((Object)true, (Object)metadata.required());
        Assert.assertEquals((Object)false, (Object)metadata.masked());
        Assert.assertEquals((Object)false, (Object)metadata.readOnly());
        Assert.assertEquals(allowed, Arrays.asList(metadata.allowed()));
    }

    @Test
    public void testBlankProperties() {
        ArrayList<String> allowed = new ArrayList<String>();
        allowed.add("get");
        allowed.add("post");
        ExtendedPropertyMetadata metadata = new ExtendedPropertyMetadata("x", "java.lang.String", "{$display:\"Is Immutable\",$description:\"\",$allowed:[\"get\",\"post\"], $required:\"true\",$advanced:\"true\"}", null);
        Assert.assertEquals((Object)"Is Immutable", (Object)metadata.display());
        Assert.assertEquals((Object)"", (Object)metadata.description());
        Assert.assertEquals((Object)true, (Object)metadata.advanced());
        Assert.assertEquals((Object)true, (Object)metadata.required());
        Assert.assertEquals((Object)false, (Object)metadata.masked());
        Assert.assertEquals((Object)false, (Object)metadata.readOnly());
        Assert.assertEquals(allowed, Arrays.asList(metadata.allowed()));
    }
}

