/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.odbc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ietf.jgss.GSSCredential;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.RequestMessage;
import org.teiid.client.security.LogonException;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.ApplicationInfo;
import org.teiid.core.util.StringUtil;
import org.teiid.dqp.service.SessionService;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.ParameterMetaDataImpl;
import org.teiid.jdbc.PreparedStatementImpl;
import org.teiid.jdbc.ResultSetImpl;
import org.teiid.jdbc.StatementImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.net.socket.SocketServerConnection;
import org.teiid.odbc.ODBCClientRemote;
import org.teiid.odbc.ODBCServerRemote;
import org.teiid.odbc.PGUtil;
import org.teiid.odbc.ScriptReader;
import org.teiid.query.parser.SQLParserUtil;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.security.GSSResult;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.LogonImpl;
import org.teiid.transport.ODBCClientInstance;
import org.teiid.transport.PgFrontendProtocol;

public class ODBCServerRemoteImpl
implements ODBCServerRemote {
    public static final String CONNECTION_PROPERTY_PREFIX = "connection.";
    private static final String UNNAMED = "";
    private static Pattern setPattern = Pattern.compile("set\\s+(\\w+)\\s+to\\s+((?:'[^']*')+)", 34);
    private static Pattern pkPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, tc.relname from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class tc, pg_catalog.pg_index i, pg_catalog.pg_namespace n, pg_catalog.pg_class ic where tc.relname = (E?(?:'[^']*')+) AND n.nspname = (E?(?:'[^']*')+).*", 34);
    private static Pattern pkKeyPattern = Pattern.compile("select ta.attname, ia.attnum, ic.relname, n.nspname, NULL from pg_catalog.pg_attribute ta, pg_catalog.pg_attribute ia, pg_catalog.pg_class ic, pg_catalog.pg_index i, pg_catalog.pg_namespace n where ic.relname = (E?(?:'[^']*')+) AND n.nspname = (E?(?:'[^']*')+) .*", 34);
    private Pattern fkPattern = Pattern.compile("select\\s+((?:'[^']*')+)::name as PKTABLE_CAT,\\s+n2.nspname as PKTABLE_SCHEM,\\s+c2.relname as PKTABLE_NAME,\\s+a2.attname as PKCOLUMN_NAME,\\s+((?:'[^']*')+)::name as FKTABLE_CAT,\\s+n1.nspname as FKTABLE_SCHEM,\\s+c1.relname as FKTABLE_NAME,\\s+a1.attname as FKCOLUMN_NAME,\\s+i::int2 as KEY_SEQ,\\s+case ref.confupdtype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as UPDATE_RULE,\\s+case ref.confdeltype\\s+when 'c' then (\\d)::int2\\s+when 'n' then (\\d)::int2\\s+when 'd' then (\\d)::int2\\s+when 'r' then (\\d)::int2\\s+else 3::int2\\s+end as DELETE_RULE,\\s+ref.conname as FK_NAME,\\s+cn.conname as PK_NAME,\\s+case\\s+when ref.condeferrable then\\s+case\\s+when ref.condeferred then (\\d)::int2\\s+else (\\d)::int2\\s+end\\s+else (\\d)::int2\\s+end as DEFERRABLITY\\s+from\\s+\\(\\(\\(\\(\\(\\(\\( \\(select cn.oid, conrelid, conkey, confrelid, confkey,\\s+generate_series\\(array_lower\\(conkey, 1\\), array_upper\\(conkey, 1\\)\\) as i,\\s+confupdtype, confdeltype, conname,\\s+condeferrable, condeferred\\s+from pg_catalog.pg_constraint cn,\\s+pg_catalog.pg_class c,\\s+pg_catalog.pg_namespace n\\s+where contype = 'f'\\s+and\\s+con(f?)relid = c.oid\\s+and\\s+relname = (E?(?:'[^']*')+)\\s+and\\s+n.oid = c.relnamespace\\s+and\\s+n.nspname = (E?(?:'[^']*')+)\\s+\\) ref\\s+inner join pg_catalog.pg_class c1\\s+on c1.oid = ref.conrelid\\)\\s+inner join pg_catalog.pg_namespace n1\\s+on\\s+n1.oid = c1.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a1\\s+on\\s+a1.attrelid = c1.oid\\s+and\\s+a1.attnum = conkey\\[i\\]\\)\\s+inner join pg_catalog.pg_class c2\\s+on\\s+c2.oid = ref.confrelid\\)\\s+inner join pg_catalog.pg_namespace n2\\s+on\\s+n2.oid = c2.relnamespace\\)\\s+inner join pg_catalog.pg_attribute a2\\s+on\\s+a2.attrelid = c2.oid\\s+and\\s+a2.attnum = confkey\\[i\\]\\)\\s+left outer join pg_catalog.pg_constraint cn\\s+on cn.conrelid = ref.confrelid\\s+and cn.contype = 'p'\\)\\s+order by ref.oid, ref.i", 34);
    private static Pattern cursorSelectPattern = Pattern.compile("DECLARE\\s+\"(\\w+)\"(?:\\s+INSENSITIVE)?(\\s+(NO\\s+)?SCROLL)?\\s+CURSOR\\s+(?:WITH(?:OUT)? HOLD\\s+)?FOR\\s+(.*)", 34);
    private static Pattern fetchPattern = Pattern.compile("FETCH(?:\\s+FORWARD)?\\s+(\\d+)\\s+(?:IN|FROM)\\s+\"(\\w+)\"\\s*", 34);
    private static Pattern movePattern = Pattern.compile("MOVE(?:\\s+(FORWARD|BACKWARD))?\\s+(\\d+)\\s+(?:IN|FROM)\\s+\"(\\w+)\"\\s*", 34);
    private static Pattern closePattern = Pattern.compile("CLOSE \"(\\w+)\"", 34);
    private static Pattern deallocatePattern = Pattern.compile("DEALLOCATE(?:\\s+PREPARE)?\\s+(.*)", 34);
    private static Pattern releasePattern = Pattern.compile("RELEASE (\\w+\\d?_*)", 34);
    private static Pattern savepointPattern = Pattern.compile("SAVEPOINT (\\w+\\d?_*)", 34);
    private static Pattern rollbackPattern = Pattern.compile("ROLLBACK\\s+(to)?\\s+(\\w+\\d+_*)", 34);
    private TeiidDriver driver;
    private ODBCClientRemote client;
    private Properties props;
    private ConnectionImpl connection;
    private boolean executing;
    private boolean errorOccurred;
    private volatile ResultsFuture<Boolean> executionFuture;
    private Map<String, Prepared> preparedMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Portal> portalMap = Collections.synchronizedMap(new HashMap());
    private Map<String, Cursor> cursorMap = Collections.synchronizedMap(new HashMap());
    private LogonImpl logon;

    public ODBCServerRemoteImpl(ODBCClientInstance client, TeiidDriver driver, LogonImpl logon) {
        this.driver = driver;
        this.client = client.getClient();
        this.logon = logon;
    }

    @Override
    public void initialize(Properties props) {
        this.props = props;
        this.client.initialized(this.props);
        String user = props.getProperty("user");
        String database = props.getProperty("database");
        AuthenticationType authType = null;
        try {
            authType = this.getAuthenticationType(user, database);
        }
        catch (LogonException e) {
            this.errorOccurred(e);
            this.terminate();
            return;
        }
        if (authType.equals((Object)AuthenticationType.USERPASSWORD)) {
            this.client.useClearTextAuthentication();
        } else if (authType.equals((Object)AuthenticationType.GSS)) {
            this.client.useAuthenticationGSS();
        } else {
            throw new AssertionError((Object)"Unsupported Authentication Type");
        }
    }

    private AuthenticationType getAuthenticationType(String user, String database) throws LogonException {
        SessionService ss = this.logon.getSessionService();
        if (ss == null) {
            return AuthenticationType.USERPASSWORD;
        }
        return ss.getAuthenticationType(database, null, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void logon(String databaseName, String user, PgFrontendProtocol.NullTerminatedStringDataInputStream data, SocketAddress remoteAddress) {
        try {
            Properties info = new Properties();
            info.put("user", user);
            AuthenticationType authType = this.getAuthenticationType(user, databaseName);
            String password = null;
            if (authType.equals((Object)AuthenticationType.USERPASSWORD)) {
                password = data.readString();
            } else {
                if (!authType.equals((Object)AuthenticationType.GSS)) throw new AssertionError((Object)"Unsupported Authentication Type");
                byte[] serviceToken = data.readServiceToken();
                GSSResult result = this.logon.neogitiateGssLogin(serviceToken, databaseName, null, user);
                serviceToken = result.getServiceToken();
                if (result.isAuthenticated()) {
                    info.put("KRB5TOKEN", serviceToken);
                    if (!result.isNullContinuationToken()) {
                        this.client.authenticationGSSContinue(serviceToken);
                    }
                    if (result.getDelegationCredential() != null) {
                        info.put(GSSCredential.class.getName(), result.getDelegationCredential());
                    }
                } else {
                    this.client.authenticationGSSContinue(serviceToken);
                    return;
                }
            }
            String url = "jdbc:teiid:" + databaseName + ";ApplicationName=ODBC";
            if (password != null) {
                info.put("password", password);
            }
            if (remoteAddress instanceof InetSocketAddress) {
                SocketServerConnection.updateConnectionProperties((Properties)info, (InetAddress)((InetSocketAddress)remoteAddress).getAddress(), (boolean)false);
            }
            this.connection = this.driver.connect(url, info);
            SessionMetadata sm = ((LocalServerConnection)this.connection.getServerConnection()).getWorkContext().getSession();
            sm.addAttchment(ODBCServerRemoteImpl.class, (Object)this);
            ODBCServerRemoteImpl.setConnectionProperties(this.connection);
            int hash = this.connection.getConnectionId().hashCode();
            Enumeration<?> keys = this.props.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.connection.setExecutionProperty(key, this.props.getProperty(key));
            }
            try (StatementImpl s = this.connection.createStatement();){
                s.execute("select teiid_session_set('resolve_groupby_positional', true)");
            }
            this.client.authenticationSucess(hash, hash);
            this.ready();
            return;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
            this.terminate();
            return;
        }
        catch (LogonException e) {
            this.errorOccurred(e);
            this.terminate();
            return;
        }
        catch (IOException e) {
            this.errorOccurred(e);
            this.terminate();
        }
    }

    public static void setConnectionProperties(ConnectionImpl conn) throws SQLException {
        SessionMetadata sm = ((LocalServerConnection)conn.getServerConnection()).getWorkContext().getSession();
        VDBMetaData vdb = sm.getVdb();
        Properties p = vdb.getProperties();
        ODBCServerRemoteImpl.setConnectionProperties(conn, p);
    }

    public static void setConnectionProperties(ConnectionImpl conn, Properties p) {
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            String key = (String)entry.getKey();
            if (!key.startsWith(CONNECTION_PROPERTY_PREFIX)) continue;
            conn.setExecutionProperty(key.substring(CONNECTION_PROPERTY_PREFIX.length()), (String)entry.getValue());
        }
    }

    private void cursorExecute(String cursorName, final String sql, final ResultsFuture<Integer> completion, boolean scroll) {
        try {
            Cursor cursor;
            this.preparedMap.remove(UNNAMED);
            Portal p = this.portalMap.remove(UNNAMED);
            if (p != null) {
                this.closePortal(p);
            }
            if (cursorName == null || cursorName.length() == 0) {
                cursorName = UNNAMED;
            }
            if ((cursor = this.cursorMap.get(cursorName)) != null) {
                this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40111, new Object[]{cursorName}));
                return;
            }
            final PreparedStatementImpl stmt = this.connection.prepareStatement(sql, scroll ? 1004 : 1003, 1007);
            this.executionFuture = stmt.submitExecute(RequestMessage.ResultsMode.RESULTSET, null);
            final String name = cursorName;
            this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                public void onCompletion(ResultsFuture<Boolean> future) {
                    ODBCServerRemoteImpl.this.executionFuture = null;
                    try {
                        if (((Boolean)future.get()).booleanValue()) {
                            List cols = ODBCServerRemoteImpl.this.getPgColInfo(stmt.getResultSet().getMetaData());
                            ODBCServerRemoteImpl.this.cursorMap.put(name, new Cursor(name, sql, stmt, stmt.getResultSet(), cols));
                            ODBCServerRemoteImpl.this.client.sendCommandComplete("DECLARE CURSOR", null);
                            completion.getResultsReceiver().receiveResults((Object)0);
                        }
                    }
                    catch (Throwable e) {
                        completion.getResultsReceiver().exceptionOccurred(e);
                    }
                }
            });
        }
        catch (SQLException e) {
            completion.getResultsReceiver().exceptionOccurred((Throwable)e);
        }
    }

    private void cursorFetch(String cursorName, int rows, ResultsFuture<Integer> completion) throws SQLException {
        Cursor cursor = this.cursorMap.get(cursorName);
        if (cursor == null) {
            throw new SQLException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40078, new Object[]{cursorName}));
        }
        if (rows < 1) {
            throw new SQLException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40112, new Object[]{cursorName, rows}));
        }
        this.client.sendResults("FETCH", cursor.rs, cursor.prepared.columnMetadata, completion, rows, true);
    }

    private void cursorMove(String prepareName, String direction, final int rows, final ResultsFuture<Integer> completion) throws SQLException {
        if (rows == 0) {
            this.client.sendCommandComplete("MOVE", 0);
            completion.getResultsReceiver().receiveResults((Object)0);
            return;
        }
        final Cursor cursor = this.cursorMap.get(prepareName);
        if (cursor == null) {
            throw new SQLException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40078, new Object[]{prepareName}));
        }
        final boolean forward = direction == null || direction.equalsIgnoreCase("forward");
        Runnable r = new Runnable(){

            @Override
            public void run() {
                this.run(null, 0);
            }

            public void run(ResultsFuture<Boolean> next, int i) {
                while (i < rows) {
                    try {
                        if (next == null) {
                            next = forward ? cursor.rs.submitNext() : StatementImpl.booleanFuture((boolean)cursor.rs.previous());
                        }
                        if (!next.isDone()) {
                            final int current = i;
                            next.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                                public void onCompletion(ResultsFuture<Boolean> future) {
                                    this.run(future, current);
                                }
                            });
                            return;
                        }
                        if (!((Boolean)next.get()).booleanValue()) break;
                        next = null;
                    }
                    catch (Throwable e) {
                        completion.getResultsReceiver().exceptionOccurred(e);
                        return;
                    }
                    ++i;
                }
                if (!completion.isDone()) {
                    ODBCServerRemoteImpl.this.client.sendCommandComplete("MOVE", i);
                    completion.getResultsReceiver().receiveResults((Object)i);
                }
            }
        };
        r.run();
    }

    private void cursorClose(String prepareName) throws SQLException {
        Cursor cursor = this.cursorMap.remove(prepareName);
        if (cursor != null) {
            this.closePortal(cursor);
            this.client.sendCommandComplete("CLOSE CURSOR", null);
        }
    }

    private void sqlExecute(final String sql, final ResultsFuture<Integer> completion) throws SQLException {
        String modfiedSQL = this.fixSQL(sql);
        final StatementImpl stmt = this.connection.createStatement();
        this.executionFuture = stmt.submitExecute(modfiedSQL, null);
        completion.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

            public void onCompletion(ResultsFuture<Integer> future) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {
                    LogManager.logDetail((String)"org.teiid.ODBC", (Object)e, (Object)"Error closing statement");
                }
            }
        });
        this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

            public void onCompletion(ResultsFuture<Boolean> future) {
                block4: {
                    ODBCServerRemoteImpl.this.executionFuture = null;
                    try {
                        if (((Boolean)future.get()).booleanValue()) {
                            List cols = ODBCServerRemoteImpl.this.getPgColInfo(stmt.getResultSet().getMetaData());
                            ODBCServerRemoteImpl.this.client.sendResults(sql, stmt.getResultSet(), cols, (ResultsFuture<Integer>)completion, -1, true);
                        } else {
                            ODBCServerRemoteImpl.this.client.sendUpdateCount(sql, stmt.getUpdateCount());
                            ODBCServerRemoteImpl.this.setEncoding();
                            completion.getResultsReceiver().receiveResults((Object)1);
                        }
                    }
                    catch (Throwable e) {
                        if (completion.isDone()) break block4;
                        completion.getResultsReceiver().exceptionOccurred(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void prepare(String prepareName, String sql, int[] paramType) {
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if (sql != null) {
            PreparedStatementImpl stmt = null;
            try {
                if (prepareName.equals(UNNAMED)) {
                    this.preparedMap.remove(prepareName);
                } else {
                    Prepared previous = this.preparedMap.get(prepareName);
                    if (previous != null) {
                        this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40110, new Object[]{prepareName}));
                        return;
                    }
                }
                String modfiedSQL = this.fixSQL(sql);
                stmt = this.connection.prepareStatement(modfiedSQL);
                if (paramType.length > 0) {
                    ParameterMetaDataImpl pmd = stmt.getParameterMetaData();
                    for (int i = 0; i < paramType.length; ++i) {
                        if (paramType[i] != 0) continue;
                    }
                }
                Prepared prepared = new Prepared(prepareName, sql, modfiedSQL, paramType, this.getPgColInfo(stmt.getMetaData()));
                this.preparedMap.put(prepareName, prepared);
                this.client.prepareCompleted(prepareName);
            }
            catch (SQLException e) {
                if (e.getCause() instanceof TeiidProcessingException) {
                    LogManager.logWarning((String)"org.teiid.ODBC", (Throwable)e.getCause(), (Object)RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40020, new Object[0]));
                }
                this.errorOccurred(e);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (SQLException e) {}
            }
        }
    }

    private long readLong(byte[] bytes, int length) {
        long val = 0L;
        for (int k = 0; k < length; ++k) {
            val += (long)((bytes[k] & 0xFF) << (length - k - 1) * 8);
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindParameters(String bindName, String prepareName, Object[] params, int resultCodeCount, int[] resultColumnFormat) {
        Prepared prepared;
        if (bindName == null || bindName.length() == 0) {
            Portal p = this.portalMap.remove(UNNAMED);
            if (p != null) {
                this.closePortal(p);
            }
            bindName = UNNAMED;
        } else if (this.portalMap.get(bindName) != null || this.cursorMap.get(bindName) != null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40111, new Object[]{bindName}));
            return;
        }
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((prepared = this.preparedMap.get(prepareName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40077, new Object[]{prepareName}));
            return;
        }
        PreparedStatementImpl stmt = null;
        try {
            stmt = this.connection.prepareStatement(prepared.modifiedSql);
            for (int i = 0; i < params.length; ++i) {
                Object param = params[i];
                if (param instanceof byte[] && prepared.paramType.length > i) {
                    int oid = prepared.paramType[i];
                    switch (oid) {
                        case 0: {
                            break;
                        }
                        case 17: {
                            break;
                        }
                        case 21: {
                            param = (short)this.readLong((byte[])param, 2);
                            break;
                        }
                        case 23: {
                            param = (int)this.readLong((byte[])param, 4);
                            break;
                        }
                        case 20: {
                            param = this.readLong((byte[])param, 8);
                            break;
                        }
                        case 700: {
                            param = Float.valueOf(Float.intBitsToFloat((int)this.readLong((byte[])param, 4)));
                            break;
                        }
                        case 701: {
                            param = Double.longBitsToDouble(this.readLong((byte[])param, 8));
                        }
                    }
                }
                stmt.setObject(i + 1, param);
            }
            this.portalMap.put(bindName, new Portal(bindName, prepared, resultColumnFormat, stmt));
            this.client.bindComplete();
            stmt = null;
        }
        catch (SQLException e) {
            this.errorOccurred(e);
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException e) {}
            }
        }
    }

    @Override
    public void unsupportedOperation(String msg) {
        this.errorOccurred(msg);
    }

    @Override
    public void execute(String bindName, int maxRows) {
        Cursor cursor;
        if (this.beginExecution()) {
            this.errorOccurred("Awaiting asynch result");
            return;
        }
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if (maxRows == 0) {
            maxRows = -1;
        }
        if ((cursor = this.cursorMap.get(bindName)) != null) {
            this.sendCursorResults(cursor, maxRows);
            return;
        }
        Portal query = this.portalMap.get(bindName);
        if (query == null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40078, new Object[]{bindName}));
            return;
        }
        if (query.prepared.sql.trim().isEmpty()) {
            this.client.emptyQueryReceived();
            return;
        }
        this.sendPortalResults(maxRows, query);
    }

    private void sendPortalResults(final int maxRows, final Portal query) {
        if (query.rs != null) {
            this.sendCursorResults(query, maxRows);
            return;
        }
        final PreparedStatementImpl stmt = query.stmt;
        try {
            this.executionFuture = stmt.submitExecute(RequestMessage.ResultsMode.EITHER, null);
            this.executionFuture.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Boolean>(){

                public void onCompletion(ResultsFuture<Boolean> future) {
                    ODBCServerRemoteImpl.this.executionFuture = null;
                    try {
                        if (((Boolean)future.get()).booleanValue()) {
                            query.rs = stmt.getResultSet();
                            ODBCServerRemoteImpl.this.sendCursorResults(query, maxRows);
                        } else {
                            ODBCServerRemoteImpl.this.client.sendUpdateCount(query.prepared.sql, stmt.getUpdateCount());
                            ODBCServerRemoteImpl.this.setEncoding();
                            ODBCServerRemoteImpl.this.doneExecuting();
                        }
                    }
                    catch (ExecutionException e) {
                        if (e.getCause() != null) {
                            ODBCServerRemoteImpl.this.errorOccurred(e.getCause());
                        } else {
                            ODBCServerRemoteImpl.this.errorOccurred(e);
                        }
                    }
                    catch (Throwable e) {
                        ODBCServerRemoteImpl.this.errorOccurred(e);
                    }
                }
            });
        }
        catch (SQLException e) {
            this.errorOccurred(e);
        }
    }

    private void sendCursorResults(final Portal cursor, final int fetchSize) {
        ResultsFuture result = new ResultsFuture();
        this.client.sendResults(null, cursor.rs, cursor.prepared.columnMetadata, (ResultsFuture<Integer>)result, fetchSize, false);
        result.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

            public void onCompletion(ResultsFuture<Integer> future) {
                try {
                    int rowsSent = (Integer)future.get();
                    if (rowsSent < fetchSize || fetchSize <= 0) {
                        ODBCServerRemoteImpl.this.client.sendCommandComplete(cursor.prepared.sql, rowsSent);
                    } else {
                        ODBCServerRemoteImpl.this.client.sendPortalSuspended();
                    }
                    ODBCServerRemoteImpl.this.doneExecuting();
                }
                catch (InterruptedException e) {
                    throw new AssertionError((Object)e);
                }
                catch (ExecutionException e) {
                    ODBCServerRemoteImpl.this.errorOccurred(e.getCause());
                }
            }
        });
    }

    private String fixSQL(String sql) {
        String modified = this.modifySQL(sql);
        if (modified != null && !modified.equals(sql)) {
            LogManager.logDetail((String)"org.teiid.ODBC", (Object)"Modified Query:", (Object)modified);
        }
        return modified;
    }

    private String modifySQL(String sql) {
        String modified = sql;
        if (sql == null) {
            return null;
        }
        Matcher m = null;
        if (StringUtil.startsWithIgnoreCase((String)sql, (String)"select")) {
            m = pkPattern.matcher(modified);
            if (m.matches()) {
                return new StringBuffer("SELECT k.Name AS attname, convert(Position, short) AS attnum, TableName AS relname, SchemaName AS nspname, TableName AS relname").append(" FROM SYS.KeyColumns k").append(" WHERE ").append(" UCASE(SchemaName)").append(" LIKE UCASE(").append(m.group(2)).append(")").append(" AND UCASE(TableName)").append(" LIKE UCASE(").append(m.group(1)).append(")").append(" AND KeyType LIKE 'Primary'").append(" ORDER BY attnum").toString();
            }
            m = pkKeyPattern.matcher(modified);
            if (m.matches()) {
                String tableName = m.group(1);
                if (tableName.endsWith("_pkey'")) {
                    tableName = tableName.substring(0, tableName.length() - 6) + '\'';
                    return "select ia.attname, ia.attnum, ic.relname, n.nspname, NULL from pg_catalog.pg_attribute ia, pg_catalog.pg_class ic, pg_catalog.pg_namespace n, Sys.KeyColumns kc where ic.relname = " + tableName + " AND n.nspname = " + m.group(2) + " AND " + "n.oid = ic.relnamespace AND ia.attrelid = ic.oid AND kc.SchemaName = n.nspname " + "AND kc.TableName = ic.relname AND kc.KeyType = 'Primary' AND kc.Name = ia.attname order by ia.attnum";
                }
                return "SELECT NULL, NULL, NULL, NULL, NULL FROM (SELECT 1) as X WHERE 0=1";
            }
            m = this.fkPattern.matcher(modified);
            if (m.matches()) {
                String baseQuery = "SELECT PKTABLE_CAT, PKTABLE_SCHEM, PKTABLE_NAME, PKCOLUMN_NAME, FKTABLE_CAT, FKTABLE_SCHEM, FKTABLE_NAME, FKCOLUMN_NAME, KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME, DEFERRABILITY FROM SYS.ReferenceKeyColumns WHERE  ";
                if ("f".equals(m.group(14))) {
                    return baseQuery + "PKTABLE_NAME = " + m.group(15) + " and PKTABLE_SCHEM = " + m.group(16);
                }
                return baseQuery + "FKTABLE_NAME = " + m.group(15) + " and FKTABLE_SCHEM = " + m.group(16);
            }
            if (modified.equalsIgnoreCase("select version()")) {
                return "SELECT 'Teiid " + ApplicationInfo.getInstance().getReleaseNumber() + "'";
            }
            if (modified.startsWith("SELECT name FROM master..sysdatabases")) {
                return "SELECT 'Teiid'";
            }
            if (modified.equalsIgnoreCase("select db_name() dbname")) {
                return "SELECT current_database()";
            }
            if (sql.equalsIgnoreCase("select current_schema()")) {
                return "SELECT ''";
            }
            if (sql.equals("SELECT typinput='array_in'::regproc, typtype FROM pg_catalog.pg_type WHERE typname = $1")) {
                return "SELECT substring(typname,1,1) = '_', typtype FROM pg_catalog.pg_type WHERE typname = ?";
            }
        } else {
            if (sql.equalsIgnoreCase("show max_identifier_length")) {
                return "select 63";
            }
            m = setPattern.matcher(sql);
            if (m.matches()) {
                return "SET " + m.group(1) + " " + m.group(2);
            }
            if (modified.equalsIgnoreCase("BEGIN")) {
                return "START TRANSACTION";
            }
            m = rollbackPattern.matcher(modified);
            if (m.matches()) {
                return "ROLLBACK";
            }
            m = savepointPattern.matcher(sql);
            if (m.matches()) {
                return "SELECT 0";
            }
            m = releasePattern.matcher(sql);
            if (m.matches()) {
                return "SELECT 0";
            }
        }
        for (int i = 0; i < modified.length(); ++i) {
            switch (modified.charAt(i)) {
                case ':': 
                case '~': {
                    ScriptReader reader = new ScriptReader(modified);
                    reader.setRewrite(true);
                    try {
                        return reader.readStatement();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
        }
        return modified;
    }

    @Override
    public void executeQuery(String query) {
        if (this.beginExecution()) {
            this.errorOccurred("Awaiting asynch result");
            this.ready();
            return;
        }
        Portal p = this.portalMap.remove(UNNAMED);
        if (p != null) {
            this.closePortal(p);
        }
        this.preparedMap.remove(UNNAMED);
        query = query.trim();
        if (query.length() == 0) {
            this.client.emptyQueryReceived();
            this.ready();
        }
        QueryWorkItem r = new QueryWorkItem(query);
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean beginExecution() {
        if (this.executionFuture != null) {
            return true;
        }
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.executing = true;
        }
        return false;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isErrorOccurred() {
        return this.errorOccurred;
    }

    @Override
    public void getParameterDescription(String prepareName) {
        Prepared query;
        if (prepareName == null || prepareName.length() == 0) {
            prepareName = UNNAMED;
        }
        if ((query = this.preparedMap.get(prepareName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40079, new Object[]{prepareName}));
            return;
        }
        this.client.sendParameterDescription(query.paramType);
        this.client.sendResultSetDescription(query.columnMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void errorOccurred(String error) {
        this.client.errorOccurred(error);
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = true;
            this.doneExecuting();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void errorOccurred(Throwable error) {
        this.client.errorOccurred(error);
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = true;
            this.doneExecuting();
        }
    }

    @Override
    public void getResultSetMetaDataDescription(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.get(bindName)) == null) {
            this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40078, new Object[]{bindName}));
        } else {
            this.client.sendResultSetDescription(query.prepared.columnMetadata);
        }
    }

    @Override
    public void sync() {
        this.ready();
    }

    protected synchronized void doneExecuting() {
        this.executing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ready() {
        boolean inTxn = false;
        boolean failedTxn = false;
        try {
            if (!this.connection.getAutoCommit()) {
                inTxn = true;
            }
        }
        catch (SQLException e) {
            failedTxn = true;
        }
        ODBCServerRemoteImpl oDBCServerRemoteImpl = this;
        synchronized (oDBCServerRemoteImpl) {
            this.errorOccurred = false;
        }
        this.client.ready(inTxn, failedTxn);
    }

    @Override
    public void cancel() {
    }

    @Override
    public void closeBoundStatement(String bindName) {
        Portal query;
        if (bindName == null || bindName.length() == 0) {
            bindName = UNNAMED;
        }
        if ((query = this.portalMap.remove(bindName)) != null) {
            this.closePortal(query);
        }
        this.client.statementClosed();
    }

    private void closePortal(Portal query) {
        ResultSetImpl rs = query.rs;
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException e) {
                LogManager.logDetail((String)"org.teiid.ODBC", (Object)e, (Object)"Did not successfully close portal", (Object)query.name);
            }
            query.rs = null;
        }
        try {
            query.stmt.close();
        }
        catch (SQLException e) {
            LogManager.logDetail((String)"org.teiid.ODBC", (Object)e, (Object)"Did not successfully close portal", (Object)query.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closePreparedStatement(String preparedName) {
        Prepared query;
        if (preparedName == null || preparedName.length() == 0) {
            preparedName = UNNAMED;
        }
        if ((query = this.preparedMap.remove(preparedName)) != null) {
            Map<String, Portal> map = this.portalMap;
            synchronized (map) {
                Iterator<Portal> iter = this.portalMap.values().iterator();
                while (iter.hasNext()) {
                    Portal p = iter.next();
                    if (p.prepared.name.equals(preparedName)) {
                        iter.remove();
                    }
                    this.closePortal(p);
                }
            }
        }
        this.client.statementClosed();
    }

    @Override
    public void terminate() {
        for (Portal p : this.portalMap.values()) {
            this.closePortal(p);
        }
        this.portalMap.clear();
        this.preparedMap.clear();
        try {
            if (this.connection != null) {
                if (!this.connection.getAutoCommit()) {
                    this.connection.rollback(false);
                }
                this.connection.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this.client.terminated();
    }

    @Override
    public void flush() {
        this.client.flush();
    }

    @Override
    public void functionCall(int oid) {
        this.errorOccurred(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40081, new Object[0]));
    }

    @Override
    public void sslRequest() {
        this.client.sendSslResponse();
    }

    private void setEncoding() {
        String encoding = this.getEncoding();
        if (encoding != null) {
            this.client.setEncoding(encoding, false);
        }
    }

    public String getEncoding() {
        return this.connection.getExecutionProperty("client_encoding");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<PGUtil.PgColInfo> getPgColInfo(ResultSetMetaData meta) throws SQLException {
        if (meta == null) {
            return null;
        }
        int columns = meta.getColumnCount();
        ArrayList<PGUtil.PgColInfo> result = new ArrayList<PGUtil.PgColInfo>(columns);
        for (int i = 1; i <= columns; ++i) {
            PGUtil.PgColInfo info = new PGUtil.PgColInfo();
            info.name = meta.getColumnLabel(i);
            info.type = meta.getColumnType(i);
            info.type = PGUtil.convertType(info.type);
            info.precision = meta.getColumnDisplaySize(i);
            info.mod = info.type == 1700 ? (int)Math.min(Integer.MAX_VALUE, 4L + 65536L * (long)meta.getPrecision(i) + (long)meta.getScale(i)) : (info.type == 1042 || info.type == 1043 ? (int)Math.min(Integer.MAX_VALUE, 4L + (long)meta.getColumnDisplaySize(i)) : -1);
            String name = meta.getColumnName(i);
            String table = meta.getTableName(i);
            String schema = meta.getSchemaName(i);
            if (schema != null) {
                try (PreparedStatementImpl ps = this.connection.prepareStatement("select pg_catalog.getOid(SYS.Columns.TableUID), cast(SYS.Columns.Position as short), cast((select p.value from SYS.Properties p where p.name = 'pg_type:oid' and p.uid = SYS.Columns.uid) as integer) from SYS.Columns where Name = ? and TableName = ? and SchemaName = ?");){
                    ps.setString(1, name);
                    ps.setString(2, table);
                    ps.setString(3, schema);
                    ResultSetImpl rs = ps.executeQuery();
                    if (rs.next()) {
                        info.reloid = rs.getInt(1);
                        info.attnum = rs.getShort(2);
                        int specificType = rs.getInt(3);
                        if (!rs.wasNull()) {
                            info.type = specificType;
                        }
                    }
                }
            }
            result.add(info);
        }
        return result;
    }

    static class Cursor
    extends Portal {
        public Cursor(String name, String sql, PreparedStatementImpl stmt, ResultSetImpl rs, List<PGUtil.PgColInfo> colMetadata) {
            super(name, new Prepared(ODBCServerRemoteImpl.UNNAMED, sql, sql, null, colMetadata), null, stmt);
            this.rs = rs;
        }
    }

    static class Portal {
        final String name;
        final int[] resultColumnFormat;
        final Prepared prepared;
        volatile ResultSetImpl rs;
        final PreparedStatementImpl stmt;

        public Portal(String name, Prepared prepared, int[] resultColumnformat, PreparedStatementImpl stmt) {
            this.name = name;
            this.prepared = prepared;
            this.resultColumnFormat = resultColumnformat;
            this.stmt = stmt;
        }
    }

    static class Prepared {
        final String name;
        final String sql;
        final String modifiedSql;
        final int[] paramType;
        final List<PGUtil.PgColInfo> columnMetadata;

        public Prepared(String name, String sql, String modifiedSql, int[] paramType, List<PGUtil.PgColInfo> columnMetadata) {
            this.name = name;
            this.sql = sql;
            this.modifiedSql = modifiedSql;
            this.paramType = paramType;
            this.columnMetadata = columnMetadata;
        }
    }

    private final class QueryWorkItem
    implements Runnable {
        private final ScriptReader reader;
        String sql;

        private QueryWorkItem(String query) {
            this.reader = new ScriptReader(query);
        }

        private void done(Throwable error) {
            if (error != null) {
                ODBCServerRemoteImpl.this.errorOccurred(error);
            } else {
                ODBCServerRemoteImpl.this.doneExecuting();
            }
            ODBCServerRemoteImpl.this.ready();
        }

        @Override
        public void run() {
            block18: {
                try {
                    if (this.sql == null) {
                        this.sql = this.reader.readStatement();
                    }
                    if (this.sql == null) break block18;
                    try {
                        ResultsFuture results = new ResultsFuture();
                        results.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<Integer>(){

                            public void onCompletion(ResultsFuture<Integer> future) {
                                try {
                                    future.get();
                                    QueryWorkItem.this.sql = QueryWorkItem.this.reader.readStatement();
                                }
                                catch (InterruptedException e) {
                                    throw new AssertionError((Object)e);
                                }
                                catch (IOException e) {
                                    QueryWorkItem.this.done(e);
                                    return;
                                }
                                catch (ExecutionException e) {
                                    Throwable cause;
                                    for (cause = e; cause instanceof ExecutionException && cause.getCause() != null && cause != cause.getCause(); cause = cause.getCause()) {
                                    }
                                    QueryWorkItem.this.done(cause);
                                    return;
                                }
                                QueryWorkItem.this.run();
                            }
                        });
                        if (ODBCServerRemoteImpl.this.isErrorOccurred()) {
                            if (!ODBCServerRemoteImpl.this.connection.getAutoCommit()) {
                                ODBCServerRemoteImpl.this.connection.rollback(false);
                            }
                            break block18;
                        }
                        Matcher m = null;
                        m = cursorSelectPattern.matcher(this.sql);
                        if (m.matches()) {
                            boolean scroll = false;
                            if (m.group(2) != null && m.group(3) == null) {
                                scroll = true;
                            }
                            ODBCServerRemoteImpl.this.cursorExecute(m.group(1), ODBCServerRemoteImpl.this.fixSQL(m.group(4)), (ResultsFuture<Integer>)results, scroll);
                        } else {
                            m = fetchPattern.matcher(this.sql);
                            if (m.matches()) {
                                ODBCServerRemoteImpl.this.cursorFetch(m.group(2), Integer.parseInt(m.group(1)), (ResultsFuture<Integer>)results);
                            } else {
                                m = movePattern.matcher(this.sql);
                                if (m.matches()) {
                                    ODBCServerRemoteImpl.this.cursorMove(m.group(3), m.group(1), Integer.parseInt(m.group(2)), (ResultsFuture<Integer>)results);
                                } else {
                                    m = closePattern.matcher(this.sql);
                                    if (m.matches()) {
                                        ODBCServerRemoteImpl.this.cursorClose(m.group(1));
                                        results.getResultsReceiver().receiveResults((Object)1);
                                    } else {
                                        m = deallocatePattern.matcher(this.sql);
                                        if (m.matches()) {
                                            String plan_name = m.group(1);
                                            plan_name = SQLParserUtil.normalizeId((String)plan_name);
                                            ODBCServerRemoteImpl.this.closePreparedStatement(plan_name);
                                            ODBCServerRemoteImpl.this.client.sendCommandComplete("DEALLOCATE", null);
                                            results.getResultsReceiver().receiveResults((Object)1);
                                        } else {
                                            ODBCServerRemoteImpl.this.sqlExecute(this.sql, (ResultsFuture<Integer>)results);
                                        }
                                    }
                                }
                            }
                        }
                        return;
                    }
                    catch (SQLException e) {
                        this.done(e);
                        return;
                    }
                }
                catch (IOException e) {
                    this.done(e);
                    return;
                }
            }
            this.done(null);
        }
    }
}

