/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.resource.spi.XATerminator;
import javax.resource.spi.work.WorkManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.postgresql.Driver;
import org.teiid.CommandContext;
import org.teiid.PreParser;
import org.teiid.adminapi.Model;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.common.queue.FakeWorkManager;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.SimpleMock;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.language.Command;
import org.teiid.language.LanguageObject;
import org.teiid.language.Literal;
import org.teiid.language.QueryExpression;
import org.teiid.language.visitor.CollectorVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.ColumnSet;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.HardCodedExecutionFactory;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.ResultSetExecution;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorBatchException;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.UpdateExecution;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;
import org.teiid.transport.SocketListener;
import org.teiid.transport.WireProtocol;

public class TestEmbeddedServer {
    EmbeddedServer es;
    public static boolean started;
    public static boolean isES1started;
    public static boolean isES2started;

    @Before
    public void setup() {
        this.es = new EmbeddedServer();
    }

    @After
    public void teardown() {
        if (this.es != null) {
            this.es.stop();
        }
    }

    @Test
    public void testDeploy() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("y", (ExecutionFactory)new FakeTranslator(false));
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        this.es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMapping("x", "y", "z");
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" OPTIONS (UPDATABLE 'true') as select * from \"my-table\"");
        this.es.deployVDB("test", new ModelMetaData[]{mmd, mmd1});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from \"my-view\"");
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"my-column", (Object)rs.getMetaData().getColumnLabel(1));
        s.execute("update \"my-view\" set \"my-column\" = 'a'");
        Assert.assertEquals((long)2L, (long)s.getUpdateCount());
        this.es.deployVDB("empty", new ModelMetaData[0]);
        c = this.es.getDriver().connect("jdbc:teiid:empty", null);
        s = c.createStatement();
        s.execute("select * from tables");
        Assert.assertNotNull((Object)this.es.getSchemaDdl("empty", "SYS"));
        Assert.assertNull((Object)this.es.getSchemaDdl("empty", "xxx"));
    }

    @Test
    public void testBatchedUpdate() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.bufferService.setProcessorBatchSize(1);
        this.es.start(ec);
        this.es.addTranslator("y", (ExecutionFactory)new FakeTranslator(true));
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        this.es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMapping("x", "y", "z");
        this.es.deployVDB("test", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        PreparedStatement ps = c.prepareStatement("insert into \"my-table\" values (?)");
        for (int i = 0; i < 16; ++i) {
            ps.setString(1, "a");
            ps.addBatch();
        }
        int[] result = ps.executeBatch();
        Assert.assertArrayEquals((int[])new int[]{1, 1, -1, 1, 1, 1, -1, 1, 1, 1, -1, 1, 1, 1, -1, 1}, (int[])result);
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testInvalidName() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt.1");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" as select 1");
        this.es.deployVDB("x", new ModelMetaData[]{mmd1});
    }

    @Test
    public void testDeployZip() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        File f = UnitTestUtil.getTestScratchFile((String)"some.vdb");
        ZipOutputStream out = new ZipOutputStream(new FileOutputStream(f));
        out.putNextEntry(new ZipEntry("v1.ddl"));
        out.write("CREATE VIEW helloworld as SELECT 'HELLO WORLD';".getBytes("UTF-8"));
        out.putNextEntry(new ZipEntry("META-INF/vdb.xml"));
        out.write("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL-FILE\">/v1.ddl</metadata></model></vdb>".getBytes("UTF-8"));
        out.close();
        this.es.deployVDBZip(f.toURI().toURL());
        ResultSet rs = this.es.getDriver().connect("jdbc:teiid:test", null).createStatement().executeQuery("select * from helloworld");
        rs.next();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
    }

    @Test
    public void testDeployDesignerZip() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDBZip(UnitTestUtil.getTestDataFile((String)"matviews.vdb").toURI().toURL());
        ResultSet rs = this.es.getDriver().connect("jdbc:teiid:matviews", null).createStatement().executeQuery("select count(*) from tables where schemaname='test'");
        rs.next();
        Assert.assertEquals((long)4L, (long)rs.getInt(1));
    }

    @Test
    public void testXMLDeploy() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model></vdb>".getBytes()));
        ResultSet rs = this.es.getDriver().connect("jdbc:teiid:test", null).createStatement().executeQuery("select * from helloworld");
        rs.next();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
    }

    @Test
    public void testXMLDeployWithVDBImport() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model></vdb>".getBytes()));
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"importer\" version=\"1\"><import-vdb name=\"test\" version=\"1\"/></vdb>".getBytes()));
        ResultSet rs = this.es.getDriver().connect("jdbc:teiid:importer", null).createStatement().executeQuery("select * from helloworld");
        rs.next();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"importer1\" version=\"1\"><import-vdb name=\"importer\" version=\"1\"/></vdb>".getBytes()));
        rs = this.es.getDriver().connect("jdbc:teiid:importer1", null).createStatement().executeQuery("select * from helloworld");
        rs.next();
        Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteJDBCTrasport() throws Exception {
        SocketConfiguration s = new SocketConfiguration();
        InetSocketAddress addr = new InetSocketAddress(0);
        s.setBindAddress(addr.getHostName());
        s.setPortNumber(addr.getPort());
        s.setProtocol(WireProtocol.teiid);
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.addTransport(s);
        this.es.start(config);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model></vdb>".getBytes()));
        try (Connection conn = null;){
            TeiidDriver driver = new TeiidDriver();
            conn = driver.connect("jdbc:teiid:test@mm://" + addr.getHostName() + ":" + ((SocketListener)this.es.transports.get(0)).getPort(), null);
            conn.createStatement().execute("set showplan on");
            ResultSet rs = conn.createStatement().executeQuery("select * from helloworld");
            rs.next();
            Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
        }
    }

    @Test(expected=TeiidRuntimeException.class)
    public void testRemoteTrasportSSLFail() throws Exception {
        SocketConfiguration s = new SocketConfiguration();
        InetSocketAddress addr = new InetSocketAddress(0);
        s.setBindAddress(addr.getHostName());
        s.setPortNumber(addr.getPort());
        s.setProtocol(WireProtocol.teiid);
        SSLConfiguration sslConfiguration = new SSLConfiguration();
        sslConfiguration.setSslProtocol("x");
        sslConfiguration.setMode("enabled");
        s.setSSLConfiguration(sslConfiguration);
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.addTransport(s);
        this.es.start(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRemoteODBCTrasport() throws Exception {
        SocketConfiguration s = new SocketConfiguration();
        InetSocketAddress addr = new InetSocketAddress(0);
        s.setBindAddress(addr.getHostName());
        s.setPortNumber(addr.getPort());
        s.setProtocol(WireProtocol.pg);
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        config.addTransport(s);
        this.es.start(config);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model></vdb>".getBytes()));
        try (Connection conn = null;){
            Driver d = new Driver();
            Properties p = new Properties();
            p.setProperty("user", "testuser");
            p.setProperty("password", "testpassword");
            conn = d.connect("jdbc:postgresql://" + addr.getHostName() + ":" + ((SocketListener)this.es.transports.get(0)).getPort() + "/test", p);
            ResultSet rs = conn.createStatement().executeQuery("select * from helloworld");
            rs.next();
            Assert.assertEquals((Object)"HELLO WORLD", (Object)rs.getString(1));
        }
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testXMLDeployFails() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE VIEW helloworld as SELECT 'HELLO WORLD';]]> </metadata></model><translator name=\"foo\" type=\"h2\"></translator></vdb>".getBytes()));
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testXMLDeployFails1() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\"><source/></model><translator name=\"foo\" type=\"h2\"></translator></vdb>".getBytes()));
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testDeploymentError() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view \"my-view\" OPTIONS (UPDATABLE 'true') as select * from \"my-table\"");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1});
    }

    @Test
    public void testValidationOrder() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v as select 1");
        ModelMetaData mmd2 = new ModelMetaData();
        mmd2.setName("a");
        mmd2.setModelType(Model.Type.VIRTUAL);
        mmd2.setSchemaSourceType("ddl");
        mmd2.setSchemaText("create view v1 as select * from v");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1, mmd2});
        try {
            this.es.deployVDB("test2", new ModelMetaData[]{mmd2, mmd1});
            Assert.fail();
        }
        catch (VirtualDatabaseException virtualDatabaseException) {
            // empty catch block
        }
    }

    @Test
    public void testTransactions() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v as select 1; create virtual procedure proc () options (updatecount 2) as begin select * from v; end; create virtual procedure proc1 () as begin atomic select * from v; end; create virtual procedure proc2 (x integer) as begin atomic select 1; begin select 1/x; end exception e end; create virtual procedure proc3 (x integer) as begin begin atomic select 1; end create local temporary table x (y string); begin atomic select 1; end end;");
        this.es.deployVDB("test", new ModelMetaData[]{mmd1});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        s.execute("select 1");
        c.setAutoCommit(true);
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        Transaction txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("call proc ()");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("call proc1()");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).commit();
        s.execute("set autoCommitTxn on");
        s.execute("set noexec on");
        s.execute("select 1");
        Assert.assertFalse((boolean)s.getResultSet().next());
        s.execute("set autoCommitTxn off");
        s.execute("set noexec off");
        s.execute("call proc2(0)");
        Assert.assertEquals((long)1L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn)).rollback();
        tm.txnHistory.clear();
        tm.begin();
        try {
            c.setAutoCommit(false);
            s.execute("select 1");
            Assert.fail((String)"should fail since we aren't allowing a nested transaction");
        }
        catch (TeiidSQLException teiidSQLException) {
            // empty catch block
        }
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn, (VerificationMode)Mockito.times((int)0))).commit();
        tm.commit();
        c.setAutoCommit(true);
        tm.txnHistory.clear();
        s.execute("call proc3(0)");
        Assert.assertEquals((long)2L, (long)tm.txnHistory.size());
        txn = tm.txnHistory.remove(0);
        ((Transaction)Mockito.verify((Object)txn, (VerificationMode)Mockito.times((int)0))).registerSynchronization((Synchronization)Mockito.any());
    }

    @Test
    public void testMultiSourcePreparedDynamicUpdate() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", new ExecutionFactory());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v (i integer) OPTIONS (UPDATABLE true) as select 1; create trigger on v instead of update as for each row begin atomic IF (CHANGING.i)\nEXECUTE IMMEDIATE 'select \"new\".i'; end; ");
        mmd1.setSupportsMultiSourceBindings(true);
        mmd1.addSourceMapping("x", "t", null);
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("update v set i = ? where i = ?");
        ps.setInt(1, 2);
        ps.setInt(2, 1);
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
        ps.setInt(1, 3);
        ps.setInt(2, 1);
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
    }

    @Test
    public void testGeneratedKeysVirtual() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", new ExecutionFactory());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.addSourceMetadata("ddl", "create view v (i integer, k integer auto_increment) OPTIONS (UPDATABLE true) as select 1, 2; create trigger on v instead of insert as for each row begin atomic \ncreate local temporary table x (y serial, z integer, primary key (y));\ninsert into x (z) values (1);end; ");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("insert into v (i) values (1)", 1);
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
        ResultSet rs = ps.getGeneratedKeys();
        Assert.assertFalse((boolean)rs.next());
    }

    @Test
    public void testGeneratedKeysTemp() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.addSourceMetadata("ddl", "create view v as select 1");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        Statement s = c.createStatement();
        s.execute("create temporary table t (x serial, y string, primary key (x))");
        PreparedStatement ps = c.prepareStatement("insert into t (y) values ('a')", 1);
        Assert.assertFalse((boolean)ps.execute());
        Assert.assertEquals((long)1L, (long)ps.getUpdateCount());
        ResultSet rs = ps.getGeneratedKeys();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        Assert.assertEquals((long)11L, (long)rs.getMetaData().getColumnDisplaySize(1));
    }

    @Test
    public void testMultiSourceMetadata() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", new ExecutionFactory());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create foreign table t (x string)");
        mmd1.setSupportsMultiSourceBindings(true);
        mmd1.addSourceMapping("x", "t", null);
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("select * from t");
        ResultSetMetaData metadata = ps.getMetaData();
        Assert.assertEquals((long)1L, (long)metadata.getColumnCount());
        mmd1.addProperty("multisource.addColumn", Boolean.TRUE.toString());
        this.es.undeployVDB("vdb");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        ps = c.prepareStatement("select * from t");
        metadata = ps.getMetaData();
        Assert.assertEquals((long)2L, (long)metadata.getColumnCount());
        mmd1.addProperty("multisource.columnName", "y");
        this.es.undeployVDB("vdb");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        ps = c.prepareStatement("select * from t");
        metadata = ps.getMetaData();
        Assert.assertEquals((long)2L, (long)metadata.getColumnCount());
        Assert.assertEquals((Object)"y", (Object)metadata.getColumnName(2));
    }

    @Test
    public void testMultiSourceMetadataMissingSource() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", (ExecutionFactory)new ExecutionFactory<Object, Object>(){

            public Object getConnection(Object factory) throws TranslatorException {
                return factory;
            }

            public void closeConnection(Object connection, Object factory) {
            }

            public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
                Assert.assertNotNull((Object)conn);
                Table t = metadataFactory.addTable("x");
                metadataFactory.addColumn("a", "string", (ColumnSet)t);
            }
        });
        this.es.addConnectionFactory("b", new Object());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setSupportsMultiSourceBindings(true);
        mmd1.addSourceMapping("x", "t", "a");
        mmd1.addSourceMapping("y", "t", "b");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
    }

    @Test
    public void testDynamicUpdate() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", (ExecutionFactory)new ExecutionFactory<Void, Void>(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public boolean isSourceRequired() {
                return false;
            }

            public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Void connection) throws TranslatorException {
                Collection values = CollectorVisitor.collectObjects(Literal.class, (LanguageObject)command);
                Assert.assertEquals((long)2L, (long)values.size());
                for (Literal literal : values) {
                    Assert.assertFalse((boolean)(literal.getValue() instanceof Reference));
                }
                return new UpdateExecution(){

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                        return new int[]{1};
                    }
                };
            }
        });
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("accounts");
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText(ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"dynamic_update.sql")));
        mmd1.addSourceMapping("y", "t", null);
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("update hello1 set SchemaName=? where Name=?");
        ps.setString(1, "test1223");
        ps.setString(2, "Columns");
        Assert.assertEquals((long)1L, (long)ps.executeUpdate());
    }

    @Test
    public void testStart() throws TranslatorException {
        this.es.addTranslator(MyEF.class);
        Assert.assertTrue((boolean)started);
    }

    @Test
    public void testGlobalTempTables() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setMaxResultSetCacheStaleness(0);
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE global temporary table some_temp (col1 string, col2 time) options (updatable true);]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        PreparedStatement ps = c.prepareStatement("/*+ cache */ select * from some_temp");
        ResultSet rs = ps.executeQuery();
        Assert.assertFalse((boolean)rs.next());
        ConnectionImpl c1 = this.es.getDriver().connect("jdbc:teiid:test", null);
        c1.createStatement().execute("insert into some_temp (col1) values ('a')");
        PreparedStatement ps1 = c1.prepareStatement("/*+ cache */ select * from some_temp");
        ResultSet rs1 = ps1.executeQuery();
        Assert.assertTrue((boolean)rs1.next());
        rs = ps.executeQuery();
        Assert.assertFalse((boolean)rs.next());
        c.createStatement().execute("insert into some_temp (col1) values ('b')");
        rs = ps.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        rs = c.createStatement().executeQuery("select * from some_temp");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"b", (Object)rs.getString(1));
        rs = c1.createStatement().executeQuery("select * from some_temp");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)rs.getString(1));
    }

    @Test
    public void testMaxRows() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setMaxResultSetCacheStaleness(0);
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\" type=\"VIRTUAL\"><metadata type=\"DDL\"><![CDATA[CREATE virtual procedure proc (out col1 string result) returns TABLE (r1 string) as begin col1 = 'a'; select 'b' union all select 'c'; end;]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        CallableStatement cs = c.prepareCall("{? = call proc()}");
        ResultSet rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs.setMaxRows(1);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs.setMaxRows(1);
        cs.setFetchSize(1);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs = c.prepareCall("/*+ cache */ {? = call proc()}");
        cs.setMaxRows(1);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs.setMaxRows(0);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
        cs.setMaxRows(1);
        rs = cs.executeQuery();
        Assert.assertTrue((boolean)rs.next());
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"a", (Object)cs.getString(1));
    }

    @Test
    public void testSourceLobUnderTxn() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setMaxResultSetCacheStaleness(0);
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        final AtomicBoolean closed = new AtomicBoolean();
        this.es.addTranslator("foo", new ExecutionFactory(){

            public boolean isSourceRequired() {
                return false;
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                return new ResultSetExecution(){
                    private boolean returned;

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                        closed.set(true);
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        if (this.returned) {
                            return null;
                        }
                        this.returned = true;
                        ArrayList<SQLXMLImpl> result = new ArrayList<SQLXMLImpl>(1);
                        result.add(new SQLXMLImpl(new InputStreamFactory(){

                            public InputStream getInputStream() throws IOException {
                                return new ByteArrayInputStream(new byte[DataTypeManager.MAX_LOB_MEMORY_BYTES + 1]);
                            }
                        }));
                        return result;
                    }
                };
            }
        });
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\"><source name=\"foo\" translator-name=\"foo\"/><metadata type=\"DDL\"><![CDATA[CREATE foreign table x (y xml);]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        c.setAutoCommit(false);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from x");
        rs.next();
        Assert.assertFalse((boolean)closed.get());
        s.close();
        Assert.assertTrue((boolean)closed.get());
    }

    @Test
    public void testUndeploy() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model type=\"VIRTUAL\" name=\"test\"><metadata type=\"DDL\"><![CDATA[CREATE view x as select 1;]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        Assert.assertTrue((boolean)c.isValid(10));
        this.es.undeployVDB("test");
        Assert.assertTrue((!c.isValid(10) ? 1 : 0) != 0);
    }

    @Test
    public void testQueryTimeout() throws Exception {
        this.es.start(new EmbeddedConfiguration());
        this.es.addTranslator("foo", new ExecutionFactory(){

            public boolean isSourceRequired() {
                return false;
            }

            public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return super.createResultSetExecution(command, executionContext, metadata, connection);
            }
        });
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"test\" version=\"1\"><model name=\"test\"><source name=\"foo\" translator-name=\"foo\"/><metadata type=\"DDL\"><![CDATA[CREATE foreign table x (y xml);]]> </metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        s.setQueryTimeout(1);
        try {
            s.execute("select * from x");
            Assert.fail();
        }
        catch (SQLException e) {
            Assert.assertEquals((Object)"57014", (Object)e.getSQLState());
        }
    }

    @Test
    public void testMultipleEmbeddedServerInOneVM() throws TranslatorException {
        this.es.addTranslator(MyEFES1.class);
        this.es.start(new EmbeddedConfiguration());
        Assert.assertTrue((boolean)isES1started);
        EmbeddedServer es2 = new EmbeddedServer();
        es2.start(new EmbeddedConfiguration());
        es2.addTranslator(MyEFES2.class);
        Assert.assertTrue((boolean)isES2started);
        es2.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExternalMaterializationManagement() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        ec.setTransactionManager((TransactionManager)SimpleMock.createSimpleMock(TransactionManager.class));
        this.es.transactionService.setXaTerminator((XATerminator)SimpleMock.createSimpleMock(XATerminator.class));
        this.es.transactionService.setWorkManager((WorkManager)new FakeWorkManager());
        this.es.start(ec);
        this.es.transactionService.setDetectTransactions(false);
        final AtomicBoolean loaded = new AtomicBoolean();
        final AtomicBoolean valid = new AtomicBoolean();
        final AtomicInteger matTableCount = new AtomicInteger();
        final AtomicInteger tableCount = new AtomicInteger();
        final AtomicBoolean hasStatus = new AtomicBoolean();
        this.es.addTranslator("y", (ExecutionFactory)new ExecutionFactory<AtomicInteger, Object>(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public Object getConnection(AtomicInteger factory) throws TranslatorException {
                return factory.incrementAndGet();
            }

            public void closeConnection(Object connection, AtomicInteger factory) {
            }

            public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
                Assert.assertEquals((Object)conn, (Object)1);
                Table t = metadataFactory.addTable("my_table");
                t.setSupportsUpdate(true);
                Column c = metadataFactory.addColumn("my_column", "string", (ColumnSet)t);
                c.setUpdatable(true);
                t = metadataFactory.addTable("mat_table");
                t.setSupportsUpdate(true);
                c = metadataFactory.addColumn("my_column", "string", (ColumnSet)t);
                c.setUpdatable(true);
                t = metadataFactory.addTable("status");
                t.setSupportsUpdate(true);
                c = metadataFactory.addColumn("VDBName", "string", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("VDBVersion", "string", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("SchemaName", "string", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("Name", "string", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("TargetSchemaName", "string", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("TargetName", "string", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("Valid", "boolean", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("LoadState", "string", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("Cardinality", "long", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("Updated", "timestamp", (ColumnSet)t);
                c.setUpdatable(true);
                c = metadataFactory.addColumn("LoadNumber", "long", (ColumnSet)t);
                c.setUpdatable(true);
                metadataFactory.addPrimaryKey("PK", Arrays.asList("VDBName", "VDBVersion", "SchemaName", "Name"), t);
            }

            public ResultSetExecution createResultSetExecution(final QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                return new ResultSetExecution(){
                    Iterator<? extends List<? extends Object>> results;

                    public void execute() throws TranslatorException {
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public List<?> next() throws TranslatorException, DataNotAvailableException {
                        String status = "SELECT status.TargetSchemaName, status.TargetName, status.Valid, status.LoadState, status.Updated, status.Cardinality, status.LoadNumber FROM status WHERE status.VDBName = 'test' AND status.VDBVersion = '1.0.0' AND status.SchemaName = 'virt' AND status.Name = 'my_view'";
                        if (this.results == null) {
                            String commandString = command.toString();
                            if (hasStatus.get() && commandString.equals(status)) {
                                this.results = Arrays.asList(Arrays.asList(null, "mat_table", valid.get(), loaded.get() ? "LOADED" : "LOADING", new Timestamp(System.currentTimeMillis()), -1, new Integer(1))).iterator();
                            } else if (hasStatus.get() && commandString.startsWith("SELECT status.Valid, status.LoadState FROM status")) {
                                this.results = Arrays.asList(Arrays.asList(valid.get(), loaded.get() ? "LOADED" : "LOADING")).iterator();
                            } else if (loaded.get() && commandString.equals("SELECT mat_table.my_column FROM mat_table")) {
                                matTableCount.getAndIncrement();
                                this.results = Arrays.asList(Arrays.asList("mat_column0"), Arrays.asList("mat_column1")).iterator();
                            } else if (commandString.equals("SELECT my_table.my_column FROM my_table")) {
                                tableCount.getAndIncrement();
                                this.results = Arrays.asList(Arrays.asList("regular_column")).iterator();
                            }
                        }
                        if (this.results != null && this.results.hasNext()) {
                            return this.results.next();
                        }
                        return null;
                    }
                };
            }

            public UpdateExecution createUpdateExecution(final Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
                UpdateExecution ue = new UpdateExecution(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void execute() throws TranslatorException {
                        String commandString = command.toString();
                        if (commandString.startsWith("INSERT INTO status")) {
                            hasStatus.set(true);
                        }
                        if (commandString.startsWith("INSERT INTO status") || commandString.startsWith("UPDATE status SET")) {
                            if (commandString.contains("LoadState")) {
                                AtomicBoolean atomicBoolean = loaded;
                                synchronized (atomicBoolean) {
                                    loaded.set(commandString.indexOf("LOADED") != -1);
                                    loaded.notifyAll();
                                }
                            }
                            if (commandString.contains("Valid")) {
                                valid.set(commandString.indexOf("TRUE") != -1);
                            }
                        }
                    }

                    public void close() {
                    }

                    public void cancel() throws TranslatorException {
                    }

                    public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                        return new int[]{1};
                    }
                };
                return ue;
            }
        });
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        this.es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my_schema");
        mmd.addSourceMapping("x", "y", "z");
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("virt");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("\tcreate view my_view OPTIONS (UPDATABLE 'true',MATERIALIZED 'TRUE',\nMATERIALIZED_TABLE 'my_schema.mat_table', \n\"teiid_rel:MATERIALIZED_STAGE_TABLE\" 'my_schema.mat_table',\n\"teiid_rel:ALLOW_MATVIEW_MANAGEMENT\" 'true', \n\"teiid_rel:MATVIEW_STATUS_TABLE\" 'my_schema.status', \n\"teiid_rel:MATVIEW_AFTER_LOAD_SCRIPT\" 'select 1; select 1, ''a''', \n\"teiid_rel:MATVIEW_SHARE_SCOPE\" 'NONE',\n\"teiid_rel:MATVIEW_ONERROR_ACTION\" 'THROW_EXCEPTION',\n\"teiid_rel:MATVIEW_TTL\" 100000)as select * from \"my_table\"; create view mat_table as select 'I conflict';");
        this.es.deployVDB("test", new ModelMetaData[]{mmd, mmd1});
        AtomicBoolean atomicBoolean = loaded;
        synchronized (atomicBoolean) {
            while (!loaded.get()) {
                loaded.wait();
            }
        }
        Thread.sleep(2000L);
        final TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from my_view");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertEquals((Object)"mat_column0", (Object)rs.getString(1));
        s.execute("update my_schema.status set valid=false");
        try {
            rs = s.executeQuery("select * from my_view");
            Assert.fail((String)"expected throw exception to work");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)tableCount.get());
        rs = s.executeQuery("select * from (call sysadmin.updateMatView('virt', 'my_view', 'true')) as x");
        rs.next();
        Assert.assertEquals((long)2L, (long)rs.getInt(1));
        Assert.assertEquals((long)2L, (long)tableCount.get());
        s.execute("call setProperty((SELECT UID FROM Sys.Tables WHERE SchemaName = 'virt' AND Name = 'my_view'), 'teiid_rel:MATVIEW_ONERROR_ACTION', 'WAIT')");
        final AtomicBoolean success = new AtomicBoolean();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    ConnectionImpl c1 = td.connect("jdbc:teiid:test", null);
                    Statement s1 = c1.createStatement();
                    s1.executeQuery("select * from my_view");
                    success.set(true);
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        t.start();
        Thread.sleep(5000L);
        s.execute("update my_schema.status set valid=true");
        t.join(10000L);
        Assert.assertTrue((boolean)success.get());
    }

    @Test
    public void testPreparedTypeResolving() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator("t", new ExecutionFactory());
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v (i integer) as select 1");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        PreparedStatement ps = c.prepareStatement("select * from texttable(? columns a string) as x");
        ps.setCharacterStream(1, new StringReader("a\nb"));
        Assert.assertTrue((boolean)ps.execute());
    }

    @Test
    public void testGeometrySelect() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        ModelMetaData mmd1 = new ModelMetaData();
        mmd1.setName("b");
        mmd1.setModelType(Model.Type.VIRTUAL);
        mmd1.setSchemaSourceType("ddl");
        mmd1.setSchemaText("create view v (i geometry) as select ST_GeomFromText('POLYGON ((100 100, 200 200, 75 75, 100 100))')");
        this.es.deployVDB("vdb", new ModelMetaData[]{mmd1});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:vdb", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from v");
        Assert.assertEquals((Object)"geometry", (Object)rs.getMetaData().getColumnTypeName(1));
        Assert.assertEquals((long)2004L, (long)rs.getMetaData().getColumnType(1));
        Assert.assertEquals((Object)"java.sql.Blob", (Object)rs.getMetaData().getColumnClassName(1));
        rs.next();
        Assert.assertEquals((long)77L, (long)rs.getBlob(1).length());
    }

    @Test
    public void testPreParser() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setPreParser(new PreParser(){

            public String preParse(String command, CommandContext context) {
                if (command.equals("select 'hello world'")) {
                    return "select 'goodbye'";
                }
                return command;
            }
        });
        this.es.start(ec);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("y");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create view dummy as select 1;");
        this.es.deployVDB("x", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:x", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select 'hello world'");
        rs.next();
        Assert.assertEquals((Object)"goodbye", (Object)rs.getString(1));
    }

    @Test
    public void testTurnOffLobCleaning() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("y");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create view dummy as select 1;");
        this.es.deployVDB("x", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:x", null);
        Statement s = c.createStatement();
        s.execute("select teiid_session_set('clean_lobs_onclose', false)");
        ResultSet rs = s.executeQuery("WITH t(n) AS ( VALUES (1) UNION ALL SELECT n+1 FROM t WHERE n < 5000 ) SELECT xmlelement(root, xmlagg(xmlelement(val, n))) FROM t");
        Assert.assertTrue((boolean)rs.next());
        SQLXML val = rs.getSQLXML(1);
        rs.close();
        Assert.assertEquals((long)73906L, (long)val.getString().length());
    }

    @Test
    public void testBufferManagerProperties() throws TranslatorException {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(true);
        ec.setBufferDirectory(System.getProperty("java.io.tmpdir"));
        ec.setProcessorBatchSize(256);
        ec.setMaxReserveKb(-1);
        ec.setMaxProcessingKb(-1);
        ec.setInlineLobs(true);
        ec.setMaxOpenFiles(64);
        ec.setMaxBufferSpace(51200L);
        ec.setMaxFileSize(2048L);
        ec.setEncryptFiles(false);
        ec.setMaxStorageObjectSize(0x800000);
        ec.setMemoryBufferOffHeap(false);
        started = false;
        this.es.addTranslator(MyEF.class);
        this.es.start(ec);
        Assert.assertTrue((boolean)started);
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testRequireRoles() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.repo.setDataRolesRequired(true);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("y");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create view dummy as select 1;");
        this.es.deployVDB("x", new ModelMetaData[]{mmd});
    }

    @Test
    public void testSystemSubquery() throws Exception {
        String query = "SELECT t.Name FROM (select * from SYS.Tables AS t limit 10) as t, (SELECT DISTINCT c.TableName FROM SYS.Columns AS c where c.Name > 'A') AS X__1 WHERE t.Name = X__1.TableName";
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create view v as select 1 as c");
        this.es.deployVDB("x", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:x", null);
        Statement s = c.createStatement();
        this.extractRowCount(query, s, 10);
        query = "SELECT t.Name FROM (select * from SYS.Tables AS t limit 10) as t, (SELECT DISTINCT c.TableName FROM SYS.Columns AS c) AS X__1 WHERE t.Name = X__1.TableName";
        this.extractRowCount(query, s, 10);
    }

    private void extractRowCount(String query, Statement s, int count) throws SQLException {
        s.execute(query);
        ResultSet rs = s.getResultSet();
        int i = 0;
        while (rs.next()) {
            ++i;
        }
        Assert.assertEquals((long)count, (long)i);
    }

    @Test
    public void testTempVisibilityToExecuteImmediate() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create procedure p () as execute immediate 'select 1' as x integer into #temp;");
        this.es.deployVDB("x", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:x", null);
        Statement s = c.createStatement();
        s.execute("create local temporary table #temp (x integer)");
        s.execute("exec p()");
        this.extractRowCount("select * from #temp", s, 0);
    }

    @Test
    public void testSubqueryCache() throws Exception {
        String[] statements;
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"proc.sql")));
        this.es.deployVDB("x", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:x", null);
        Statement s = c.createStatement();
        for (String statement : statements = ObjectConverterUtil.convertFileToString((File)UnitTestUtil.getTestDataFile((String)"data.sql")).split(";")) {
            s.execute(statement);
        }
        s.execute("set autoCommitTxn off");
        s.execute("SELECT \"citmp.KoordX\" ,\"citmp.KoordY\" ,( SELECT \"store.insideFence\" FROM ( EXEC point_inside_store ( CAST ( \"citmp.KoordX\" AS float ) ,CAST ( \"citmp.KoordY\" AS float ) ) ) as \"store\" ) as \"insideStore\" ,( SELECT \"firstsection.insideFence\" FROM ( EXEC point_inside_store ( CAST ( \"citmp.KoordX\" AS float ) ,CAST ( \"citmp.KoordY\" AS float ) ) ) as \"firstsection\" ) as \"insideFirstsection\" FROM sample_coords as \"citmp\" ORDER BY insideStore ASC ,insideFirstsection DESC");
        ResultSet rs = s.getResultSet();
        while (rs.next()) {
            Assert.assertEquals((long)rs.getInt(3), (long)rs.getInt(4));
        }
    }

    @Test(expected=TeiidSQLException.class)
    public void testCancelSystemQuery() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create view v as select 1;");
        this.es.deployVDB("x", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:x", null);
        final Statement s = c.createStatement();
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(1000L);
                    s.cancel();
                }
                catch (InterruptedException interruptedException) {
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
            }
        };
        t.start();
        ResultSet rs = s.executeQuery("select count(*) from columns c, columns c1, columns c2, columns c3, columns c4");
        rs.next();
        Assert.fail();
    }

    @Test
    public void testSemanticVersioning() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("x");
        mmd.setModelType(Model.Type.VIRTUAL);
        mmd.addSourceMetadata("ddl", "create view v as select 1;");
        this.es.deployVDB("x.0.9.0", new ModelMetaData[]{mmd});
        this.es.deployVDB("x.1.0.1", new ModelMetaData[]{mmd});
        this.es.deployVDB("x.1.1.0", new ModelMetaData[]{mmd});
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:x", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("values (current_database())");
        rs.next();
        Assert.assertEquals((Object)"x", (Object)rs.getString(1));
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"0.9.0", (Object)rs.getString(1));
        try {
            c = this.es.getDriver().connect("jdbc:teiid:x.v1.0", null);
            Assert.fail();
        }
        catch (TeiidSQLException teiidSQLException) {
            // empty catch block
        }
        c = this.es.getDriver().connect("jdbc:teiid:x.1.0.1", null);
        s = c.createStatement();
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"1.0.1", (Object)rs.getString(1));
        try {
            c = this.es.getDriver().connect("jdbc:teiid:x.1", null);
            Assert.fail();
        }
        catch (TeiidSQLException teiidSQLException) {
            // empty catch block
        }
        c = this.es.getDriver().connect("jdbc:teiid:x.1.", null);
        s = c.createStatement();
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"1.0.1", (Object)rs.getString(1));
        c = this.es.getDriver().connect("jdbc:teiid:x.1.1.", null);
        s = c.createStatement();
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"1.1.0", (Object)rs.getString(1));
    }

    @Test
    public void testSemanticVersioningAny() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.deployVDB((InputStream)new ByteArrayInputStream(this.createVDB("x", "0.9").getBytes("UTF-8")));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:x", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("values (current_database())");
        rs.next();
        Assert.assertEquals((Object)"x", (Object)rs.getString(1));
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"0.9.0", (Object)rs.getString(1));
        this.es.deployVDB((InputStream)new ByteArrayInputStream(this.createVDB("x", "1.1.1").getBytes("UTF-8")));
        try {
            c = this.es.getDriver().connect("jdbc:teiid:x.1", null);
            Assert.fail();
        }
        catch (TeiidSQLException teiidSQLException) {
            // empty catch block
        }
        c = this.es.getDriver().connect("jdbc:teiid:x.1.", null);
        s = c.createStatement();
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"1.1.1", (Object)rs.getString(1));
        c = this.es.getDriver().connect("jdbc:teiid:x.1.1.", null);
        s = c.createStatement();
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"1.1.1", (Object)rs.getString(1));
        this.es.deployVDB((InputStream)new ByteArrayInputStream(this.createVDB("x", "1.11.1").getBytes("UTF-8")));
        this.es.deployVDB((InputStream)new ByteArrayInputStream(this.createVDB("x", "1.0.1").getBytes("UTF-8")));
        c = this.es.getDriver().connect("jdbc:teiid:x.1.1.", null);
        s = c.createStatement();
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"1.1.1", (Object)rs.getString(1));
        c = this.es.getDriver().connect("jdbc:teiid:x.1.0.", null);
        s = c.createStatement();
        rs = s.executeQuery("select version from virtualdatabases");
        rs.next();
        Assert.assertEquals((Object)"1.0.1", (Object)rs.getString(1));
        try {
            c = this.es.getDriver().connect("jdbc:teiid:x.1.12.0", null);
            Assert.fail();
        }
        catch (TeiidSQLException teiidSQLException) {
            // empty catch block
        }
    }

    private String createVDB(String name, String version) {
        return "<vdb name=\"" + name + "\" version=\"" + version + "\"><connection-type>ANY</connection-type><model name=\"x\" type=\"VIRTUAL\"><metadata type=\"ddl\">create view v as select 1</metadata></model></vdb>";
    }

    @Test
    public void testVirtualFunctions() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        this.es.start(ec);
        this.es.deployVDB((InputStream)new ByteArrayInputStream("<vdb name=\"ddlfunctions\" version=\"1\"><model visible=\"true\" type=\"VIRTUAL\" name=\"FunctionModel\">\t\t\t<metadata type=\"DDL\"><![CDATA[\t \t   CREATE VIRTUAL function f1(p1 integer) RETURNS integer as return p1; \t   CREATE VIEW TestView (c1 integer) AS SELECT f1(42) AS c1;\t      ]]></metadata></model></vdb>".getBytes()));
        ConnectionImpl c = this.es.getDriver().connect("jdbc:teiid:ddlfunctions", null);
        Statement s = c.createStatement();
        s.execute("select f1(1)");
        ResultSet rs = s.getResultSet();
        rs.next();
        Assert.assertEquals((long)1L, (long)rs.getInt(1));
        s.execute("select * from testview");
        rs = s.getResultSet();
        rs.next();
        Assert.assertEquals((long)42L, (long)rs.getInt(1));
    }

    @Test
    public void testWithPushdownChangeName() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        HardCodedExecutionFactory hcef = new HardCodedExecutionFactory(){

            public boolean supportsCommonTableExpressions() {
                return true;
            }

            public boolean supportsSelfJoins() {
                return true;
            }

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public boolean supportsAliasedTable() {
                return true;
            }

            public boolean isSourceRequired() {
                return false;
            }

            public String getExcludedCommonTableExpressionName() {
                return "a";
            }

            public boolean supportsInnerJoins() {
                return true;
            }
        };
        this.es.addTranslator("y", (ExecutionFactory)hcef);
        hcef.addData("WITH a__2 (x) AS (SELECT g_0.e1 FROM pm1.g1 AS g_0) SELECT g_0.x FROM a__2 AS g_0, a__2 AS g_1", Arrays.asList(Arrays.asList("a")));
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMapping("x", "y", null);
        mmd.addSourceMetadata("ddl", "create foreign table pm1.g1 (e1 string)");
        this.es.deployVDB("test", new ModelMetaData[]{mmd});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        s.execute("with a (x) as (select e1 from pm1.g1) SELECT a.x from a, a z");
    }

    @Test
    public void testBatchedUpdateErrors() throws Exception {
        int[] updateCounts;
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        MockTransactionManager tm = new MockTransactionManager();
        ec.setTransactionManager((TransactionManager)tm);
        HardCodedExecutionFactory hcef = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }
        };
        hcef.addUpdate("UPDATE pm1.g1 SET e1 = 'a' WHERE pm1.g1.e2 = 1", new int[]{1});
        hcef.addUpdate("UPDATE pm1.g1 SET e1 = 'b' WHERE pm1.g1.e2 = 2", new TranslatorException("i've failed"));
        this.es.addTranslator("y", (ExecutionFactory)hcef);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMapping("x", "y", null);
        mmd.addSourceMetadata("ddl", "create foreign table pm1.g1 (e1 string, e2 integer) options (updatable true)");
        this.es.deployVDB("test", new ModelMetaData[]{mmd});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        s.addBatch("update pm1.g1 set e1 = 'a' where e2 = 1");
        s.addBatch("update pm1.g1 set e1 = 'b' where e2 = 2");
        try {
            s.executeBatch();
            Assert.fail();
        }
        catch (BatchUpdateException e) {
            updateCounts = e.getUpdateCounts();
            Assert.assertArrayEquals((int[])new int[]{1, -3}, (int[])updateCounts);
            Assert.assertEquals((long)-1L, (long)s.getUpdateCount());
        }
        hcef = new HardCodedExecutionFactory(){

            public boolean supportsCompareCriteriaEquals() {
                return true;
            }

            public boolean supportsBatchedUpdates() {
                return true;
            }
        };
        this.es.addTranslator("z", (ExecutionFactory)hcef);
        this.es.undeployVDB("test");
        mmd = new ModelMetaData();
        mmd.setName("my-schema");
        mmd.addSourceMetadata("ddl", "create foreign table pm1.g1 (e1 string, e2 integer) options (updatable true)");
        mmd.addSourceMapping("y", "z", null);
        this.es.deployVDB("test", new ModelMetaData[]{mmd});
        c = td.connect("jdbc:teiid:test", null);
        s = c.createStatement();
        s.addBatch("update pm1.g1 set e1 = 'a' where e2 = 1");
        s.addBatch("update pm1.g1 set e1 = 'b' where e2 = 2");
        hcef.updateMap.clear();
        hcef.addUpdate("UPDATE pm1.g1 SET e1 = 'a' WHERE pm1.g1.e2 = 1;UPDATE pm1.g1 SET e1 = 'b' WHERE pm1.g1.e2 = 2;", (TranslatorException)new TranslatorBatchException((Throwable)new SQLException(), new int[]{1, -3}));
        try {
            s.executeBatch();
            Assert.fail();
        }
        catch (BatchUpdateException e) {
            updateCounts = e.getUpdateCounts();
            Assert.assertArrayEquals((int[])new int[]{1, -3}, (int[])updateCounts);
            Assert.assertEquals((long)-1L, (long)s.getUpdateCount());
        }
    }

    @Test
    public void testTranslatorCreation() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        this.es.start(ec);
        this.es.addTranslator(DummyExecutionFactory.class);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("supportsOrderBy", "true");
        this.es.addTranslator("dummy-override", "dummy", props);
        ModelMetaData mmd = new ModelMetaData();
        mmd.setName("test-one");
        mmd.addSourceMapping("one", "dummy", null);
        ModelMetaData mmd2 = new ModelMetaData();
        mmd2.setName("test-two");
        mmd2.addSourceMapping("two", "dummy", null);
        ModelMetaData mmd3 = new ModelMetaData();
        mmd3.setName("test-three");
        mmd3.addSourceMapping("three", "dummy-override", null);
        this.es.deployVDB("test", new ModelMetaData[]{mmd, mmd2, mmd3});
        TeiidDriver td = this.es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:test", null);
        Statement s = c.createStatement();
        s.execute("select count(distinct name) from sys.tables where name like 'test%'");
        s.getResultSet().next();
        Assert.assertEquals((long)3L, (long)s.getResultSet().getInt(1));
        s.execute("select count(distinct name) from sys.columns where tablename like 'test%'");
        s.getResultSet().next();
        Assert.assertEquals((long)2L, (long)s.getResultSet().getInt(1));
    }

    @Translator(name="dummy")
    public static class DummyExecutionFactory
    extends ExecutionFactory {
        static AtomicInteger INSTANCES = new AtomicInteger();
        int instance = INSTANCES.getAndIncrement();

        public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
            Table t = metadataFactory.addTable("test" + String.valueOf(this.instance));
            if (this.supportsOrderBy()) {
                metadataFactory.addColumn("y", "integer", (ColumnSet)t);
            } else {
                metadataFactory.addColumn("x", "integer", (ColumnSet)t);
            }
        }

        public boolean isSourceRequiredForMetadata() {
            return false;
        }
    }

    public static class MyEFES2
    extends ExecutionFactory<Void, Void> {
        public void start() throws TranslatorException {
            isES2started = true;
        }
    }

    public static class MyEFES1
    extends ExecutionFactory<Void, Void> {
        public void start() throws TranslatorException {
            isES1started = true;
        }
    }

    public static class MyEF
    extends ExecutionFactory<Void, Void> {
        public void start() throws TranslatorException {
            started = true;
        }
    }

    public static final class MockTransactionManager
    implements TransactionManager {
        ThreadLocal<Transaction> txns = new ThreadLocal();
        List<Transaction> txnHistory = new ArrayList<Transaction>();

        public Transaction suspend() throws SystemException {
            Transaction result = this.txns.get();
            this.txns.remove();
            return result;
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            Transaction result = this.txns.get();
            if (result == null) {
                throw new IllegalStateException();
            }
            result.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            Transaction t = this.checkNull(false);
            this.txns.remove();
            t.rollback();
        }

        public void resume(Transaction tobj) throws InvalidTransactionException, IllegalStateException, SystemException {
            this.checkNull(true);
            this.txns.set(tobj);
        }

        private Transaction checkNull(boolean isNull) {
            Transaction t = this.txns.get();
            if (!isNull && t == null || isNull && t != null) {
                throw new IllegalStateException();
            }
            return t;
        }

        public Transaction getTransaction() throws SystemException {
            return this.txns.get();
        }

        public int getStatus() throws SystemException {
            Transaction t = this.txns.get();
            if (t == null) {
                return 6;
            }
            return t.getStatus();
        }

        public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
            Transaction t = this.checkNull(false);
            this.txns.remove();
            t.commit();
        }

        public void begin() throws NotSupportedException, SystemException {
            this.checkNull(true);
            Transaction t = (Transaction)Mockito.mock(Transaction.class);
            this.txnHistory.add(t);
            this.txns.set(t);
        }

        public void reset() {
            this.txnHistory.clear();
            this.txns = new ThreadLocal();
        }
    }

    private static final class FakeTranslator
    extends ExecutionFactory<AtomicInteger, Object> {
        private boolean batch;

        public FakeTranslator(boolean batch) {
            this.batch = batch;
        }

        public Object getConnection(AtomicInteger factory) throws TranslatorException {
            return factory.incrementAndGet();
        }

        public void closeConnection(Object connection, AtomicInteger factory) {
        }

        public boolean supportsBulkUpdate() {
            return true;
        }

        public void getMetadata(MetadataFactory metadataFactory, Object conn) throws TranslatorException {
            Assert.assertEquals((Object)conn, (Object)1);
            Table t = metadataFactory.addTable("my-table");
            t.setSupportsUpdate(true);
            Column c = metadataFactory.addColumn("my-column", "string", (ColumnSet)t);
            c.setUpdatable(true);
        }

        public ResultSetExecution createResultSetExecution(QueryExpression command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
            ResultSetExecution rse = new ResultSetExecution(){

                public void execute() throws TranslatorException {
                }

                public void close() {
                }

                public void cancel() throws TranslatorException {
                }

                public List<?> next() throws TranslatorException, DataNotAvailableException {
                    return null;
                }
            };
            return rse;
        }

        public UpdateExecution createUpdateExecution(Command command, ExecutionContext executionContext, RuntimeMetadata metadata, Object connection) throws TranslatorException {
            UpdateExecution ue = new UpdateExecution(){

                public void execute() throws TranslatorException {
                }

                public void close() {
                }

                public void cancel() throws TranslatorException {
                }

                public int[] getUpdateCounts() throws DataNotAvailableException, TranslatorException {
                    if (!FakeTranslator.this.batch) {
                        return new int[]{2};
                    }
                    return new int[]{1, 1, -1, 1, 1, 1, -1, 1, 1, 1, -1, 1, 1, 1, -1, 1};
                }
            };
            return ue;
        }
    }
}

