/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.runtime;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.EnumSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.CacheStatistics;
import org.teiid.adminapi.EngineStatistics;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.Session;
import org.teiid.adminapi.Translator;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.WorkerPoolStatistics;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.impl.SourceMappingMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.runtime.EmbeddedAdminFactory;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.file.FileExecutionFactory;

public class TestEmbeddedServerAdmin {
    private static Admin admin;
    private static EmbeddedServer server;

    @BeforeClass
    public static void init() throws Exception {
        server = new EmbeddedServer();
        EmbeddedConfiguration config = new EmbeddedConfiguration();
        server.start(config);
        FileExecutionFactory executionFactory = new FileExecutionFactory();
        executionFactory.start();
        server.addTranslator("file", (ExecutionFactory)executionFactory);
        server.deployVDB((InputStream)new FileInputStream(new File("src/test/resources/adminapi-test-vdb.xml")));
        admin = EmbeddedAdminFactory.getInstance().createAdmin(server);
    }

    private Connection newSession() throws SQLException {
        return server.getDriver().connect("jdbc:teiid:AdminAPITestVDB", new Properties());
    }

    @Test
    public void testGetVdbs() throws AdminException {
        for (VDB vdb : admin.getVDBs()) {
            Assert.assertEquals((Object)vdb.getName(), (Object)"AdminAPITestVDB");
            Assert.assertEquals((Object)vdb.getVersion(), (Object)"1");
            Assert.assertEquals((Object)vdb.getDescription(), (Object)"The adminapi test VDB");
            Assert.assertEquals((long)vdb.getModels().size(), (long)1L);
        }
    }

    @Test
    public void testGetVDB() throws AdminException {
        VDB vdb = admin.getVDB("AdminAPITestVDB", 1);
        Assert.assertEquals((Object)vdb.getDescription(), (Object)"The adminapi test VDB");
        Assert.assertEquals((long)vdb.getModels().size(), (long)1L);
    }

    @Test
    public void testSource() throws AdminException {
        SourceMappingMetadata mapping;
        VDBMetaData vdbMetaData;
        admin.addSource("AdminAPITestVDB", 1, "TestModel", "text-connector-test", "file", "java:/test-file");
        for (VDB vdb : admin.getVDBs()) {
            vdbMetaData = (VDBMetaData)vdb;
            for (ModelMetaData m : vdbMetaData.getModelMetaDatas().values()) {
                mapping = m.getSourceMapping("text-connector-test");
                if (mapping == null) continue;
                Assert.assertEquals((Object)mapping.getConnectionJndiName(), (Object)"java:/test-file");
                Assert.assertEquals((Object)mapping.getTranslatorName(), (Object)"file");
            }
        }
        admin.updateSource("AdminAPITestVDB", 1, "text-connector-test", "mysql", "java:/test-jdbc");
        for (VDB vdb : admin.getVDBs()) {
            vdbMetaData = (VDBMetaData)vdb;
            for (ModelMetaData m : vdbMetaData.getModelMetaDatas().values()) {
                mapping = m.getSourceMapping("text-connector-test");
                if (mapping == null) continue;
                Assert.assertEquals((Object)mapping.getConnectionJndiName(), (Object)"java:/test-jdbc");
                Assert.assertEquals((Object)mapping.getTranslatorName(), (Object)"mysql");
            }
        }
        admin.removeSource("AdminAPITestVDB", 1, "TestModel", "text-connector-test");
    }

    @Test
    public void testChangeVDBConnectionType() throws AdminException {
        VDB.ConnectionType previous = admin.getVDB("AdminAPITestVDB", 1).getConnectionType();
        admin.changeVDBConnectionType("AdminAPITestVDB", 1, VDB.ConnectionType.ANY);
        Assert.assertEquals((Object)VDB.ConnectionType.ANY, (Object)admin.getVDB("AdminAPITestVDB", 1).getConnectionType());
        admin.changeVDBConnectionType("AdminAPITestVDB", 1, previous);
    }

    @Test
    public void testDeployUndeploy() throws AdminException, FileNotFoundException {
        admin.undeploy("AdminAPITestVDB");
        Assert.assertNull((Object)admin.getVDB("AdminAPITestVDB", 1));
        admin.deploy("AdminAPITestVDB-vdb.xml", (InputStream)new FileInputStream(new File("src/test/resources/adminapi-test-vdb.xml")));
        Assert.assertNotNull((Object)admin.getVDB("AdminAPITestVDB", 1));
    }

    @Test
    public void testRestartVDB() throws AdminException {
        admin.restartVDB("AdminAPITestVDB", 1, new String[]{"TestModel"});
        Assert.assertNotNull((Object)admin.getVDB("AdminAPITestVDB", 1));
    }

    @Test
    public void testGetTranslator() throws AdminException {
        for (Translator translator : admin.getTranslators()) {
            Assert.assertEquals((Object)"file", (Object)translator.getName());
            Assert.assertEquals((Object)"File Translator, reads contents of files or writes to them", (Object)translator.getDescription());
            Assert.assertEquals((Object)"false", (Object)translator.getProperties().getProperty("supportsOuterJoins"));
        }
        Translator translator = admin.getTranslator("file");
        Assert.assertEquals((Object)"File Translator, reads contents of files or writes to them", (Object)translator.getDescription());
        Assert.assertEquals((Object)"false", (Object)translator.getProperties().getProperty("supportsOuterJoins"));
    }

    @Test
    public void testGetWorkerPoolStats() throws AdminException {
        for (WorkerPoolStatistics pool : admin.getWorkerPoolStats()) {
            Assert.assertEquals((Object)"QueryProcessorQueue", (Object)pool.getQueueName());
            Assert.assertEquals((long)64L, (long)pool.getMaxThreads());
        }
    }

    @Test
    public void testGetCacheTypes() throws AdminException {
        Set cacheTypes = (Set)admin.getCacheTypes();
        Assert.assertTrue((boolean)cacheTypes.contains("PREPARED_PLAN_CACHE"));
        Assert.assertTrue((boolean)cacheTypes.contains("QUERY_SERVICE_RESULT_SET_CACHE"));
    }

    @Test
    public void testGetSessions() throws AdminException, SQLException {
        Connection conn = this.newSession();
        List sessions = (List)admin.getSessions();
        Assert.assertEquals((long)1L, (long)sessions.size());
        Assert.assertEquals((Object)"AdminAPITestVDB", (Object)((Session)sessions.get(0)).getVDBName());
        Assert.assertEquals((Object)"1", (Object)((Session)sessions.get(0)).getVDBVersion());
        Assert.assertEquals((Object)"JDBC", (Object)((Session)sessions.get(0)).getApplicationName());
        Assert.assertNotNull((Object)((Session)sessions.get(0)).getSessionId());
        conn.close();
    }

    @Test
    public void testGetRequests() throws AdminException, SQLException {
        Connection conn = this.newSession();
        Statement stmt = conn.createStatement();
        String command = "SELECT * FROM helloworld";
        ResultSet rs = stmt.executeQuery(command);
        List requests = (List)admin.getRequests();
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((Object)command, (Object)((RequestMetadata)requests.get(0)).getCommand());
        Assert.assertNotNull((Object)((RequestMetadata)requests.get(0)).getSessionId());
        rs.close();
        stmt.close();
        conn.close();
    }

    @Test
    public void testGetRequest() throws AdminException, SQLException {
        Connection conn = this.newSession();
        Statement stmt = conn.createStatement();
        String command = "SELECT * FROM helloworld";
        ResultSet rs = stmt.executeQuery(command);
        List sessions = (List)admin.getSessions();
        String id = ((Session)sessions.get(0)).getSessionId();
        List requests = (List)admin.getRequestsForSession(id);
        Assert.assertEquals((long)1L, (long)requests.size());
        Assert.assertEquals((Object)command, (Object)((Request)requests.get(0)).getCommand());
        Assert.assertEquals((Object)id, (Object)((Request)requests.get(0)).getSessionId());
        rs.close();
        stmt.close();
        conn.close();
    }

    @Test(expected=AdminProcessingException.class)
    public void testGetTemplatePropertyDefinitions() throws AdminException {
        admin.getTemplatePropertyDefinitions("file");
    }

    @Test
    public void testGetTranslatorPropertyDefinitions() throws AdminException {
        List list = (List)admin.getTranslatorPropertyDefinitions("file", Admin.TranlatorPropertyType.OVERRIDE);
        Assert.assertEquals((long)21L, (long)list.size());
        list = (List)admin.getTranslatorPropertyDefinitions("file", Admin.TranlatorPropertyType.ALL);
        Assert.assertEquals((long)21L, (long)list.size());
    }

    @Test
    public void testGetTransactions() throws AdminException, SQLException {
        Connection conn = this.newSession();
        conn.setAutoCommit(false);
        Assert.assertEquals((long)0L, (long)admin.getTransactions().size());
        conn.commit();
        conn.close();
    }

    public void testClearCache() throws AdminException {
        admin.clearCache("PREPARED_PLAN_CACHE");
        admin.clearCache("QUERY_SERVICE_RESULT_SET_CACHE");
        admin.clearCache("PREPARED_PLAN_CACHE", "AdminAPITestVDB", 1);
        admin.clearCache("QUERY_SERVICE_RESULT_SET_CACHE", "AdminAPITestVDB", 1);
    }

    @Test
    public void testGetCacheStats() throws AdminException {
        List list = (List)admin.getCacheStats("PREPARED_PLAN_CACHE");
        Assert.assertEquals((Object)((CacheStatistics)list.get(0)).getName(), (Object)Admin.Cache.PREPARED_PLAN_CACHE.name());
        list = (List)admin.getCacheStats("QUERY_SERVICE_RESULT_SET_CACHE");
        Assert.assertEquals((Object)((CacheStatistics)list.get(0)).getName(), (Object)Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.name());
    }

    @Test
    public void testGetEngineStats() throws AdminException, SQLException {
        Connection conn1 = this.newSession();
        Connection conn2 = this.newSession();
        List list = (List)admin.getEngineStats();
        Assert.assertEquals((long)2L, (long)((EngineStatistics)list.get(0)).getSessionCount());
        conn1.close();
        conn2.close();
    }

    @Test
    public void testTerminateSession() throws AdminException, SQLException {
        Connection conn = this.newSession();
        List sessions = (List)admin.getSessions();
        String sessionId = ((Session)sessions.get(0)).getSessionId();
        admin.terminateSession(sessionId);
        Assert.assertEquals((long)0L, (long)admin.getSessions().size());
        conn.close();
    }

    @Test
    public void testCancelRequest() throws AdminException, SQLException {
        Connection conn = this.newSession();
        Statement stmt = conn.createStatement();
        String command = "SELECT * FROM helloworld";
        ResultSet rs = stmt.executeQuery(command);
        List sessions = (List)admin.getSessions();
        String id = ((Session)sessions.get(0)).getSessionId();
        List requests = (List)admin.getRequestsForSession(id);
        long executionId = ((Request)requests.get(0)).getExecutionId();
        Assert.assertEquals((long)1L, (long)admin.getRequests().size());
        admin.cancelRequest(id, executionId);
        Assert.assertEquals((long)0L, (long)admin.getRequests().size());
        rs.close();
        stmt.close();
        conn.close();
    }

    @Ignore(value="This test need enable DataRole Configuration in 'adminapi-test-vdb.xml'")
    @Test
    public void testDataRoleMapping() throws AdminException {
        String vdbName = "AdminAPITestVDB";
        int vdbVersion = 1;
        String policyName = "TestDataRole";
        DataPolicyMetadata policy = this.getPolicy(admin.getVDB(vdbName, vdbVersion), policyName);
        Assert.assertEquals((long)1L, (long)policy.getMappedRoleNames().size());
        admin.addDataRoleMapping(vdbName, vdbVersion, policyName, "test-role-name");
        policy = this.getPolicy(admin.getVDB(vdbName, vdbVersion), policyName);
        Assert.assertEquals((long)2L, (long)policy.getMappedRoleNames().size());
        admin.removeDataRoleMapping(vdbName, vdbVersion, policyName, "test-role-name");
        policy = this.getPolicy(admin.getVDB(vdbName, vdbVersion), policyName);
        Assert.assertEquals((long)1L, (long)policy.getMappedRoleNames().size());
        boolean previous = policy.isAnyAuthenticated();
        admin.setAnyAuthenticatedForDataRole(vdbName, vdbVersion, policyName, !previous);
        policy = this.getPolicy(admin.getVDB(vdbName, vdbVersion), policyName);
        Assert.assertEquals((Object)(!previous ? 1 : 0), (Object)policy.isAnyAuthenticated());
        admin.setAnyAuthenticatedForDataRole(vdbName, vdbVersion, policyName, previous);
    }

    private DataPolicyMetadata getPolicy(VDB vdb, String policyName) {
        VDBMetaData vdbMetaData = (VDBMetaData)vdb;
        return (DataPolicyMetadata)vdbMetaData.getDataPolicyMap().get(policyName);
    }

    @Test
    public void testTerminateTransaction() throws AdminException {
        admin.terminateTransaction("xid");
    }

    @Test(expected=AdminProcessingException.class)
    public void testDataSources() throws AdminException {
        admin.createDataSource("", "", new Properties());
        admin.getDataSource("");
        admin.deleteDataSource("");
        admin.getDataSourceNames();
        admin.getDataSourceTemplateNames();
        admin.markDataSourceAvailable("");
    }

    @Test
    public void testGetSchema() throws AdminException {
        String expected = "CREATE VIEW helloworld (\n\texpr1 string\n)\nAS\nSELECT 'HELLO WORLD';";
        EnumSet<Admin.SchemaObjectType> allowedTypes = EnumSet.of(Admin.SchemaObjectType.TABLES);
        String schema = admin.getSchema("AdminAPITestVDB", 1, "TestModel", allowedTypes, "helloworld");
        Assert.assertEquals((Object)expected, (Object)schema);
        schema = admin.getSchema("AdminAPITestVDB", 1, "TestModel", null, null);
        Assert.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testGetQueryPlan() throws SQLException, AdminException {
        Connection conn = this.newSession();
        Statement stmt = conn.createStatement();
        stmt.execute("set showplan on");
        String command = "SELECT * FROM helloworld";
        ResultSet rs = stmt.executeQuery(command);
        List sessions = (List)admin.getSessions();
        String sessionId = ((Session)sessions.get(0)).getSessionId();
        List requests = (List)admin.getRequestsForSession(sessionId);
        int executionId = (int)((Request)requests.get(0)).getExecutionId();
        String plan = admin.getQueryPlan(sessionId, (long)executionId);
        Assert.assertNotNull((Object)plan);
        rs.close();
        stmt.close();
        conn.close();
    }

    @AfterClass
    public static void destory() throws SQLException {
        admin.close();
        server.stop();
    }
}

