/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.util.LinkedHashMap;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.BufferManagerFactory;
import org.teiid.deployers.CompositeGlobalTableStore;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.TestCompositeVDB;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.tempdata.GlobalTableStore;
import org.teiid.query.tempdata.GlobalTableStoreImpl;
import org.teiid.vdb.runtime.VDBKey;

public class TestCompositeGlobalTableStore {
    @Test
    public void testCompositeGlobalTableStore() throws VirtualDatabaseException {
        CompositeVDB vdb = TestCompositeVDB.createCompositeVDB(new MetadataStore(), "foo");
        GlobalTableStore gts = CompositeGlobalTableStore.createInstance((CompositeVDB)vdb, (BufferManager)BufferManagerFactory.getStandaloneBufferManager(), null);
        Assert.assertTrue((boolean)(gts instanceof GlobalTableStoreImpl));
        vdb.children = new LinkedHashMap();
        MetadataStore ms = new MetadataStore();
        Schema s = new Schema();
        s.setName("x");
        ms.addSchema(s);
        CompositeVDB imported = TestCompositeVDB.createCompositeVDB(ms, "foo");
        GlobalTableStore gts1 = (GlobalTableStore)Mockito.mock(GlobalTableStore.class);
        imported.getVDB().addAttchment(GlobalTableStore.class, (Object)gts1);
        vdb.getChildren().put(new VDBKey("foo1", (Object)1), imported);
        CompositeGlobalTableStore cgts = (CompositeGlobalTableStore)CompositeGlobalTableStore.createInstance((CompositeVDB)vdb, (BufferManager)BufferManagerFactory.getStandaloneBufferManager(), null);
        Assert.assertEquals((Object)gts1, (Object)cgts.getStoreForTable("#MAT_X.Y"));
        Assert.assertEquals((Object)cgts.getPrimary(), (Object)cgts.getStore("Z"));
    }
}

