/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadatastore;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.security.Principal;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginException;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.adminapi.PropertyDefinition;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.adminapi.impl.VDBMetadataParser;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.FileUtils;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.core.util.UnitTestUtil;
import org.teiid.jdbc.ConnectionImpl;
import org.teiid.jdbc.TeiidDriver;
import org.teiid.metadata.MetadataRepository;
import org.teiid.runtime.EmbeddedAdminImpl;
import org.teiid.runtime.EmbeddedConfiguration;
import org.teiid.runtime.EmbeddedServer;
import org.teiid.runtime.RuntimePlugin;
import org.teiid.runtime.TestEmbeddedServer;
import org.teiid.runtime.util.ConvertVDB;
import org.teiid.security.Credentials;
import org.teiid.security.GSSResult;
import org.teiid.security.SecurityHelper;
import org.teiid.translator.ExecutionFactory;
import org.teiid.translator.file.FileExecutionFactory;

public class TestDDLMetadataStore {
    static ExtendedEmbeddedServer es;

    @Before
    public void setup() {
        FileUtils.removeDirectoryAndChildren((File)new File(UnitTestUtil.getTestScratchPath()));
        es = new ExtendedEmbeddedServer();
    }

    @After
    public void teardown() {
        if (es != null) {
            es.stop();
        }
    }

    @Test
    public void testVDBExport() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        ec.setSecurityHelper((SecurityHelper)new ThreadLocalSecurityHelper());
        es.addTranslator("y", new TestEmbeddedServer.FakeTranslator(false));
        es.start(ec);
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        es.addMetadataRepository("myrepo", (MetadataRepository)Mockito.mock(MetadataRepository.class));
        es.deployVDB(new FileInputStream(UnitTestUtil.getTestDataPath() + "/first-db.ddl"), true);
        Admin admin = es.getAdmin();
        VDBMetaData vdb = (VDBMetaData)admin.getVDB("empty", "2");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        VDBMetadataParser.marshell((VDBMetaData)vdb, (OutputStream)out);
        String expected = ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/" + "first-vdb.xml"));
        Assert.assertEquals((Object)expected, (Object)new String(out.toByteArray()));
    }

    @Test
    public void testRoles() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        ec.setSecurityHelper((SecurityHelper)new ThreadLocalSecurityHelper());
        es.addTranslator("y", new TestEmbeddedServer.FakeTranslator(false));
        es.addTranslator("y2", new TestEmbeddedServer.FakeTranslator(false));
        AtomicInteger counter = new AtomicInteger();
        EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
        es.addConnectionFactoryProvider("z", (EmbeddedServer.ConnectionFactoryProvider)cfp);
        es.start(ec);
        es.addMetadataRepository("myrepo", (MetadataRepository)Mockito.mock(MetadataRepository.class));
        es.deployVDB(new FileInputStream(UnitTestUtil.getTestDataPath() + "/first-db.ddl"), true);
        TeiidDriver td = es.getDriver();
        ConnectionImpl c = td.connect("jdbc:teiid:empty", null);
        Statement s = c.createStatement();
        ResultSet rs = s.executeQuery("select * from mytable");
        Assert.assertFalse((boolean)rs.next());
        Assert.assertEquals((Object)"my-column", (Object)rs.getMetaData().getColumnLabel(1));
        s.execute("update mytable set \"my-column\" = 'a'");
        Assert.assertEquals((long)2L, (long)s.getUpdateCount());
        try {
            s.execute("delete from mytable where \"my-column\" = 'a'");
            Assert.fail((String)"should have stopped by roles");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConvertVDBXML() throws Exception {
        EmbeddedConfiguration ec = new EmbeddedConfiguration();
        ec.setUseDisk(false);
        es.addTranslator("file", (ExecutionFactory)new FileExecutionFactory());
        es.addTranslator("h2", new ExecutionFactory());
        es.start(ec);
        FileInputStream vdb = new FileInputStream(UnitTestUtil.getTestDataPath() + "/" + "portfolio-vdb.xml");
        es.deployVDB(vdb);
        String content = ConvertVDB.convert((File)new File(UnitTestUtil.getTestDataPath() + "/" + "portfolio-vdb.xml"));
        es.undeployVDB("Portfolio");
        String expected = ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/" + "portfolio-vdb.ddl"));
        Assert.assertEquals((Object)expected, (Object)content);
        es.deployVDB(new ByteArrayInputStream(content.getBytes("UTF-8")), true);
    }

    @Test
    public void testMigrateVDBXML() throws Exception {
        File vdb = new File(UnitTestUtil.getTestDataPath() + "/" + "portfolio-vdb.xml");
        String content = ConvertVDB.convert((File)vdb);
        String expected = ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/" + "portfolio-converted-vdb.ddl"));
        Assert.assertEquals((Object)expected, (Object)content);
    }

    @Test
    public void testOverideTranslator() throws Exception {
        File vdb = new File(UnitTestUtil.getTestDataPath() + "/" + "override-vdb.xml");
        String content = ConvertVDB.convert((File)vdb);
        String expected = ObjectConverterUtil.convertFileToString((File)new File(UnitTestUtil.getTestDataPath() + "/" + "override-vdb.ddl"));
        Assert.assertEquals((Object)expected, (Object)content);
    }

    public static class ThreadLocalSecurityHelper
    implements SecurityHelper {
        private static ThreadLocal<Subject> threadLocalContext = new ThreadLocal();

        public Object associateSecurityContext(Object context) {
            Subject previous = threadLocalContext.get();
            threadLocalContext.set((Subject)context);
            return previous;
        }

        public Object getSecurityContext() {
            return threadLocalContext.get();
        }

        public void clearSecurityContext() {
            threadLocalContext.remove();
        }

        public Subject getSubjectInContext(String securityDomain) {
            return threadLocalContext.get();
        }

        public Object authenticate(String securityDomain, String baseUserName, Credentials credentials, String applicationName) throws LoginException {
            Subject subject = new Subject();
            subject.getPrincipals().add((Principal)new SimpleGroup("superuser"));
            SimpleGroup rolesGroup = new SimpleGroup("Roles");
            rolesGroup.addMember((Principal)new SimplePrincipal("superuser"));
            rolesGroup.addMember((Principal)new SimplePrincipal("admin"));
            subject.getPrincipals().add((Principal)rolesGroup);
            return subject;
        }

        public Subject getSubjectInContext(Object context) {
            return (Subject)context;
        }

        public GSSResult negotiateGssLogin(String securityDomain, byte[] serviceTicket) throws LoginException {
            return null;
        }
    }

    private static class DatasourceAwareEmbeddedAdmin
    extends EmbeddedAdminImpl {
        HashSet<String> datasourceNames = new HashSet();

        public DatasourceAwareEmbeddedAdmin(EmbeddedServer embeddedServer) {
            super(embeddedServer);
        }

        public void createDataSource(String deploymentName, String templateName, Properties properties) throws AdminException {
            if (deploymentName.equals("z") && templateName.equals("custom")) {
                AtomicInteger counter = new AtomicInteger();
                EmbeddedServer.SimpleConnectionFactoryProvider cfp = new EmbeddedServer.SimpleConnectionFactoryProvider((Object)counter);
                es.addConnectionFactoryProvider(deploymentName, (EmbeddedServer.ConnectionFactoryProvider)cfp);
                this.datasourceNames.add(deploymentName);
            }
        }

        public Collection<? extends PropertyDefinition> getTemplatePropertyDefinitions(String templateName) throws AdminException {
            return Collections.emptyList();
        }

        public Properties getDataSource(String deployedName) throws AdminException {
            throw new AdminProcessingException(RuntimePlugin.Util.gs((BundleUtil.Event)RuntimePlugin.Event.TEIID40137, new Object[]{"getDataSource"}));
        }

        public void deleteDataSource(String deployedName) throws AdminException {
            if (deployedName.equals("z")) {
                this.datasourceNames.remove(deployedName);
            }
        }

        public Collection<String> getDataSourceNames() throws AdminException {
            return this.datasourceNames;
        }

        public Set<String> getDataSourceTemplateNames() throws AdminException {
            HashSet<String> names = new HashSet<String>();
            names.add("custom");
            return names;
        }
    }

    static final class ExtendedEmbeddedServer
    extends EmbeddedServer {
        ExtendedEmbeddedServer() {
        }

        public Admin getAdmin() {
            return new DatasourceAwareEmbeddedAdmin(this);
        }
    }
}

