/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.deployers;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.VDBImportMetadata;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.deployers.CompositeVDB;
import org.teiid.deployers.VDBRepository;
import org.teiid.deployers.VirtualDatabaseException;
import org.teiid.dqp.internal.datamgr.ConnectorManager;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.FunctionParameter;
import org.teiid.metadata.MetadataFactory;
import org.teiid.metadata.MetadataStore;
import org.teiid.metadata.Schema;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.unittest.RealMetadataFactory;
import org.teiid.translator.ExecutionFactory;

public class TestCompositeVDB {
    public static TransformationMetadata createTransformationMetadata(MetadataStore metadataStore, String vdbName) throws Exception {
        CompositeVDB cvdb = TestCompositeVDB.createCompositeVDB(metadataStore, vdbName);
        VDBMetaData vdb = cvdb.getVDB();
        return (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
    }

    public static CompositeVDB createCompositeVDB(MetadataStore metadataStore, String vdbName) throws VirtualDatabaseException {
        VDBMetaData vdbMetaData = TestCompositeVDB.createVDBMetadata(metadataStore, vdbName);
        vdbMetaData.addAttchment(Foo.class, (Object)new Foo());
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        cmr.addConnectorManager("source", TestCompositeVDB.getConnectorManager("FakeTranslator", "FakeConnection", TestCompositeVDB.getFuncsOne()));
        cmr.addConnectorManager("source2", TestCompositeVDB.getConnectorManager("FakeTranslator2", "FakeConnection2", TestCompositeVDB.getFuncsTwo()));
        CompositeVDB cvdb = new CompositeVDB(vdbMetaData, metadataStore, null, null, RealMetadataFactory.SFM.getSystemFunctions(), cmr, null, new MetadataStore[0]);
        cvdb.metadataLoadFinished(true);
        Assert.assertNotNull((Object)cvdb.getVDB().getAttachment(Foo.class));
        return cvdb;
    }

    static VDBMetaData createVDBMetadata(MetadataStore metadataStore, String vdbName) {
        VDBMetaData vdbMetaData = new VDBMetaData();
        vdbMetaData.setName(vdbName);
        vdbMetaData.setVersion(1);
        for (Schema schema : metadataStore.getSchemas().values()) {
            vdbMetaData.addModel(RealMetadataFactory.createModel((String)schema.getName(), (boolean)schema.isPhysical()));
        }
        return vdbMetaData;
    }

    private static ConnectorManager getConnectorManager(String translatorName, String connectionName, List<FunctionMethod> funcs) {
        ExecutionFactory ef = (ExecutionFactory)Mockito.mock(ExecutionFactory.class);
        Mockito.stub((Object)ef.getPushDownFunctions()).toReturn(funcs);
        ConnectorManager cm = new ConnectorManager(translatorName, connectionName, ef);
        cm.start();
        return cm;
    }

    private static List<FunctionMethod> getFuncsOne() {
        ArrayList<FunctionMethod> funcs = new ArrayList<FunctionMethod>();
        funcs.add(new FunctionMethod("echo", "echo", "misc", new FunctionParameter[]{new FunctionParameter("columnName", "string", "")}, new FunctionParameter("result", "string", "")));
        funcs.add(new FunctionMethod("duplicate_func", "duplicate", "misc", new FunctionParameter[]{new FunctionParameter("columnName", "string", "")}, new FunctionParameter("result", "string", "")));
        return funcs;
    }

    private static List<FunctionMethod> getFuncsTwo() {
        ArrayList<FunctionMethod> funcs = new ArrayList<FunctionMethod>();
        funcs.add(new FunctionMethod("duplicate_func", "duplicate", "misc", new FunctionParameter[]{new FunctionParameter("columnName", "string", "")}, new FunctionParameter("result", "string", "")));
        funcs.add(new FunctionMethod("duplicate_func", "duplicate", "misc", new FunctionParameter[]{new FunctionParameter("c1", "integer", ""), new FunctionParameter("c2", "string", "")}, new FunctionParameter("result", "string", "")));
        return funcs;
    }

    private void helpResolve(String sql) throws Exception {
        TransformationMetadata metadata = TestCompositeVDB.createTransformationMetadata((MetadataStore)RealMetadataFactory.exampleBQTCached().getMetadataStore(), "bqt");
        Command command = QueryParser.getQueryParser().parseCommand(sql);
        QueryResolver.resolveCommand((Command)command, (QueryMetadataInterface)metadata);
    }

    @Test(expected=VirtualDatabaseException.class)
    public void testImportErrors() throws Exception {
        VDBRepository repo = new VDBRepository();
        repo.setSystemStore((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore());
        repo.setSystemFunctionManager(RealMetadataFactory.SFM);
        CompositeMetadataStore metadataStore = RealMetadataFactory.exampleBQTCached().getMetadataStore();
        VDBMetaData vdb = TestCompositeVDB.createVDBMetadata((MetadataStore)metadataStore, "bqt");
        repo.addVDB(vdb, (MetadataStore)metadataStore, null, null, new ConnectorManagerRepository());
        vdb = TestCompositeVDB.createVDBMetadata((MetadataStore)metadataStore, "bqt1");
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName("foo");
        vdb.getVDBImports().add(vdbImport);
        try {
            repo.addVDB(vdb, (MetadataStore)metadataStore, null, null, new ConnectorManagerRepository());
            Assert.fail();
        }
        catch (VirtualDatabaseException virtualDatabaseException) {
            // empty catch block
        }
        vdb = TestCompositeVDB.createVDBMetadata((MetadataStore)metadataStore, "bqt1");
        vdbImport.setName("bqt");
        vdb.getVDBImports().add(vdbImport);
        repo.addVDB(vdb, (MetadataStore)metadataStore, null, null, new ConnectorManagerRepository());
    }

    @Test
    public void testImportVisibility() throws Exception {
        VDBRepository repo = new VDBRepository();
        repo.setSystemStore((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore());
        repo.setSystemFunctionManager(RealMetadataFactory.SFM);
        CompositeMetadataStore metadataStore = RealMetadataFactory.exampleBQTCached().getMetadataStore();
        VDBMetaData vdb = TestCompositeVDB.createVDBMetadata((MetadataStore)metadataStore, "bqt");
        repo.addVDB(vdb, (MetadataStore)metadataStore, null, null, new ConnectorManagerRepository());
        vdb = TestCompositeVDB.createVDBMetadata(RealMetadataFactory.exampleBusObjStore(), "example1");
        vdb.addProperty("BQT1.visible", "false");
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName("bqt");
        vdbImport.setVersion("1");
        vdb.getVDBImports().add(vdbImport);
        repo.addVDB(vdb, (MetadataStore)metadataStore, null, null, new ConnectorManagerRepository());
        Assert.assertTrue((boolean)vdb.isVisible("BQT1"));
        vdb = repo.getLiveVDB("example1");
        Assert.assertFalse((boolean)vdb.isVisible("BQT1"));
    }

    @Test
    public void testDeepNesting() throws Exception {
        VDBRepository repo = new VDBRepository();
        repo.setSystemStore((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore());
        repo.setSystemFunctionManager(RealMetadataFactory.SFM);
        MetadataStore metadataStore = new MetadataStore();
        RealMetadataFactory.createPhysicalModel((String)"x", (MetadataStore)metadataStore);
        VDBMetaData vdb = TestCompositeVDB.createVDBMetadata(metadataStore, "bqt");
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        cmr.addConnectorManager("x", new ConnectorManager("y", "z"));
        repo.addVDB(vdb, metadataStore, null, null, cmr);
        metadataStore = new MetadataStore();
        RealMetadataFactory.createPhysicalModel((String)"y", (MetadataStore)metadataStore);
        vdb = TestCompositeVDB.createVDBMetadata(metadataStore, "ex");
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName("bqt");
        vdbImport.setVersion("1");
        vdb.getVDBImports().add(vdbImport);
        repo.addVDB(vdb, metadataStore, null, null, new ConnectorManagerRepository());
        VDBMetaData vdbInstance = repo.getVDB("ex", (Object)"1");
        Assert.assertTrue((!((ConnectorManagerRepository)vdbInstance.getAttachment(ConnectorManagerRepository.class)).getConnectorManagers().isEmpty() ? 1 : 0) != 0);
        metadataStore = new MetadataStore();
        RealMetadataFactory.createPhysicalModel((String)"z", (MetadataStore)metadataStore);
        vdb = TestCompositeVDB.createVDBMetadata(metadataStore, "ex1");
        vdbImport = new VDBImportMetadata();
        vdbImport.setName("ex");
        vdbImport.setVersion("1");
        vdb.getVDBImports().add(vdbImport);
        repo.addVDB(vdb, metadataStore, null, null, new ConnectorManagerRepository());
        vdbInstance = repo.getVDB("ex1", (Object)"1");
        Assert.assertTrue((!((ConnectorManagerRepository)vdbInstance.getAttachment(ConnectorManagerRepository.class)).getConnectorManagers().isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testSourceMetadataStoreFunction() throws Exception {
        this.helpResolve("SELECT bqt1.reverse(BQT1.SmallA.INTKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testTranslatorDefinedFunction() throws Exception {
        this.helpResolve("SELECT SYS.echo(BQT1.SmallA.INTKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testPartialUDFName() throws Exception {
        this.helpResolve("SELECT echo(BQT1.SmallA.STRINGKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testFullyQualifiedDuplicate() throws Exception {
        this.helpResolve("SELECT SYS.duplicate_func(BQT1.SmallA.STRINGKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testNonQualifiedDuplicateWithDifferentSignature() throws Exception {
        this.helpResolve("SELECT duplicate_func(BQT1.SmallA.INTKEY, BQT1.SmallA.STRINGKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testNonQualifiedDuplicate() throws Exception {
        this.helpResolve("SELECT duplicate_func(BQT1.SmallA.INTKEY) FROM BQT1.SmallA");
    }

    @Test
    public void testRoleInherit() throws Exception {
        VDBRepository repo = new VDBRepository();
        repo.setSystemStore((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore());
        repo.setSystemFunctionManager(RealMetadataFactory.SFM);
        MetadataStore metadataStore = new MetadataStore();
        RealMetadataFactory.createPhysicalModel((String)"x", (MetadataStore)metadataStore);
        VDBMetaData vdb = TestCompositeVDB.createVDBMetadata(metadataStore, "bqt");
        DataPolicyMetadata dpm = new DataPolicyMetadata();
        dpm.setName("x");
        dpm.setGrantAll(true);
        vdb.addDataPolicy(dpm);
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        cmr.addConnectorManager("x", new ConnectorManager("y", "z"));
        repo.addVDB(vdb, metadataStore, null, null, cmr);
        metadataStore = new MetadataStore();
        RealMetadataFactory.createPhysicalModel((String)"y", (MetadataStore)metadataStore);
        vdb = TestCompositeVDB.createVDBMetadata(metadataStore, "ex");
        VDBImportMetadata vdbImport = new VDBImportMetadata();
        vdbImport.setName("bqt");
        vdbImport.setVersion("1");
        vdbImport.setImportDataPolicies(true);
        vdb.getVDBImports().add(vdbImport);
        repo.addVDB(vdb, metadataStore, null, null, new ConnectorManagerRepository());
        vdb = repo.getLiveVDB("ex");
        Assert.assertEquals((long)1L, (long)((DataPolicyMetadata)vdb.getDataPolicyMap().get("x")).getSchemas().size());
    }

    @Test
    public void testFunctionValidationError() throws Exception {
        VDBRepository repo = new VDBRepository();
        repo.start();
        repo.setSystemStore((MetadataStore)RealMetadataFactory.example1Cached().getMetadataStore());
        repo.setSystemFunctionManager(RealMetadataFactory.SFM);
        MetadataStore metadataStore = new MetadataStore();
        RealMetadataFactory.createPhysicalModel((String)"x", (MetadataStore)metadataStore);
        FunctionMethod method = MetadataFactory.createFunctionFromMethod((String)"getProperty", (Method)System.class.getMethod("getProperty", String.class));
        method.setInvocationClass("?");
        method.setMethod(null);
        metadataStore.getSchema("x").addFunction(method);
        VDBMetaData vdb = TestCompositeVDB.createVDBMetadata(metadataStore, "bqt");
        ConnectorManagerRepository cmr = new ConnectorManagerRepository();
        cmr.addConnectorManager("x", new ConnectorManager("y", "z"));
        repo.addVDB(vdb, metadataStore, null, null, cmr);
        repo.finishDeployment(vdb.getName(), vdb.getVersion());
        Assert.assertEquals((Object)vdb.getStatus(), (Object)VDB.Status.FAILED);
    }

    public static class Foo {
    }
}

