/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk;

import com.metamatrix.cdk.ConnectorShell;
import com.metamatrix.cdk.ConnectorShellCommandTarget;
import com.metamatrix.core.commandshell.CommandShell;
import com.metamatrix.core.commandshell.CommandShellTest;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.StringUtilities;
import com.metamatrix.core.util.UnitTestUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;

public class TestConnectorShell
extends CommandShellTest {
    private ConnectorShell connectorShell;
    private ConnectorShellCommandTarget commandTarget;

    public TestConnectorShell(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.commandTarget = new ConnectorShellCommandTarget();
        this.connectorShell = new ConnectorShell(this.commandTarget);
        this.connectorShell.setSilent(true);
        this.connectorShell.setPrintStackTraceOnException(false);
        this.connectorShell.setDefaultFilePath(UnitTestUtil.getTestDataPath() + File.separator);
    }

    public void testLoad() {
        String result = this.loadLoopBackConnector();
        TestConnectorShell.assertNull((Object)result);
    }

    private String loadLoopBackConnector() {
        return this.connectorShell.execute("load com.metamatrix.connector.loopback.LoopbackConnector partssupplier/PartsSupplier.vdb");
    }

    private void start() {
        this.connectorShell.execute("start");
    }

    public void testSelect() {
        this.loadLoopBackConnector();
        this.start();
        String result = this.connectorShell.execute("select * from partssupplier.partssupplier.parts;");
        TestConnectorShell.assertEquals((String)("PART_ID\tPART_NAME\tPART_COLOR\tPART_WEIGHT" + StringUtil.LINE_SEPARATOR + "ABCDEFGHIJ\tABCDEFGHIJ\tABCDEFGHIJ\tABCDEFGHIJ" + StringUtil.LINE_SEPARATOR), (String)result);
    }

    public void testRun() {
        this.loadLoopBackConnector();
        this.start();
        this.setScriptFile();
        this.connectorShell.turnOffExceptionHandling();
        String result = this.connectorShell.execute("run test1");
        TestConnectorShell.assertEquals((String)("Test " + UnitTestUtil.getTestDataPath() + File.separator + "script.txt.test1 failed.  CompareResults Error: Expected 1 records but received 2\n"), (String)result);
    }

    private void setScriptFile() {
        this.setScriptFile("script.txt");
    }

    private void setScriptFile(String fileName) {
        this.connectorShell.execute("setScriptFile " + UnitTestUtil.getTestDataPath() + File.separator + fileName);
    }

    public void testCallingScriptFromAnotherScriptFile() {
        this.commandTarget.setFailOnError(true);
        this.connectorShell.execute("setscriptfile " + UnitTestUtil.getTestDataPath() + File.separator + "s1.txt");
        TestConnectorShell.assertEquals((String)"", (String)this.connectorShell.execute("s3"));
        TestConnectorShell.assertEquals((String)"", (String)this.connectorShell.execute("s1"));
        this.connectorShell.execute("s4");
        this.connectorShell.execute("s2");
    }

    public void testCallingScriptFromAnotherScriptFileThatCallsAScript() {
        this.commandTarget.setFailOnError(true);
        this.connectorShell.setDefaultFilePath("");
        this.connectorShell.execute("setscriptfile " + UnitTestUtil.getTestDataPath() + File.separator + "s3.txt");
        TestConnectorShell.assertEquals((String)"", (String)this.connectorShell.execute("s3_3"));
    }

    public void testRunAllTests() {
        this.loadLoopBackConnector();
        this.start();
        this.setScriptFile();
        String result = this.connectorShell.execute("runAll");
        TestConnectorShell.assertEquals((String)("Test " + UnitTestUtil.getTestDataPath() + File.separator + "script.txt.test1 failed.  CompareResults Error: Expected 1 records but received 2\nTest " + UnitTestUtil.getTestDataPath() + File.separator + "script.txt.testBadData failed.  CompareResults Error: Value mismatch at row 1 and column 2: expected = XX, actual = ABCDEFGHIJ\nTests run: 16 test failures: 2"), (String)result);
    }

    public void testSetProperty() {
        this.connectorShell.setDefaultFilePath(UnitTestUtil.getTestDataPath() + File.separator);
        this.setScriptFile();
        String result = this.connectorShell.execute("run testSetProperty");
        TestConnectorShell.assertEquals((String)"", (String)result);
    }

    public void testSetPropertyAfterConnectorHostStart() {
        this.connectorShell.setDefaultFilePath(UnitTestUtil.getTestDataPath() + File.separator);
        this.setScriptFile();
        this.start();
        String result = this.connectorShell.execute("run testSetPropertyAfterConnectorHostStart");
        TestConnectorShell.assertEquals((String)"", (String)result);
    }

    public void testLoadingClearsProperties() {
        this.connectorShell.setDefaultFilePath(UnitTestUtil.getTestDataPath() + File.separator);
        this.setScriptFile();
        String result = this.connectorShell.execute("run testLoadingClearsProperties");
        TestConnectorShell.assertEquals((String)"", (String)result);
    }

    public void testRunAllTestsWithoutSetup() {
        this.loadLoopBackConnector();
        this.start();
        this.setScriptFile("scriptWithoutSetup.txt");
        String result = this.connectorShell.execute("runAll");
        TestConnectorShell.assertEquals((String)("Test " + UnitTestUtil.getTestDataPath() + File.separator + "scriptWithoutSetup.txt.test1 failed.  CompareResults Error: Expected 1 records but received 2\nTests run: 3 test failures: 1"), (String)result);
    }

    public void testCaseInsensitiveCommands() {
        this.loadLoopBackConnector();
        this.setScriptFile();
        String result = this.connectorShell.execute("run testCaseInsensitiveCommands");
        TestConnectorShell.assertEquals((String)"", (String)result);
    }

    public void testInvokingAsCommandLine() {
        new ConnectorShell(new ConnectorShellCommandTarget()).run(new String[]{"quit"}, UnitTestUtil.getTestScratchPath() + "/connector_shell.log");
    }

    protected CommandShell getCommandShell() {
        return this.connectorShell;
    }

    public void testTabsInResults() {
        this.runTest("testTabsInResults");
    }

    public void testLoadArchive() {
        this.runTest("testLoadArchive");
    }

    public void testCreateArchive() {
        File f = UnitTestUtil.getTestScratchFile((String)"foo.caf");
        f.delete();
        this.connectorShell.execute("createArchive " + UnitTestUtil.getTestScratchPath() + "/foo.caf " + UnitTestUtil.getTestDataPath() + "/sample/sample2.cdk " + UnitTestUtil.getTestDataPath() + "/sample");
        TestConnectorShell.assertTrue((String)"failed to create archive file", (boolean)f.exists());
    }

    public void testBracketsInResult() {
        this.runTest("testBracketsInResult");
    }

    public void testHelp() {
        this.runTest("testHelp");
    }

    public void testNotLoadingConnector() {
        this.runTest("testNotLoadingConnector");
    }

    public void testStart() {
        this.loadLoopBackConnector();
        this.connectorShell.execute("start");
    }

    public void testStop() {
        this.loadLoopBackConnector();
        this.start();
        this.connectorShell.execute("stop");
    }

    public void testLoadXMLProperties() {
        this.loadLoopBackConnector();
        this.connectorShell.execute("loadProperties " + UnitTestUtil.getTestDataPath() + File.separator + "properties.cdk");
        this.start();
        String loadedProperties = this.connectorShell.execute("getProperties");
        String expected = new StringBuffer("property1=PropVal1").append(StringUtilities.LINE_SEPARATOR).append("property2=PropVal2").append(StringUtilities.LINE_SEPARATOR).append("property3=com.metamatrix.cdk.propertyVal").append(StringUtilities.LINE_SEPARATOR).toString();
        TestConnectorShell.assertEquals((String)expected, (String)loadedProperties);
    }

    public void testLoadPropertiesFromPropertiesFile() {
        this.loadLoopBackConnector();
        this.connectorShell.execute("loadProperties " + UnitTestUtil.getTestDataPath() + File.separator + "connector.properties");
        this.start();
        String loadedProperties = this.connectorShell.execute("getProperties");
        TestConnectorShell.assertNotNull((Object)loadedProperties);
        String expected = new StringBuffer("property1=PropVal1").append(StringUtilities.LINE_SEPARATOR).append("property2=PropVal2").append(StringUtilities.LINE_SEPARATOR).append("property3=com.metamatrix.cdk.propertyVal").append(StringUtilities.LINE_SEPARATOR).toString();
        TestConnectorShell.assertEquals((String)expected, (String)loadedProperties);
    }

    public void testCreateTemplateFileDoesNotExistNoPath() throws FileNotFoundException, IOException {
        this.runTemplateTestAndDeleteFile("testTemplate1");
    }

    public void testCreateTemplateFileDoesNotExist() throws FileNotFoundException, IOException {
        this.runTemplateTestAndDeleteFile("testTemplate2");
    }

    private void runTemplateTestAndDeleteFile(String fileName) throws FileNotFoundException, IOException {
        fileName = UnitTestUtil.getTestScratchPath() + File.separator + fileName;
        new File(fileName).delete();
        this.runTemplateTest(fileName);
    }

    private void runTemplateTest(String tempFileName) throws FileNotFoundException, IOException {
        this.connectorShell.execute("setFailOnError true");
        this.connectorShell.execute("createTemplate " + tempFileName);
        FileInputStream template = new FileInputStream(new File(tempFileName));
        InputStream original = ((Object)((Object)this)).getClass().getResourceAsStream("Template.cdk");
        int originalByte = 0;
        int tempByte = 0;
        int bytesCompared = 0;
        while ((originalByte = original.read()) != -1 && (tempByte = template.read()) != -1) {
            TestConnectorShell.assertEquals((int)originalByte, (int)tempByte);
            ++bytesCompared;
        }
        TestConnectorShell.assertTrue((bytesCompared > 0 ? 1 : 0) != 0);
        TestConnectorShell.assertEquals((int)-1, (int)originalByte);
        template.close();
        original.close();
    }
}

