/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.cdk.api;

import com.metamatrix.core.commandshell.ConnectorResultUtility;
import com.metamatrix.core.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;

public class TestConnectorResultUtility
extends TestCase {
    List bob1;
    List bob2;
    List jim1;
    List bobShort;
    List bobMultiLineWithTabs;
    List nullList;
    List results1;
    List results2;

    public TestConnectorResultUtility(String name) {
        super(name);
    }

    public void testSame() {
        this.results1.add(this.bob1);
        this.results1.add(this.jim1);
        this.results2.add(this.bob1);
        this.results2.add(this.jim1);
        String expected = ConnectorResultUtility.resultsToString((List)this.results1);
        String actual = ConnectorResultUtility.resultsToString((List)this.results2);
        String result = ConnectorResultUtility.compareResultsStrings((String)expected, (String)actual);
        TestConnectorResultUtility.assertNull((Object)result);
    }

    public void testDifferent() {
        this.results1.add(this.bob1);
        this.results1.add(this.jim1);
        this.results2.add(this.bob2);
        this.results2.add(this.jim1);
        String expected = ConnectorResultUtility.resultsToString((List)this.results1);
        String actual = ConnectorResultUtility.resultsToString((List)this.results2);
        String result = ConnectorResultUtility.compareResultsStrings((String)expected, (String)actual);
        TestConnectorResultUtility.assertEquals((String)"CompareResults Error: Value mismatch at row 1 and column 1: expected = 45, actual = 25", (String)result);
    }

    public void testTooFewRows() {
        this.results1.add(this.bob1);
        this.results1.add(this.jim1);
        this.results2.add(this.bob1);
        String expected = ConnectorResultUtility.resultsToString((List)this.results1);
        String actual = ConnectorResultUtility.resultsToString((List)this.results2);
        String result = ConnectorResultUtility.compareResultsStrings((String)expected, (String)actual);
        TestConnectorResultUtility.assertEquals((String)"CompareResults Error: Expected 3 records but received only 2", (String)result);
    }

    public void testTooManyRows() {
        this.results1.add(this.bob1);
        this.results2.add(this.bob1);
        this.results2.add(this.jim1);
        String expected = ConnectorResultUtility.resultsToString((List)this.results1);
        String actual = ConnectorResultUtility.resultsToString((List)this.results2);
        String result = ConnectorResultUtility.compareResultsStrings((String)expected, (String)actual);
        TestConnectorResultUtility.assertEquals((String)"CompareResults Error: Expected 2 records but received 3", (String)result);
    }

    public void testNullColumns() {
        this.results1.add(this.bob1);
        this.results2.add(this.nullList);
        String expected = ConnectorResultUtility.resultsToString((List)this.results1);
        String actual = ConnectorResultUtility.resultsToString((List)this.results2);
        String result = ConnectorResultUtility.compareResultsStrings((String)expected, (String)actual);
        TestConnectorResultUtility.assertEquals((String)"CompareResults Error: Value mismatch at row 1 and column 0: expected = bob, actual = <null>", (String)result);
    }

    public void testNullColumnInFirstRowWithDataLater() {
        this.results1.add(this.nullList);
        this.results1.add(this.bob1);
        String result = ConnectorResultUtility.resultsToString((List)this.results1);
        TestConnectorResultUtility.assertEquals((String)("col1\tcol2" + StringUtil.LINE_SEPARATOR + "<null>\t<null>" + StringUtil.LINE_SEPARATOR + "bob\t45" + StringUtil.LINE_SEPARATOR), (String)result);
    }

    public void testNullColumnInFirstRowWithNoDataLater() {
        this.results1.add(this.nullList);
        this.results1.add(this.nullList);
        String result = ConnectorResultUtility.resultsToString((List)this.results1);
        TestConnectorResultUtility.assertEquals((String)("col1\tcol2" + StringUtil.LINE_SEPARATOR + "<null>\t<null>" + StringUtil.LINE_SEPARATOR + "<null>\t<null>" + StringUtil.LINE_SEPARATOR), (String)result);
    }

    public void testTooFewColumns() {
        this.results1.add(this.bob1);
        this.results2.add(this.bobShort);
        String expected = ConnectorResultUtility.resultsToString((List)this.results1);
        String actual = ConnectorResultUtility.resultsToString((List)this.results2);
        String result = ConnectorResultUtility.compareResultsStrings((String)expected, (String)actual);
        TestConnectorResultUtility.assertEquals((String)"Incorrect number of columns at row = 0, expected = 2, actual = 1", (String)result);
    }

    public void testTooManyColumns() {
        this.results1.add(this.bobShort);
        this.results2.add(this.bob1);
        String expected = ConnectorResultUtility.resultsToString((List)this.results1);
        String actual = ConnectorResultUtility.resultsToString((List)this.results2);
        String result = ConnectorResultUtility.compareResultsStrings((String)expected, (String)actual);
        TestConnectorResultUtility.assertEquals((String)"Incorrect number of columns at row = 0, expected = 1, actual = 2", (String)result);
    }

    public void testTabsAndNewLines() {
        this.results1.add(this.bobMultiLineWithTabs);
        String result = ConnectorResultUtility.resultsToString((List)this.results1);
        TestConnectorResultUtility.assertEquals((String)("col1\tcol2" + StringUtil.LINE_SEPARATOR + "bob\\tsmith\\nEsquire\t45" + StringUtil.LINE_SEPARATOR), (String)result);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.bob1 = new ArrayList();
        this.bob1.add("bob");
        this.bob1.add(new Integer(45));
        this.jim1 = new ArrayList();
        this.jim1.add("jim");
        this.jim1.add(new Integer(19));
        this.bob2 = new ArrayList();
        this.bob2.add("bob");
        this.bob2.add(new Integer(25));
        this.bobShort = new ArrayList();
        this.bobShort.add("bob");
        this.bobMultiLineWithTabs = new ArrayList();
        this.bobMultiLineWithTabs.add("bob\tsmith\nEsquire");
        this.bobMultiLineWithTabs.add(new Integer(45));
        this.nullList = new ArrayList();
        this.nullList.add(null);
        this.nullList.add(null);
        this.results1 = new ArrayList();
        this.results2 = new ArrayList();
    }
}

